/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.epicpaladins.common.registries.items;

import com.google.common.base.Suppliers;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.veroxuniverse.epicpaladins.common.registries.ItemsRegistry;
import org.jetbrains.annotations.NotNull;

public enum ArmorMaterialsRegistry implements ArmorMaterial
{
    ARCLIGHT("arclight", 45, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), armor -> {
        armor.put(ArmorItem.Type.BOOTS, 4);
        armor.put(ArmorItem.Type.LEGGINGS, 7);
        armor.put(ArmorItem.Type.CHESTPLATE, 9);
        armor.put(ArmorItem.Type.HELMET, 4);
    }), 20, SoundEvents.f_11673_, 2.5f, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.ARCLIGHT_GEM.get()})),
    CRYORIUM("cryorium", 45, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), armor -> {
        armor.put(ArmorItem.Type.BOOTS, 4);
        armor.put(ArmorItem.Type.LEGGINGS, 7);
        armor.put(ArmorItem.Type.CHESTPLATE, 9);
        armor.put(ArmorItem.Type.HELMET, 4);
    }), 20, SoundEvents.f_11673_, 2.5f, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.CRYORIUM_GEM.get()})),
    JADE("jade", 45, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), armor -> {
        armor.put(ArmorItem.Type.BOOTS, 4);
        armor.put(ArmorItem.Type.LEGGINGS, 7);
        armor.put(ArmorItem.Type.CHESTPLATE, 9);
        armor.put(ArmorItem.Type.HELMET, 4);
    }), 20, SoundEvents.f_11673_, 2.5f, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.JADE_GEM.get()})),
    MOONLIGHT("moonlight", 45, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), armor -> {
        armor.put(ArmorItem.Type.BOOTS, 4);
        armor.put(ArmorItem.Type.LEGGINGS, 7);
        armor.put(ArmorItem.Type.CHESTPLATE, 9);
        armor.put(ArmorItem.Type.HELMET, 4);
    }), 20, SoundEvents.f_11673_, 2.5f, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.MOONLIGHT_GEM.get()})),
    BLOODSTONE("bloodstone", 45, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), armor -> {
        armor.put(ArmorItem.Type.BOOTS, 4);
        armor.put(ArmorItem.Type.LEGGINGS, 7);
        armor.put(ArmorItem.Type.CHESTPLATE, 9);
        armor.put(ArmorItem.Type.HELMET, 4);
    }), 20, SoundEvents.f_11673_, 2.5f, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.BLOODSTONE_GEM.get()})),
    SCULK("sculk", 45, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), armor -> {
        armor.put(ArmorItem.Type.BOOTS, 4);
        armor.put(ArmorItem.Type.LEGGINGS, 7);
        armor.put(ArmorItem.Type.CHESTPLATE, 9);
        armor.put(ArmorItem.Type.HELMET, 4);
    }), 20, SoundEvents.f_11673_, 2.5f, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_220224_})),
    STEEL("steel", 45, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), armor -> {
        armor.put(ArmorItem.Type.BOOTS, 2);
        armor.put(ArmorItem.Type.LEGGINGS, 4);
        armor.put(ArmorItem.Type.CHESTPLATE, 6);
        armor.put(ArmorItem.Type.HELMET, 2);
    }), 20, SoundEvents.f_11673_, 0.5f, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.STEEL_INGOT.get()}));

    private static final EnumMap<ArmorItem.Type, Integer> HEALTH_FUNCTION_FOR_TYPE;
    private final String name;
    private final int durabilityMultiplier;
    private final EnumMap<ArmorItem.Type, Integer> protectionFunctionForType;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final Supplier<Ingredient> repairIngredient;

    private ArmorMaterialsRegistry(String name, int durabilityMultiplier, EnumMap<ArmorItem.Type, Integer> protection, int enchantmentValue, SoundEvent soundEvent, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.protectionFunctionForType = protection;
        this.enchantmentValue = enchantmentValue;
        this.sound = soundEvent;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = Suppliers.memoize(repairIngredient::get);
    }

    public int m_266425_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ArmorItem.Type typeDurability) {
        return HEALTH_FUNCTION_FOR_TYPE.get(typeDurability) * this.durabilityMultiplier;
    }

    public int m_7366_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ArmorItem.Type typeDefense) {
        return this.protectionFunctionForType.get(typeDefense);
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    @NotNull
    public SoundEvent m_7344_() {
        return this.sound;
    }

    @NotNull
    public Ingredient m_6230_() {
        return this.repairIngredient.get();
    }

    @NotNull
    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        HEALTH_FUNCTION_FOR_TYPE = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), p_266653_ -> {
            p_266653_.put(ArmorItem.Type.BOOTS, 13);
            p_266653_.put(ArmorItem.Type.LEGGINGS, 15);
            p_266653_.put(ArmorItem.Type.CHESTPLATE, 16);
            p_266653_.put(ArmorItem.Type.HELMET, 11);
        });
    }
}

