/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.epicpaladins.common.registries;

import java.util.function.Supplier;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.veroxuniverse.epicpaladins.common.registries.ItemsRegistry;

public class BlocksRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"epicpaladins");
    public static final RegistryObject<Block> DEEPSLATE_ARCLIGHT_ORE = BlocksRegistry.registerBlock("deepslate_arclight_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_(), (IntProvider)UniformInt.m_146622_((int)3, (int)7)));
    public static final RegistryObject<Block> ARCLIGHT_ORE = BlocksRegistry.registerBlock("arclight_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_(), (IntProvider)UniformInt.m_146622_((int)3, (int)7)));
    public static final RegistryObject<Block> ARCLIGHT_BLOCK = BlocksRegistry.registerBlock("arclight_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50090_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> DEEPSLATE_CRYORIUM_ORE = BlocksRegistry.registerBlock("deepslate_cryorium_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_(), (IntProvider)UniformInt.m_146622_((int)3, (int)7)));
    public static final RegistryObject<Block> CRYORIUM_ORE = BlocksRegistry.registerBlock("cryorium_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_(), (IntProvider)UniformInt.m_146622_((int)3, (int)7)));
    public static final RegistryObject<Block> CRYORIUM_BLOCK = BlocksRegistry.registerBlock("cryorium_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50090_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> DEEPSLATE_BLOODSTONE_ORE = BlocksRegistry.registerBlock("deepslate_bloodstone_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_(), (IntProvider)UniformInt.m_146622_((int)3, (int)7)));
    public static final RegistryObject<Block> BLOODSTONE_ORE = BlocksRegistry.registerBlock("bloodstone_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_(), (IntProvider)UniformInt.m_146622_((int)3, (int)7)));
    public static final RegistryObject<Block> BLOODSTONE_BLOCK = BlocksRegistry.registerBlock("bloodstone_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50090_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> JADE_ORE = BlocksRegistry.registerBlock("jade_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_(), (IntProvider)UniformInt.m_146622_((int)3, (int)7)));
    public static final RegistryObject<Block> JADE_BLOCK = BlocksRegistry.registerBlock("jade_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50090_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> MOONLIGHT_ORE = BlocksRegistry.registerBlock("moonlight_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60978_(4.0f).m_60999_(), (IntProvider)UniformInt.m_146622_((int)3, (int)7)));
    public static final RegistryObject<Block> MOONLIGHT_BLOCK = BlocksRegistry.registerBlock("moonlight_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50090_).m_60978_(4.0f).m_60999_()));
    public static final RegistryObject<Block> STEEL_BLOCK = BlocksRegistry.registerBlock("steel_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50090_).m_60978_(4.0f).m_60999_()));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        BlocksRegistry.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<T> registerBlockWithoutBlockItem(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ItemsRegistry.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

