/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.ench.table;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.apotheosis.ench.Ench;
import dev.shadowsoffire.apotheosis.ench.enchantments.InertEnchantment;
import dev.shadowsoffire.apotheosis.ench.table.ApothEnchantmentMenu;
import dev.shadowsoffire.apotheosis.ench.table.EnchantingInfoScreen;
import dev.shadowsoffire.apotheosis.ench.table.EnchantingRecipe;
import dev.shadowsoffire.apotheosis.ench.table.EnchantingStatRegistry;
import dev.shadowsoffire.apotheosis.util.ApothMiscUtil;
import dev.shadowsoffire.apotheosis.util.DrawsOnLeft;
import dev.shadowsoffire.placebo.util.EnchantmentUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EnchantmentNames;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;

public class ApothEnchantScreen
extends EnchantmentScreen
implements DrawsOnLeft {
    public static final ResourceLocation TEXTURES = new ResourceLocation("apotheosis", "textures/gui/enchanting_table.png");
    protected final ApothEnchantmentMenu menu;
    protected final Int2ObjectMap<List<EnchantmentInstance>> clues = new Int2ObjectOpenHashMap();
    protected float eterna = 0.0f;
    protected float lastEterna = 0.0f;
    protected float quanta = 0.0f;
    protected float lastQuanta = 0.0f;
    protected float arcana = 0.0f;
    protected float lastArcana = 0.0f;
    protected boolean[] hasAllClues = new boolean[]{false, false, false};

    public ApothEnchantScreen(EnchantmentMenu container, Inventory inv, Component title) {
        super(container, inv, title);
        this.menu = (ApothEnchantmentMenu)container;
        this.f_97727_ = 197;
        this.clues.defaultReturnValue(new ArrayList());
    }

    protected void m_280003_(GuiGraphics gfx, int mouseX, int mouseY) {
        gfx.m_280614_(this.f_96547_, this.f_96539_, 12, 5, 0x404040, false);
        gfx.m_280614_(this.f_96547_, this.f_169604_, 7, this.f_97727_ - 96 + 4, 0x404040, false);
        gfx.m_280056_(this.f_96547_, I18n.m_118938_((String)"gui.apotheosis.enchant.eterna", (Object[])new Object[0]), 19, 74, 4044093, false);
        gfx.m_280056_(this.f_96547_, I18n.m_118938_((String)"gui.apotheosis.enchant.quanta", (Object[])new Object[0]), 19, 84, 16536660, false);
        gfx.m_280056_(this.f_96547_, I18n.m_118938_((String)"gui.apotheosis.enchant.arcana", (Object[])new Object[0]), 19, 94, 0xA800A8, false);
    }

    public void m_181908_() {
        super.m_181908_();
        float current = this.menu.stats.eterna();
        if (current != this.eterna) {
            this.eterna = current > this.eterna ? (this.eterna += Math.min(current - this.eterna, Math.max(0.16f, (current - this.eterna) * 0.1f))) : Math.max(this.eterna - this.lastEterna * 0.075f, current);
        }
        if (current > 0.0f) {
            this.lastEterna = current;
        }
        if ((current = this.menu.stats.quanta()) != this.quanta) {
            this.quanta = current > this.quanta ? (this.quanta += Math.min(current - this.quanta, Math.max(0.04f, (current - this.quanta) * 0.1f))) : Math.max(this.quanta - this.lastQuanta * 0.075f, current);
        }
        if (current > 0.0f) {
            this.lastQuanta = current;
        }
        if ((current = this.menu.stats.arcana()) != this.arcana) {
            this.arcana = current > this.arcana ? (this.arcana += Math.min(current - this.arcana, Math.max(0.04f, (current - this.arcana) * 0.1f))) : Math.max(this.arcana - this.lastArcana * 0.075f, current);
        }
        if (current > 0.0f) {
            this.lastArcana = current;
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        for (int k = 0; k < 3; ++k) {
            double d0 = pMouseX - (double)(i + 60);
            double d1 = pMouseY - (double)(j + 14 + 19 * k);
            if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 108.0) || !(d1 < 19.0) || !this.menu.m_6366_((Player)this.f_96541_.f_91074_, k)) continue;
            this.f_96541_.f_91072_.m_105208_(this.menu.f_38840_, k);
            return true;
        }
        if (this.menu.m_38853_(0).m_6657_() && this.m_6774_(145, -15, 27, 15, pMouseX, pMouseY) && Arrays.stream(this.menu.f_39447_).boxed().map(Enchantment::m_44697_).allMatch((Predicate<Enchantment>)Predicates.notNull())) {
            Minecraft.m_91087_().pushGuiLayer((Screen)new EnchantingInfoScreen(this));
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    protected void m_7286_(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        int xCenter = (this.f_96543_ - this.f_97726_) / 2;
        int yCenter = (this.f_96544_ - this.f_97727_) / 2;
        gfx.m_280218_(TEXTURES, xCenter, yCenter, 0, 0, this.f_97726_, this.f_97727_);
        this.m_289602_(gfx, xCenter, yCenter, partialTicks);
        EnchantmentNames.m_98734_().m_98735_((long)this.menu.m_39493_());
        int lapis = this.menu.m_39492_();
        for (int slot = 0; slot < 3; ++slot) {
            int j1 = xCenter + 60;
            int k1 = j1 + 20;
            int level = this.menu.f_39446_[slot];
            if (level == 0) {
                gfx.m_280218_(TEXTURES, j1, yCenter + 14 + 19 * slot, 148, 218, 108, 19);
                continue;
            }
            String s = "" + level;
            int width = 86 - this.f_96547_.m_92895_(s);
            FormattedText itextproperties = EnchantmentNames.m_98734_().m_98737_(this.f_96547_, width);
            int color = 6839882;
            if ((lapis < slot + 1 || this.f_96541_.f_91074_.f_36078_ < level) && !this.f_96541_.f_91074_.m_150110_().f_35937_ || this.menu.f_39447_[slot] == -1) {
                gfx.m_280218_(TEXTURES, j1, yCenter + 14 + 19 * slot, 148, 218, 108, 19);
                gfx.m_280218_(TEXTURES, j1 + 1, yCenter + 15 + 19 * slot, 16 * slot, 239, 16, 16);
                gfx.m_280554_(this.f_96547_, itextproperties, k1, yCenter + 16 + 19 * slot, width, (color & 0xFEFEFE) >> 1);
                color = 4226832;
            } else {
                int k2 = mouseX - (xCenter + 60);
                int l2 = mouseY - (yCenter + 14 + 19 * slot);
                if (k2 >= 0 && l2 >= 0 && k2 < 108 && l2 < 19) {
                    gfx.m_280218_(TEXTURES, j1, yCenter + 14 + 19 * slot, 148, 237, 108, 19);
                    color = 0xFFFF80;
                } else {
                    gfx.m_280218_(TEXTURES, j1, yCenter + 14 + 19 * slot, 148, 199, 108, 19);
                }
                gfx.m_280218_(TEXTURES, j1 + 1, yCenter + 15 + 19 * slot, 16 * slot, 223, 16, 16);
                gfx.m_280554_(this.f_96547_, itextproperties, k1, yCenter + 16 + 19 * slot, width, color);
                color = 8453920;
            }
            gfx.m_280488_(this.f_96547_, s, k1 + 86 - this.f_96547_.m_92895_(s), yCenter + 16 + 19 * slot + 7, color);
        }
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURES);
        if (this.eterna > 0.0f) {
            gfx.m_280218_(TEXTURES, xCenter + 59, yCenter + 75, 0, 197, (int)(this.eterna / EnchantingStatRegistry.getAbsoluteMaxEterna() * 110.0f), 5);
        }
        if (this.quanta > 0.0f) {
            gfx.m_280218_(TEXTURES, xCenter + 59, yCenter + 85, 0, 202, (int)(this.quanta / 100.0f * 110.0f), 5);
        }
        if (this.arcana > 0.0f) {
            gfx.m_280218_(TEXTURES, xCenter + 59, yCenter + 95, 0, 207, (int)(this.arcana / 100.0f * 110.0f), 5);
        }
        if (this.menu.m_38853_(0).m_6657_() && Arrays.stream(this.menu.f_39447_).boxed().map(Enchantment::m_44697_).allMatch((Predicate<Enchantment>)Predicates.notNull())) {
            int u = this.m_6774_(145, -15, 27, 15, mouseX, mouseY) ? 15 : 0;
            gfx.m_280218_(TEXTURES, xCenter + 145, yCenter - 15, this.f_97726_, u, 27, 15);
        }
    }

    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        partialTicks = this.f_96541_.m_91296_();
        this.m_280273_(gfx);
        ((SuperRender)((Object)this)).apoth_superRender(gfx, mouseX, mouseY, partialTicks);
        this.m_280072_(gfx, mouseX, mouseY);
        boolean creative = this.f_96541_.f_91074_.m_150110_().f_35937_;
        int lapis = this.menu.m_39492_();
        for (int slot = 0; slot < 3; ++slot) {
            boolean isFailedInfusion;
            int level = this.menu.f_39446_[slot];
            Enchantment enchantment = Enchantment.m_44697_((int)this.menu.f_39447_[slot]);
            int cost = slot + 1;
            if (!this.m_6774_(60, 14 + 19 * slot, 108, 17, mouseX, mouseY) || level <= 0) continue;
            ArrayList list = Lists.newArrayList();
            boolean bl = isFailedInfusion = slot == 2 && enchantment == null && EnchantingRecipe.findItemMatch((Level)this.f_96541_.f_91073_, this.menu.m_38853_(0).m_7993_()) != null;
            if (enchantment != null) {
                if (!((List)this.clues.get(slot)).isEmpty()) {
                    list.add(Component.m_237115_((String)("info.apotheosis.runes" + (this.hasAllClues[slot] ? "_all" : ""))).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
                    for (EnchantmentInstance i : (List)this.clues.get(slot)) {
                        list.add(i.f_44947_.m_44700_(i.f_44948_));
                    }
                } else {
                    list.add(Component.m_237115_((String)"info.apotheosis.no_clue").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.UNDERLINE}));
                }
            } else if (isFailedInfusion) {
                list.add(((InertEnchantment)((Object)Ench.Enchantments.INFUSION.get())).m_44700_(1).m_6881_().m_130940_(ChatFormatting.ITALIC));
                Collections.addAll(list, Component.m_237113_((String)""), Component.m_237115_((String)"info.apotheosis.infusion_failed").m_130940_(ChatFormatting.RED));
            } else {
                list.add(Component.m_237110_((String)"container.enchant.clue", (Object[])new Object[]{""}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                Collections.addAll(list, Component.m_237113_((String)""), Component.m_237115_((String)"forge.container.enchant.limitedEnchantability").m_130940_(ChatFormatting.RED));
            }
            if (enchantment != null && !creative) {
                list.add(Component.m_237113_((String)""));
                if (this.f_96541_.f_91074_.f_36078_ < level) {
                    list.add(Component.m_237110_((String)"container.enchant.level.requirement", (Object[])new Object[]{this.menu.f_39446_[slot]}).m_130940_(ChatFormatting.RED));
                } else {
                    String s = cost == 1 ? I18n.m_118938_((String)"container.enchant.lapis.one", (Object[])new Object[0]) : I18n.m_118938_((String)"container.enchant.lapis.many", (Object[])new Object[]{cost});
                    ChatFormatting textformatting = lapis >= cost ? ChatFormatting.GRAY : ChatFormatting.RED;
                    list.add(Component.m_237113_((String)s).m_130940_(textformatting));
                    s = cost == 1 ? I18n.m_118938_((String)"container.enchant.level.one", (Object[])new Object[0]) : I18n.m_118938_((String)"container.enchant.level.many", (Object[])new Object[]{cost});
                    list.add(Component.m_237113_((String)s).m_130940_(ChatFormatting.GRAY));
                }
            }
            gfx.m_280666_(this.f_96547_, (List)list, mouseX, mouseY);
            break;
        }
        if (this.m_6774_(60, 76, 110, 5, mouseX, mouseY)) {
            ArrayList list = Lists.newArrayList();
            list.add(Component.m_237113_((String)(ApothEnchantScreen.eterna() + I18n.m_118938_((String)"gui.apotheosis.enchant.eterna.desc", (Object[])new Object[0]))));
            list.add(Component.m_237115_((String)"gui.apotheosis.enchant.eterna.desc2").m_130940_(ChatFormatting.GRAY));
            if (this.menu.stats.eterna() > 0.0f) {
                list.add(Component.m_237113_((String)""));
                list.add(Component.m_237113_((String)I18n.m_118938_((String)"gui.apotheosis.enchant.eterna.desc3", (Object[])new Object[]{ApothEnchantScreen.f(this.menu.stats.eterna()), Float.valueOf(EnchantingStatRegistry.getAbsoluteMaxEterna())})).m_130940_(ChatFormatting.GRAY));
            }
            gfx.m_280666_(this.f_96547_, (List)list, mouseX, mouseY);
        } else if (this.m_6774_(60, 86, 110, 5, mouseX, mouseY)) {
            ArrayList list = Lists.newArrayList();
            list.add(Component.m_237113_((String)(ApothEnchantScreen.quanta() + I18n.m_118938_((String)"gui.apotheosis.enchant.quanta.desc", (Object[])new Object[0]))));
            list.add(Component.m_237115_((String)"gui.apotheosis.enchant.quanta.desc2").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237113_((String)(ApothEnchantScreen.rectification() + I18n.m_118938_((String)"gui.apotheosis.enchant.quanta.desc3", (Object[])new Object[0]))).m_130940_(ChatFormatting.GRAY));
            if (this.menu.stats.quanta() > 0.0f) {
                list.add(Component.m_237113_((String)""));
                list.add(Component.m_237113_((String)I18n.m_118938_((String)"gui.apotheosis.enchant.quanta.desc4", (Object[])new Object[]{ApothEnchantScreen.f(this.menu.stats.quanta())})).m_130940_(ChatFormatting.GRAY));
                list.add(Component.m_237113_((String)I18n.m_118938_((String)"info.apotheosis.gui_rectification", (Object[])new Object[]{ApothEnchantScreen.f(this.menu.stats.rectification())})).m_130940_(ChatFormatting.YELLOW));
            }
            gfx.m_280666_(this.f_96547_, (List)list, mouseX, mouseY);
            float quanta = this.menu.stats.quanta();
            float rectification = this.menu.stats.rectification();
            if (quanta > 0.0f) {
                list.clear();
                list.add(Component.m_237115_((String)"info.apotheosis.quanta_buff").m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.RED}));
                list.add(Component.m_237110_((String)"info.apotheosis.quanta_reduc", (Object[])new Object[]{ApothEnchantScreen.f(-quanta + quanta * rectification / 100.0f)}).m_130940_(ChatFormatting.DARK_RED));
                list.add(Component.m_237110_((String)"info.apotheosis.quanta_growth", (Object[])new Object[]{ApothEnchantScreen.f(quanta)}).m_130940_(ChatFormatting.BLUE));
                this.drawOnLeft(gfx, list, this.getGuiTop() + 29);
            }
        } else if (this.m_6774_(60, 96, 110, 5, mouseX, mouseY)) {
            ArrayList list = Lists.newArrayList();
            PoseStack stack = gfx.m_280168_();
            stack.m_85836_();
            stack.m_252880_(0.0f, 0.0f, 4.0f);
            list.add(Component.m_237113_((String)(ApothEnchantScreen.arcana() + I18n.m_118938_((String)"gui.apotheosis.enchant.arcana.desc", (Object[])new Object[0]))));
            list.add(Component.m_237115_((String)"gui.apotheosis.enchant.arcana.desc2").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"gui.apotheosis.enchant.arcana.desc3").m_130940_(ChatFormatting.GRAY));
            if (this.menu.stats.arcana() > 0.0f) {
                list.add(Component.m_237113_((String)""));
                float ench = (float)this.menu.m_38853_(0).m_7993_().getEnchantmentValue() / 2.0f;
                list.add(Component.m_237113_((String)I18n.m_118938_((String)"gui.apotheosis.enchant.arcana.desc4", (Object[])new Object[]{ApothEnchantScreen.f(this.menu.stats.arcana() - ench)})).m_130940_(ChatFormatting.GRAY));
                list.add(Component.m_237110_((String)"info.apotheosis.ench_bonus", (Object[])new Object[]{ApothEnchantScreen.f(ench)}).m_130940_(ChatFormatting.YELLOW));
                list.add(Component.m_237113_((String)I18n.m_118938_((String)"gui.apotheosis.enchant.arcana.desc5", (Object[])new Object[]{ApothEnchantScreen.f(this.menu.stats.arcana())})).m_130940_(ChatFormatting.GOLD));
            }
            gfx.m_280666_(this.f_96547_, (List)list, mouseX, mouseY);
            stack.m_85849_();
            if (this.menu.stats.arcana() > 0.0f) {
                int minEnchants;
                list.clear();
                ApothEnchantmentMenu.Arcana a = ApothEnchantmentMenu.Arcana.getForThreshold(this.menu.stats.arcana());
                list.add(Component.m_237115_((String)"info.apotheosis.arcana_bonus").m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.DARK_PURPLE}));
                if (a != ApothEnchantmentMenu.Arcana.EMPTY) {
                    list.add(Component.m_237115_((String)"info.apotheosis.weights_changed").m_130940_(ChatFormatting.BLUE));
                }
                int n = this.menu.stats.arcana() > 75.0f ? 3 : (minEnchants = this.menu.stats.arcana() > 25.0f ? 2 : 0);
                if (minEnchants > 0) {
                    list.add(Component.m_237110_((String)"info.apotheosis.min_enchants", (Object[])new Object[]{minEnchants}).m_130940_(ChatFormatting.BLUE));
                }
                this.drawOnLeft(gfx, list, this.getGuiTop() + 29);
                int n2 = list.size();
                Objects.requireNonNull(this.f_96541_.f_91062_);
                int offset = 20 + n2 * 9;
                list.clear();
                list.add(Component.m_237115_((String)"info.apotheosis.rel_weights").m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.YELLOW}));
                list.add(Component.m_237110_((String)"info.apotheosis.weight", (Object[])new Object[]{I18n.m_118938_((String)"rarity.enchantment.common", (Object[])new Object[0]), a.rarities[0]}).m_130940_(ChatFormatting.GRAY));
                list.add(Component.m_237110_((String)"info.apotheosis.weight", (Object[])new Object[]{I18n.m_118938_((String)"rarity.enchantment.uncommon", (Object[])new Object[0]), a.rarities[1]}).m_130940_(ChatFormatting.GREEN));
                list.add(Component.m_237110_((String)"info.apotheosis.weight", (Object[])new Object[]{I18n.m_118938_((String)"rarity.enchantment.rare", (Object[])new Object[0]), a.rarities[2]}).m_130940_(ChatFormatting.BLUE));
                list.add(Component.m_237110_((String)"info.apotheosis.weight", (Object[])new Object[]{I18n.m_118938_((String)"rarity.enchantment.very_rare", (Object[])new Object[0]), a.rarities[3]}).m_130940_(ChatFormatting.GOLD));
                this.drawOnLeft(gfx, list, this.getGuiTop() + 29 + offset);
            }
        } else if (this.menu.m_38853_(0).m_6657_() && this.m_6774_(145, -15, 27, 15, mouseX, mouseY) && Arrays.stream(this.menu.f_39447_).boxed().map(Enchantment::m_44697_).allMatch((Predicate<Enchantment>)Predicates.notNull())) {
            ArrayList list = Lists.newArrayList();
            list.add(Component.m_237115_((String)"info.apotheosis.all_available").m_130940_(ChatFormatting.BLUE));
            gfx.m_280666_(this.f_96547_, (List)list, mouseX, mouseY);
        }
        ItemStack enchanting = this.menu.m_38853_(0).m_7993_();
        if (!enchanting.m_41619_() && this.menu.f_39446_[2] > 0) {
            for (int slot = 0; slot < 3; ++slot) {
                if (!this.m_6774_(60, 14 + 19 * slot, 108, 17, mouseX, mouseY)) continue;
                ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
                int level = this.menu.f_39446_[slot];
                list.add(Component.m_237113_((String)I18n.m_118938_((String)"info.apotheosis.ench_at", (Object[])new Object[]{level})).m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GREEN}));
                list.add(Component.m_237113_((String)""));
                int expCost = ApothMiscUtil.getExpCostForSlot(level, slot);
                list.add(Component.m_237110_((String)"info.apotheosis.xp_cost", (Object[])new Object[]{Component.m_237113_((String)("" + expCost)).m_130940_(ChatFormatting.GREEN), Component.m_237113_((String)("" + EnchantmentUtils.getLevelForExperience((int)expCost))).m_130940_(ChatFormatting.GREEN)}));
                float quanta = this.menu.stats.quanta() / 100.0f;
                float rectification = this.menu.stats.rectification() / 100.0f;
                int minPow = Math.round(Mth.m_14036_((float)((float)level - (float)level * (quanta - quanta * rectification)), (float)1.0f, (float)(EnchantingStatRegistry.getAbsoluteMaxEterna() * 4.0f)));
                int maxPow = Math.round(Mth.m_14036_((float)((float)level + (float)level * quanta), (float)1.0f, (float)(EnchantingStatRegistry.getAbsoluteMaxEterna() * 4.0f)));
                list.add(Component.m_237110_((String)"info.apotheosis.power_range", (Object[])new Object[]{Component.m_237113_((String)("" + minPow)).m_130940_(ChatFormatting.DARK_RED), Component.m_237113_((String)("" + maxPow)).m_130940_(ChatFormatting.BLUE)}));
                list.add(Component.m_237110_((String)"info.apotheosis.item_ench", (Object[])new Object[]{Component.m_237113_((String)("" + enchanting.getEnchantmentValue())).m_130940_(ChatFormatting.GREEN)}));
                list.add(Component.m_237110_((String)"info.apotheosis.num_clues", (Object[])new Object[]{Component.m_237113_((String)("" + this.menu.stats.clues())).m_130940_(ChatFormatting.DARK_AQUA)}));
                this.drawOnLeft(gfx, list, this.getGuiTop() + 29);
                break;
            }
        }
    }

    public ApothEnchantmentMenu getMenu() {
        return this.menu;
    }

    public void acceptClues(int slot, List<EnchantmentInstance> clues, boolean all) {
        this.clues.put(slot, clues);
        this.hasAllClues[slot] = all;
    }

    private static String eterna() {
        return ChatFormatting.GREEN + I18n.m_118938_((String)"gui.apotheosis.enchant.eterna", (Object[])new Object[0]) + ChatFormatting.RESET;
    }

    private static String quanta() {
        return ChatFormatting.RED + I18n.m_118938_((String)"gui.apotheosis.enchant.quanta", (Object[])new Object[0]) + ChatFormatting.RESET;
    }

    private static String arcana() {
        return ChatFormatting.DARK_PURPLE + I18n.m_118938_((String)"gui.apotheosis.enchant.arcana", (Object[])new Object[0]) + ChatFormatting.RESET;
    }

    private static String rectification() {
        return ChatFormatting.YELLOW + I18n.m_118938_((String)"gui.apotheosis.enchant.rectification", (Object[])new Object[0]) + ChatFormatting.RESET;
    }

    private static String f(float f) {
        return String.format("%.2f", Float.valueOf(f));
    }

    public static interface SuperRender {
        public void apoth_superRender(GuiGraphics var1, int var2, int var3, float var4);
    }
}

