/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.loot;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class RarityRegistry
extends WeightedDynamicRegistry<LootRarity> {
    public static final RarityRegistry INSTANCE = new RarityRegistry();
    protected List<DynamicHolder<LootRarity>> ordered = new ArrayList<DynamicHolder<LootRarity>>();
    protected BiMap<Item, DynamicHolder<LootRarity>> materialMap = HashBiMap.create();

    private RarityRegistry() {
        super(AdventureModule.LOGGER, "rarities", true, false);
    }

    public static boolean isMaterial(Item item) {
        return RarityRegistry.getMaterialRarity(item).isBound();
    }

    public static DynamicHolder<LootRarity> getMaterialRarity(Item item) {
        return (DynamicHolder)RarityRegistry.INSTANCE.materialMap.getOrDefault((Object)item, (Object)INSTANCE.emptyHolder());
    }

    public static DynamicHolder<LootRarity> getMinRarity() {
        return RarityRegistry.INSTANCE.ordered.get(0);
    }

    public static DynamicHolder<LootRarity> getMaxRarity() {
        return RarityRegistry.INSTANCE.ordered.get(RarityRegistry.INSTANCE.ordered.size() - 1);
    }

    public static DynamicHolder<LootRarity> byOrdinal(int i) {
        return RarityRegistry.INSTANCE.ordered.get(i);
    }

    public static ResourceLocation convertId(String s) {
        return s.contains(":") ? new ResourceLocation(s) : Apotheosis.loc(s);
    }

    public static DynamicHolder<LootRarity> byLegacyId(String s) {
        return INSTANCE.holder(RarityRegistry.convertId(s));
    }

    public static DynamicHolder<LootRarity> prev(DynamicHolder<LootRarity> rarity) {
        if (rarity == RarityRegistry.getMinRarity()) {
            return rarity;
        }
        return RarityRegistry.byOrdinal(((LootRarity)rarity.get()).ordinal() - 1);
    }

    public static DynamicHolder<LootRarity> next(DynamicHolder<LootRarity> rarity) {
        if (rarity == RarityRegistry.getMaxRarity()) {
            return rarity;
        }
        return RarityRegistry.byOrdinal(((LootRarity)rarity.get()).ordinal() + 1);
    }

    public List<DynamicHolder<LootRarity>> getOrderedRarities() {
        return this.ordered;
    }

    protected void beginReload() {
        super.beginReload();
        this.ordered = new ArrayList<DynamicHolder<LootRarity>>();
        this.materialMap = HashBiMap.create();
    }

    protected void onReload() {
        super.onReload();
        this.ordered = this.registry.values().stream().sorted(Comparator.comparing(LootRarity::ordinal)).map(arg_0 -> ((RarityRegistry)this).holder(arg_0)).toList();
        int lastOrdinal = -1;
        for (DynamicHolder<LootRarity> r : this.ordered) {
            if (((LootRarity)r.get()).ordinal() != lastOrdinal + 1) {
                StringBuilder sb = new StringBuilder();
                sb.append("Rarity ordinal order is inconsistent. The ordinals must start at zero and be continuous up to the max value.\n");
                for (DynamicHolder<LootRarity> rarity : this.ordered) {
                    sb.append(rarity.getId() + " | " + ((LootRarity)rarity.get()).ordinal() + "\n");
                }
                throw new RuntimeException(sb.toString());
            }
            lastOrdinal = ((LootRarity)r.get()).ordinal();
        }
        for (DynamicHolder<LootRarity> r : this.ordered) {
            DynamicHolder old = (DynamicHolder)this.materialMap.put((Object)((LootRarity)r.get()).getMaterial(), r);
            if (old == null) continue;
            throw new RuntimeException("Two rarities may not share the same rarity material: " + r.getId() + " conflicts with " + old.getId());
        }
        this.ordered = ImmutableList.copyOf(this.ordered);
    }

    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(Apotheosis.loc("rarity"), LootRarity.LOAD_CODEC);
    }

    protected void validateItem(ResourceLocation key, LootRarity item) {
        super.validateItem(key, (CodecProvider)item);
        Preconditions.checkNotNull((Object)item.getColor());
        Preconditions.checkArgument((item.getMaterial() != null && item.getMaterial() != Items.f_41852_ ? 1 : 0) != 0);
        Preconditions.checkArgument((item.getWeight() >= 0 ? 1 : 0) != 0, (Object)"A rarity may not have negative weight!");
        Preconditions.checkArgument((item.getQuality() >= 0.0f ? 1 : 0) != 0, (Object)"A rarity may not have negative quality!");
        Preconditions.checkArgument((!item.getRules().isEmpty() ? 1 : 0) != 0, (Object)"A rarity may not have no rules!");
    }

    public void validateLootRules() {
        for (LootRarity rarity : this.registry.values()) {
            HashMap<AffixType, List> sorted = new HashMap<AffixType, List>();
            rarity.getRules().stream().filter(r -> r.type().needsValidation()).forEach(rule -> {
                sorted.computeIfAbsent(rule.type(), r -> new ArrayList());
                ((List)sorted.get((Object)rule.type())).add(rule);
            });
            sorted.forEach((type, rules) -> {
                for (LootCategory cat : LootCategory.VALUES) {
                    List<Affix> affixes;
                    if (cat.isNone() || (affixes = AffixRegistry.INSTANCE.getValues().stream().filter(a -> a.canApplyTo(ItemStack.f_41583_, cat, rarity) && a.getType() == type).toList()).size() >= rules.size()) continue;
                    StringBuilder errMsg = new StringBuilder();
                    errMsg.append("Insufficient number of affixes to satisfy the loot rules (ignoring backup rules) of rarity " + this.getKey(rarity) + " for category " + cat.getName());
                    errMsg.append("Required: " + rules.size());
                    errMsg.append("; Provided: " + affixes.size());
                    AdventureModule.LOGGER.error(errMsg.toString());
                }
            });
        }
    }
}

