/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.api;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_1291;
import net.minecraft.class_1320;
import net.minecraft.class_2960;
import net.minecraft.class_4081;
import net.minecraft.class_5321;
import net.minecraft.class_8110;
import net.minecraft.class_8111;
import net.spell_power.SpellPowerMod;
import net.spell_power.api.SpellPowerMechanics;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.enchantment.Enchantments_SpellPowerMechanics;
import net.spell_power.api.enchantment.SpellPowerEnchanting;
import net.spell_power.config.AttributesConfig;
import net.spell_power.internals.AmplifierEnchantment;
import net.spell_power.internals.CustomEntityAttribute;
import net.spell_power.internals.SpellStatusEffect;
import org.jetbrains.annotations.Nullable;

public class SpellSchools {
    public static final String DEFAULT_NAMESPACE = "spell_power";
    private static final LinkedHashMap<class_2960, SpellSchool> REGISTRY = new LinkedHashMap();
    public static final SpellSchool ARCANE = SpellSchools.register(SpellSchools.createMagic("arcane", 0xFF66FF));
    public static final SpellSchool FIRE = SpellSchools.register(SpellSchools.createMagic("fire", 0xFF3300));
    public static final SpellSchool FROST = SpellSchools.register(SpellSchools.createMagic("frost", 0xCCFFFF));
    public static final SpellSchool HEALING = SpellSchools.register(SpellSchools.createMagic("healing", 0x66FF66));
    public static final SpellSchool LIGHTNING = SpellSchools.register(SpellSchools.createMagic("lightning", 0xFFFF99));
    public static final SpellSchool SOUL = SpellSchools.register(SpellSchools.createMagic("soul", 3003610));

    public static SpellSchool register(SpellSchool school) {
        REGISTRY.put(school.id, school);
        return school;
    }

    public static Set<SpellSchool> all() {
        return new LinkedHashSet<SpellSchool>(REGISTRY.values());
    }

    public static SpellSchool createMagic(String name, int color) {
        return SpellSchools.createMagic(new class_2960(DEFAULT_NAMESPACE, name.toLowerCase()), color);
    }

    public static SpellSchool createMagic(class_2960 id, int color) {
        SpellStatusEffect powerEffect = new SpellStatusEffect(class_4081.field_18271, color);
        String translationPrefix = "attribute.name." + id.method_12836() + ".";
        class_1320 attribute = new CustomEntityAttribute(translationPrefix + id.method_12832(), 0.0, 0.0, 2048.0, id).method_26829(true);
        return SpellSchools.createMagic(id, color, attribute, powerEffect);
    }

    public static SpellSchool createMagic(class_2960 id, int color, class_1320 powerAttribute, class_1291 powerEffect) {
        SpellSchool school = new SpellSchool(SpellSchool.Archetype.MAGIC, id, color, (class_5321<class_8110>)class_8111.field_42349, powerAttribute, powerEffect);
        return SpellSchools.configureAsMagic(school, powerAttribute);
    }

    public static SpellSchool configureAsMagic(SpellSchool school, class_1320 powerAttribute) {
        school.addSource(SpellSchool.Trait.POWER, new SpellSchool.Source(SpellSchool.Apply.ADD, query -> query.entity().method_26825(powerAttribute)));
        SpellSchools.configureSpellHaste(school);
        SpellSchools.configureSpellCritChance(school);
        SpellSchools.configureSpellCritDamage(school);
        return school;
    }

    public static SpellSchool configureSpellHaste(SpellSchool school) {
        school.addSource(SpellSchool.Trait.HASTE, new SpellSchool.Source(SpellSchool.Apply.ADD, query -> {
            double value = query.entity().method_26825((class_1320)SpellPowerMechanics.HASTE.attribute);
            double rate = value / 100.0;
            return rate - 1.0;
        }));
        school.addSource(SpellSchool.Trait.HASTE, new SpellSchool.Source(SpellSchool.Apply.ADD, query -> {
            AmplifierEnchantment enchantment = Enchantments_SpellPowerMechanics.HASTE;
            int level = SpellPowerEnchanting.getEnchantmentLevelEquipmentSum(enchantment, query.entity());
            return enchantment.amplified(0.0, level);
        }));
        return school;
    }

    public static SpellSchool configureSpellCritChance(SpellSchool school) {
        school.addSource(SpellSchool.Trait.CRIT_CHANCE, new SpellSchool.Source(SpellSchool.Apply.ADD, query -> {
            double value = ((AttributesConfig)SpellPowerMod.attributesConfig.value).base_spell_critical_chance_percentage + query.entity().method_26825((class_1320)SpellPowerMechanics.CRITICAL_CHANCE.attribute);
            return value / 100.0 - 1.0;
        }));
        school.addSource(SpellSchool.Trait.CRIT_CHANCE, new SpellSchool.Source(SpellSchool.Apply.ADD, query -> {
            AmplifierEnchantment enchantment = Enchantments_SpellPowerMechanics.CRITICAL_CHANCE;
            int level = SpellPowerEnchanting.getEnchantmentLevelEquipmentSum(enchantment, query.entity());
            return enchantment.amplified(0.0, level);
        }));
        return school;
    }

    public static SpellSchool configureSpellCritDamage(SpellSchool school) {
        school.addSource(SpellSchool.Trait.CRIT_DAMAGE, new SpellSchool.Source(SpellSchool.Apply.ADD, query -> {
            double value = ((AttributesConfig)SpellPowerMod.attributesConfig.value).base_spell_critical_damage_percentage + query.entity().method_26825((class_1320)SpellPowerMechanics.CRITICAL_DAMAGE.attribute);
            double rate = value / 100.0;
            return rate - 1.0;
        }));
        school.addSource(SpellSchool.Trait.CRIT_DAMAGE, new SpellSchool.Source(SpellSchool.Apply.ADD, query -> {
            AmplifierEnchantment enchantment = Enchantments_SpellPowerMechanics.CRITICAL_DAMAGE;
            int level = SpellPowerEnchanting.getEnchantmentLevelEquipmentSum(enchantment, query.entity());
            return enchantment.amplified(0.0, level);
        }));
        return school;
    }

    @Nullable
    public static SpellSchool getSchool(String idString) {
        String string = idString.toLowerCase(Locale.US);
        class_2960 id = new class_2960(string);
        if (id.method_12836().equals("minecraft")) {
            id = new class_2960(DEFAULT_NAMESPACE, id.method_12832());
        }
        return REGISTRY.get(id);
    }

    @Deprecated
    public static class IdTypeAdapter
    extends TypeAdapter<SpellSchool> {
        public void write(JsonWriter jsonWriter, SpellSchool school) throws IOException {
            jsonWriter.value(school.id.toString());
        }

        public SpellSchool read(JsonReader jsonReader) throws IOException {
            return SpellSchools.getSchool(jsonReader.nextString());
        }
    }
}

