/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.structure_pool.api;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import net.fabric_extras.structure_pool.api.StructurePoolConfig;
import net.fabric_extras.structure_pool.internal.StructurePoolExtension;
import net.fabric_extras.structure_pool.mixin.StructurePoolAccessor;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class StructurePoolAPI {
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("minecraft", "empty"));
    public static HashMap<ResourceLocation, HashMap<ResourceLocation, SpawnPerk>> spawnLimitations = new HashMap();

    public static void injectAll(StructurePoolConfig config) {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            for (StructurePoolConfig.Entry entry : config.entries) {
                ResourceLocation pooldId = new ResourceLocation(entry.pool);
                for (StructurePoolConfig.Entry.Structure structure : entry.structures) {
                    ResourceLocation structureId = new ResourceLocation(structure.id);
                    StructurePoolAPI.injectIntoStructurePool(server, pooldId, structureId, structure.weight);
                    if (structure.limit <= 0) continue;
                    StructurePoolAPI.limitSpawn(pooldId, structureId, structure.limit);
                }
            }
        });
    }

    public static void injectIntoStructurePool(MinecraftServer server, ResourceLocation poolId, ResourceLocation structureId, int weight) {
        Holder.Reference emptyProcessorList = server.m_206579_().m_175515_(Registries.f_257011_).m_246971_(EMPTY_PROCESSOR_LIST_KEY);
        Optional poolGetter = server.m_206579_().m_175515_(Registries.f_256948_).m_6612_(poolId);
        if (poolGetter.isEmpty()) {
            System.err.println("StructurePool API: cannot add to " + poolId + " as it cannot be found!");
            return;
        }
        StructureTemplatePool pool = (StructureTemplatePool)poolGetter.get();
        ObjectArrayList<StructurePoolElement> pieceList = ((StructurePoolAccessor)pool).getElements();
        SinglePoolElement piece = (SinglePoolElement)StructurePoolElement.m_210531_((String)structureId.toString(), (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        ((StructurePoolExtension)pool).remember((StructurePoolElement)piece, structureId);
        ArrayList<Pair<StructurePoolElement, Integer>> list = new ArrayList<Pair<StructurePoolElement, Integer>>(((StructurePoolAccessor)pool).getElementCounts());
        list.add((Pair<StructurePoolElement, Integer>)Pair.of((Object)piece, (Object)weight));
        ((StructurePoolAccessor)pool).setElementCounts(list);
        for (int i = 0; i < weight; ++i) {
            pieceList.add((Object)piece);
        }
    }

    public static void limitSpawn(ResourceLocation poolId, ResourceLocation structureId, int limit) {
        if (!spawnLimitations.containsKey(poolId)) {
            spawnLimitations.put(poolId, new HashMap());
        }
        spawnLimitations.get(poolId).put(structureId, new SpawnPerk(limit));
    }

    public record SpawnPerk(int limit) {
    }
}

