/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.service;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.LaunchPluginHandler;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraftforge.fml.loading.ImmediateWindowHandler;
import net.minecraftforge.fml.loading.ImmediateWindowProvider;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.unsafe.UnsafeHacks;
import org.sinytra.connector.loader.ConnectorEarlyLoader;
import org.sinytra.connector.service.ConnectorPreLaunchPlugin;
import org.sinytra.connector.service.FabricASMFixer;
import org.sinytra.connector.service.hacks.ConnectorForkJoinThreadFactory;
import org.sinytra.connector.service.hacks.LenientRuntimeEnumExtender;
import org.sinytra.connector.service.hacks.ModuleLayerMigrator;
import org.slf4j.Logger;

public class ConnectorLoaderService
implements ITransformationService {
    private static final String NAME = "connector_loader";
    private static final String AUTHLIB_MODULE = "authlib";
    private static final Logger LOGGER = LogUtils.getLogger();

    public String name() {
        return NAME;
    }

    public void initialize(IEnvironment environment) {
        VarHandle provider = (VarHandle)LamdbaExceptionUtils.uncheck(() -> ModuleLayerMigrator.TRUSTED_LOOKUP.findStaticVarHandle(ImmediateWindowHandler.class, "provider", ImmediateWindowProvider.class));
        final ImmediateWindowProvider original = provider.get();
        ImmediateWindowProvider newProvider = new ImmediateWindowProvider(){

            public void updateModuleReads(ModuleLayer layer) {
                ConnectorEarlyLoader.setup();
                LamdbaExceptionUtils.uncheck(() -> Class.forName("org.sinytra.connector.mod.DummyTarget", false, Thread.currentThread().getContextClassLoader()));
                ConnectorEarlyLoader.preLaunch();
                original.updateModuleReads(layer);
            }

            public String name() {
                return original.name();
            }

            public Runnable initialize(String[] arguments) {
                return original.initialize(arguments);
            }

            public void updateFramebufferSize(IntConsumer width, IntConsumer height) {
                original.updateFramebufferSize(width, height);
            }

            public long setupMinecraftWindow(IntSupplier width, IntSupplier height, Supplier<String> title, LongSupplier monitor) {
                return original.setupMinecraftWindow(width, height, title, monitor);
            }

            public boolean positionWindow(Optional<Object> monitor, IntConsumer widthSetter, IntConsumer heightSetter, IntConsumer xSetter, IntConsumer ySetter) {
                return original.positionWindow(monitor, widthSetter, heightSetter, xSetter, ySetter);
            }

            public <T> Supplier<T> loadingOverlay(Supplier<?> mc, Supplier<?> ri, Consumer<Optional<Throwable>> ex, boolean fade) {
                return original.loadingOverlay(mc, ri, ex, fade);
            }

            public void periodicTick() {
                original.periodicTick();
            }

            public String getGLVersion() {
                return original.getGLVersion();
            }
        };
        provider.set(newProvider);
        ConnectorForkJoinThreadFactory.install();
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) {
        List<ConnectorPreLaunchPlugin> injectPlugins = List.of(new ConnectorPreLaunchPlugin());
        try {
            Field launchPluginsField = Launcher.class.getDeclaredField("launchPlugins");
            launchPluginsField.setAccessible(true);
            LaunchPluginHandler launchPluginHandler = (LaunchPluginHandler)launchPluginsField.get(Launcher.INSTANCE);
            Field pluginsField = LaunchPluginHandler.class.getDeclaredField("plugins");
            pluginsField.setAccessible(true);
            Map plugins = (Map)pluginsField.get(launchPluginHandler);
            LinkedHashMap<String, Object> sortedPlugins = new LinkedHashMap<String, Object>();
            sortedPlugins.put("mixin", (ILaunchPluginService)plugins.remove("mixin"));
            plugins.remove("runtime_enum_extender");
            sortedPlugins.put("runtime_enum_extender", (Object)new LenientRuntimeEnumExtender());
            injectPlugins.forEach(plugin -> sortedPlugins.put(plugin.name(), plugin));
            sortedPlugins.putAll(plugins);
            UnsafeHacks.setField((Field)pluginsField, (Object)launchPluginHandler, sortedPlugins);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<ITransformationService.Resource> completeScan(IModuleLayerManager layerManager) {
        if (LoadingModList.get().getBrokenFiles().isEmpty()) {
            LoadingModList.get().getErrors().addAll(ConnectorEarlyLoader.getLoadingExceptions());
        } else {
            LOGGER.warn("Broken FML mod files found, not adding Connector locator errors");
        }
        return List.of(new ITransformationService.Resource(IModuleLayerManager.Layer.GAME, List.of(new FabricASMFixer.FabricASMGeneratedClassesSecureJar(), ModuleLayerMigrator.moveModule(AUTHLIB_MODULE))));
    }

    public List<ITransformer> transformers() {
        return List.of();
    }

    static {
        System.setProperty("mixin.env.fixFrameExpansion", "true");
    }
}

