/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.api.PatchEnvironment;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.code.ISliceContext;
import org.spongepowered.asm.mixin.injection.code.MethodSlice;
import org.spongepowered.asm.mixin.injection.selectors.ISelectorContext;
import org.spongepowered.asm.mixin.injection.struct.CallbackInjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.mixin.refmap.IReferenceMapper;
import org.spongepowered.asm.mixin.transformer.ext.Extensions;
import org.spongepowered.asm.util.asm.IAnnotationHandle;
import sun.misc.Unsafe;

public class MockMixinRuntime {
    private static final MethodHandles.Lookup TRUSTED_LOOKUP;
    private static final Unsafe UNSAFE;

    public static IMixinContext forClass(String className, String targetClass, PatchEnvironment environment) {
        return new ClassMixinContext(className, targetClass, environment);
    }

    public static ISliceContext forSlice(IMixinContext context, MethodNode methodNode) {
        return new MethodSliceContext(context, methodNode);
    }

    public static InjectionInfo forInjectionInfo(String className, String targetClass, PatchEnvironment environment) {
        try {
            InjectionInfo injectionInfo = (InjectionInfo)UNSAFE.allocateInstance(CallbackInjectionInfo.class);
            VarHandle handle = TRUSTED_LOOKUP.findVarHandle(InjectionInfo.class, "context", IMixinContext.class);
            IMixinContext context = MockMixinRuntime.forClass(className, targetClass, environment);
            handle.set(injectionInfo, context);
            return injectionInfo;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
            Field hackfield = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            TRUSTED_LOOKUP = (MethodHandles.Lookup)UNSAFE.getObject(UNSAFE.staticFieldBase(hackfield), UNSAFE.staticFieldOffset(hackfield));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static final class ClassMixinContext
    implements IMixinContext {
        private final String className;
        private final String targetClass;
        private final ReferenceRemapper referenceRemapper;
        private final IMixinInfo mixinInfo;

        public ClassMixinContext(String className, String targetClass, PatchEnvironment env) {
            this.className = className;
            this.targetClass = targetClass;
            this.referenceRemapper = new ReferenceRemapper(env);
            this.mixinInfo = new DummyMixinInfo(new DummyMixinConfig());
        }

        public IMixinInfo getMixin() {
            return this.mixinInfo;
        }

        public Extensions getExtensions() {
            throw new UnsupportedOperationException();
        }

        public String getClassName() {
            return this.className.replace('/', '.');
        }

        public String getClassRef() {
            return this.className;
        }

        public String getTargetClassRef() {
            return this.targetClass;
        }

        public IReferenceMapper getReferenceMapper() {
            return this.referenceRemapper;
        }

        public boolean getOption(MixinEnvironment.Option option) {
            return false;
        }

        public int getPriority() {
            return 0;
        }
    }

    private record MethodSliceContext(IMixinContext context, MethodNode methodNode) implements ISliceContext
    {
        public IMixinContext getMixin() {
            return this.context;
        }

        public String remap(String reference) {
            return this.context.getReferenceMapper().remap(this.context.getClassName(), reference);
        }

        public MethodSlice getSlice(String id) {
            throw new UnsupportedOperationException();
        }

        public MethodNode getMethod() {
            return this.methodNode;
        }

        public AnnotationNode getAnnotationNode() {
            throw new UnsupportedOperationException();
        }

        public ISelectorContext getParent() {
            throw new UnsupportedOperationException();
        }

        public IAnnotationHandle getAnnotation() {
            throw new UnsupportedOperationException();
        }

        public IAnnotationHandle getSelectorAnnotation() {
            throw new UnsupportedOperationException();
        }

        public String getSelectorCoordinate(boolean leaf) {
            throw new UnsupportedOperationException();
        }

        public void addMessage(String format, Object ... args) {
        }
    }

    private record DummyMixinInfo(IMixinConfig config) implements IMixinInfo
    {
        public IMixinConfig getConfig() {
            return this.config;
        }

        public String getName() {
            throw new UnsupportedOperationException();
        }

        public String getClassName() {
            throw new UnsupportedOperationException();
        }

        public String getClassRef() {
            throw new UnsupportedOperationException();
        }

        public byte[] getClassBytes() {
            throw new UnsupportedOperationException();
        }

        public boolean isDetachedSuper() {
            throw new UnsupportedOperationException();
        }

        public ClassNode getClassNode(int flags) {
            throw new UnsupportedOperationException();
        }

        public List<String> getTargetClasses() {
            throw new UnsupportedOperationException();
        }

        public int getPriority() {
            throw new UnsupportedOperationException();
        }

        public MixinEnvironment.Phase getPhase() {
            throw new UnsupportedOperationException();
        }
    }

    private static class DummyMixinConfig
    implements IMixinConfig {
        private DummyMixinConfig() {
        }

        public MixinEnvironment getEnvironment() {
            return MixinEnvironment.getCurrentEnvironment();
        }

        public String getName() {
            throw new UnsupportedOperationException();
        }

        public String getMixinPackage() {
            throw new UnsupportedOperationException();
        }

        public int getPriority() {
            return 0;
        }

        public IMixinConfigPlugin getPlugin() {
            return null;
        }

        public boolean isRequired() {
            throw new UnsupportedOperationException();
        }

        public Set<String> getTargets() {
            throw new UnsupportedOperationException();
        }

        public <V> void decorate(String key, V value) {
        }

        public boolean hasDecoration(String key) {
            return false;
        }

        public <V> V getDecoration(String key) {
            return null;
        }
    }

    private record ReferenceRemapper(PatchEnvironment env) implements IReferenceMapper
    {
        public String remapWithContext(String context, String className, String reference) {
            return this.env.refmapHolder().remap(className, reference);
        }

        public boolean isDefault() {
            return false;
        }

        public String getResourceName() {
            return null;
        }

        public String getStatus() {
            return null;
        }

        public String getContext() {
            return null;
        }

        public void setContext(String context) {
        }

        public String remap(String className, String reference) {
            return this.remapWithContext(null, className, reference);
        }
    }
}

