/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.param;

import com.mojang.logging.LogUtils;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.sinytra.adapter.patch.PatchInstance;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.transformer.LVTSnapshot;
import org.sinytra.adapter.patch.transformer.param.ParameterTransformer;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.slf4j.Logger;

public record InlineParameterTransformer(int target, Consumer<InstructionAdapter> adapter) implements ParameterTransformer
{
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context, List<Type> parameters, int offset) {
        int index = this.target + offset;
        LOGGER.info(PatchInstance.MIXINPATCH, "Inlining parameter {} of method {}.{}", new Object[]{index, classNode.name, methodNode.name});
        int replaceIndex = -999 + index;
        LVTSnapshot.with(methodNode, () -> {
            if (index < methodNode.parameters.size()) {
                methodNode.parameters.remove(index);
            }
            methodNode.localVariables.sort(Comparator.comparingInt(lvn -> lvn.index));
            LocalVariableNode lvn2 = (LocalVariableNode)methodNode.localVariables.remove(index + (methodContext.isStatic() ? 0 : 1));
            AdapterUtil.replaceLVT(methodNode, idx -> idx == lvn.index ? replaceIndex : idx);
        });
        parameters.remove(index);
        for (AbstractInsnNode insn : methodNode.instructions) {
            if (!(insn instanceof VarInsnNode)) continue;
            VarInsnNode varInsn = (VarInsnNode)insn;
            if (varInsn.var != replaceIndex) continue;
            InsnList replacementInsns = AdapterUtil.insnsWithAdapter(this.adapter);
            methodNode.instructions.insert((AbstractInsnNode)varInsn, replacementInsns);
            methodNode.instructions.remove((AbstractInsnNode)varInsn);
        }
        return Patch.Result.COMPUTE_FRAMES;
    }
}

