/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch;

import com.google.common.base.Suppliers;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.PatchInstance;
import org.sinytra.adapter.patch.analysis.LocalVariableLookup;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MixinConstants;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.selector.AnnotationHandle;
import org.sinytra.adapter.patch.selector.AnnotationValueHandle;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.sinytra.adapter.patch.util.MethodQualifier;
import org.sinytra.adapter.patch.util.MockMixinRuntime;
import org.sinytra.adapter.patch.util.provider.ClassLookup;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.code.ISliceContext;
import org.spongepowered.asm.mixin.injection.code.MethodSlice;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.util.Locals;

public final class MethodContextImpl
implements MethodContext {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ClassNode classNode;
    private final AnnotationValueHandle<?> classAnnotation;
    private final MethodNode methodNode;
    private final AnnotationHandle methodAnnotation;
    @Nullable
    private final AnnotationHandle injectionPointAnnotation;
    private final List<Type> targetTypes;
    private final List<String> matchingTargets;
    private final PatchContext patchContext;
    private final Supplier<MethodContext.TargetPair> cleanInjectionPairCache;
    private final Supplier<MethodContext.TargetPair> dirtyInjectionPairCache;
    private final Supplier<LocalVariableLookup> cleanLocalsTableCache;
    private final Map<MethodContext.TargetPair, List<AbstractInsnNode>> targetInstructionsCache;

    public MethodContextImpl(ClassNode classNode, AnnotationValueHandle<?> classAnnotation, MethodNode methodNode, AnnotationHandle methodAnnotation, AnnotationHandle injectionPointAnnotation, List<Type> targetTypes, List<String> matchingTargets, PatchContext patchContext) {
        this.classNode = Objects.requireNonNull(classNode, "Missing class node");
        this.classAnnotation = Objects.requireNonNull(classAnnotation, "Missing class annotation");
        this.methodNode = Objects.requireNonNull(methodNode, "Missing method node");
        this.methodAnnotation = Objects.requireNonNull(methodAnnotation, "Missing method annotation");
        this.injectionPointAnnotation = injectionPointAnnotation;
        this.targetTypes = Objects.requireNonNull(targetTypes, "Missing target types");
        this.matchingTargets = Objects.requireNonNull(matchingTargets, "Missing matching targets");
        this.patchContext = patchContext;
        this.cleanInjectionPairCache = Suppliers.memoize(() -> {
            ClassLookup cleanClassLookup = this.patchContext.environment().cleanClassLookup();
            return this.findInjectionTarget(s -> cleanClassLookup.getClass((String)s).orElse(null));
        });
        this.dirtyInjectionPairCache = Suppliers.memoize(() -> this.findInjectionTarget(name -> this.patchContext.environment().dirtyClassLookup().getClass((String)name).orElse(null)));
        this.targetInstructionsCache = new HashMap<MethodContext.TargetPair, List<AbstractInsnNode>>();
        this.cleanLocalsTableCache = Suppliers.memoize(() -> Optional.ofNullable(this.findCleanInjectionTarget()).map(pair -> new LocalVariableLookup(pair.methodNode())).orElse(null));
    }

    @Override
    public AnnotationHandle injectionPointAnnotationOrThrow() {
        return Objects.requireNonNull(this.injectionPointAnnotation, "Missing injection point annotation");
    }

    @Override
    public MethodContext.TargetPair findCleanInjectionTarget() {
        return this.cleanInjectionPairCache.get();
    }

    @Override
    public MethodContext.TargetPair findDirtyInjectionTarget() {
        return this.dirtyInjectionPairCache.get();
    }

    @Override
    public LocalVariableLookup cleanLocalsTable() {
        return this.cleanLocalsTableCache.get();
    }

    @Override
    @Nullable
    public MethodQualifier getTargetMethodQualifier() {
        List methodRefs = (List)this.methodAnnotation().getValue("method").orElseThrow().get();
        if (methodRefs.size() > 1) {
            return null;
        }
        String reference = this.patchContext().remap((String)methodRefs.get(0));
        return MethodQualifier.create(reference, false).orElse(null);
    }

    @Override
    @Nullable
    public MethodQualifier getInjectionPointMethodQualifier() {
        String target = this.injectionPointAnnotation().getValue("target").map(AnnotationValueHandle::get).orElse(null);
        if (target == null) {
            return null;
        }
        String reference = this.patchContext().remap(target);
        return MethodQualifier.create(reference, false).orElse(null);
    }

    @Override
    public List<AbstractInsnNode> findInjectionTargetInsns(@Nullable MethodContext.TargetPair target) {
        return this.targetInstructionsCache.computeIfAbsent(target, this::computeInjectionTargetInsns);
    }

    @Override
    public void updateDescription(List<Type> parameters) {
        Type returnType = Type.getReturnType((String)this.methodNode.desc);
        String newDesc = Type.getMethodDescriptor((Type)returnType, (Type[])((Type[])parameters.toArray(Type[]::new)));
        LOGGER.info(PatchInstance.MIXINPATCH, "Changing descriptor of method {}.{}{} to {}", new Object[]{this.classNode.name, this.methodNode.name, this.methodNode.desc, newDesc});
        this.methodNode.desc = newDesc;
        this.methodNode.signature = null;
    }

    @Override
    public boolean isStatic() {
        return (this.methodNode.access & 8) != 0;
    }

    @Override
    @Nullable
    public List<MethodContext.LocalVariable> getTargetMethodLocals(MethodContext.TargetPair target) {
        Type[] targetParams = Type.getArgumentTypes((String)target.methodNode().desc);
        boolean isStatic = (this.methodNode.access & 8) != 0;
        int lvtOffset = isStatic ? 0 : 1;
        int targetLocalPos = targetParams.length + lvtOffset;
        return this.getTargetMethodLocals(target, targetLocalPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public List<MethodContext.LocalVariable> getTargetMethodLocals(MethodContext.TargetPair target, int startPos, int lvtCompatLevel) {
        LocalVariableNode[] localVariables;
        List<AbstractInsnNode> targetInsns = this.findInjectionTargetInsns(target);
        if (targetInsns.isEmpty()) {
            LOGGER.debug("Skipping LVT patch, no target instructions found");
            return null;
        }
        MethodContextImpl methodContextImpl = this;
        synchronized (methodContextImpl) {
            localVariables = Locals.getLocalsAt((ClassNode)target.classNode(), (MethodNode)target.methodNode(), (AbstractInsnNode)targetInsns.get(0), (int)lvtCompatLevel);
        }
        MethodContext.LocalVariable[] locals = (MethodContext.LocalVariable[])Stream.of(localVariables).filter(Objects::nonNull).map(lv -> new MethodContext.LocalVariable(lv.index, Type.getType((String)lv.desc))).toArray(MethodContext.LocalVariable[]::new);
        return AdapterUtil.summariseLocals(locals, startPos);
    }

    private List<AbstractInsnNode> computeInjectionTargetInsns(@Nullable MethodContext.TargetPair target) {
        if (target == null) {
            return List.of();
        }
        AnnotationHandle atNode = this.injectionPointAnnotation();
        if (atNode == null) {
            LOGGER.debug("Target @At annotation not found in method {}.{}{}", new Object[]{this.classNode.name, this.methodNode.name, this.methodNode.desc});
            return List.of();
        }
        AnnotationHandle annotation = this.methodAnnotation();
        IMixinContext mixinContext = MockMixinRuntime.forClass(this.classNode.name, target.classNode().name, this.patchContext().environment());
        InjectionPoint injectionPoint = InjectionPoint.parse((IMixinContext)mixinContext, (MethodNode)this.methodNode, (AnnotationNode)annotation.unwrap(), (AnnotationNode)atNode.unwrap());
        InsnList instructions = this.getSlicedInsns(annotation, this.classNode, this.methodNode, target.classNode(), target.methodNode(), this.patchContext());
        ArrayList<AbstractInsnNode> targetInsns = new ArrayList<AbstractInsnNode>();
        try {
            injectionPoint.find(target.methodNode().desc, instructions, targetInsns);
        }
        catch (UnsupportedOperationException | InvalidInjectionException e) {
            LOGGER.error("Error finding injection insns: {}", (Object)e.getMessage());
            return List.of();
        }
        return targetInsns;
    }

    @Override
    public List<Integer> getLvtCompatLevelsOrdered() {
        int currentLevel = this.patchContext().environment().fabricLVTCompatibility();
        return MixinConstants.LVT_COMPATIBILITY_LEVELS.stream().sorted(Comparator.comparingInt(i -> i == currentLevel ? 1 : 0)).toList();
    }

    @Override
    public boolean capturesLocals() {
        return this.methodAnnotation().getValue("locals").isPresent();
    }

    @Override
    public boolean failsDirtyInjectionCheck() {
        MethodContext.TargetPair dirtyPair = this.findDirtyInjectionTarget();
        return dirtyPair != null && this.findInjectionTargetInsns(dirtyPair).isEmpty();
    }

    private InsnList getSlicedInsns(AnnotationHandle parentAnnotation, ClassNode classNode, MethodNode injectorMethod, ClassNode targetClass, MethodNode targetMethod, PatchContext context) {
        return parentAnnotation.getValue("slice").map(handle -> {
            AnnotationNode annotationNode;
            Object value = handle.get();
            if (value instanceof List) {
                List list = (List)value;
                annotationNode = (AnnotationNode)list.get(0);
            } else {
                annotationNode = (AnnotationNode)value;
            }
            return annotationNode;
        }).map(sliceAnn -> {
            IMixinContext mixinContext = MockMixinRuntime.forClass(classNode.name, targetClass.name, context.environment());
            ISliceContext sliceContext = MockMixinRuntime.forSlice(mixinContext, injectorMethod);
            return this.computeSlicedInsns(sliceContext, (AnnotationNode)sliceAnn, targetMethod);
        }).orElse(targetMethod.instructions);
    }

    private InsnList computeSlicedInsns(ISliceContext context, AnnotationNode annotation, MethodNode method) {
        MethodSlice slice = MethodSlice.parse((ISliceContext)context, (AnnotationNode)annotation);
        return slice.getSlice(method);
    }

    @Nullable
    private MethodContext.TargetPair findInjectionTarget(Function<String, ClassNode> classLookup) {
        MethodQualifier qualifier = this.getTargetMethodQualifier();
        if (qualifier == null || qualifier.name() == null || qualifier.desc() == null) {
            return null;
        }
        String owner = Optional.ofNullable(qualifier.internalOwnerName()).orElseGet(() -> {
            List<Type> targetTypes = this.targetTypes();
            if (targetTypes.size() == 1) {
                return targetTypes.get(0).getInternalName();
            }
            return null;
        });
        if (owner == null) {
            return null;
        }
        ClassNode targetClass = classLookup.apply(owner);
        if (targetClass == null) {
            return null;
        }
        MethodNode targetMethod = targetClass.methods.stream().filter(mtd -> mtd.name.equals(qualifier.name()) && mtd.desc.equals(qualifier.desc())).findFirst().orElse(null);
        if (targetMethod == null) {
            LOGGER.debug("Target method not found: {}{}{}", new Object[]{qualifier.owner(), qualifier.name(), qualifier.desc()});
            return null;
        }
        return new MethodContext.TargetPair(targetClass, targetMethod);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public AnnotationValueHandle<?> classAnnotation() {
        return this.classAnnotation;
    }

    @Override
    public AnnotationHandle methodAnnotation() {
        return this.methodAnnotation;
    }

    @Override
    @Nullable
    public AnnotationHandle injectionPointAnnotation() {
        return this.injectionPointAnnotation;
    }

    @Override
    public List<Type> targetTypes() {
        return this.targetTypes;
    }

    @Override
    public List<String> matchingTargets() {
        return this.matchingTargets;
    }

    @Override
    public PatchContext patchContext() {
        return this.patchContext;
    }

    public static class Builder {
        private ClassNode classNode;
        private AnnotationValueHandle<?> classAnnotation;
        private MethodNode methodNode;
        private AnnotationHandle methodAnnotation;
        private AnnotationHandle injectionPointAnnotation;
        private final List<Type> targetTypes = new ArrayList<Type>();
        private final List<String> matchingTargets = new ArrayList<String>();

        public Builder classNode(ClassNode classNode) {
            this.classNode = classNode;
            return this;
        }

        public Builder classAnnotation(AnnotationValueHandle<?> annotation) {
            this.classAnnotation = annotation;
            return this;
        }

        public Builder methodNode(MethodNode methodNode) {
            this.methodNode = methodNode;
            return this;
        }

        public Builder methodAnnotation(AnnotationHandle annotation) {
            this.methodAnnotation = annotation;
            return this;
        }

        public Builder injectionPointAnnotation(AnnotationHandle annotation) {
            this.injectionPointAnnotation = annotation;
            return this;
        }

        public Builder targetTypes(List<Type> targetTypes) {
            this.targetTypes.addAll(targetTypes);
            return this;
        }

        public Builder matchingTargets(List<String> matchingTargets) {
            this.matchingTargets.addAll(matchingTargets);
            return this;
        }

        public MethodContextImpl build(PatchContext context) {
            return new MethodContextImpl(this.classNode, this.classAnnotation, this.methodNode, this.methodAnnotation, this.injectionPointAnnotation, List.copyOf(this.targetTypes), List.copyOf(this.matchingTargets), context);
        }
    }
}

