/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.worlds.together.levelgen;

import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3754;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7059;
import net.minecraft.class_7145;
import net.minecraft.class_7723;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import org.betterx.worlds.together.WorldsTogether;
import org.betterx.worlds.together.levelgen.BiomeRepairHelper;
import org.betterx.worlds.together.world.BiomeSourceWithNoiseRelatedSettings;
import org.betterx.worlds.together.world.BiomeSourceWithSeed;
import org.betterx.worlds.together.world.WorldConfig;
import org.betterx.worlds.together.world.event.WorldBootstrap;
import org.betterx.worlds.together.worldPreset.WorldPresets;
import org.jetbrains.annotations.ApiStatus;

public class WorldGenUtil {
    public static final String TAG_PRESET = "preset";
    public static final String TAG_GENERATOR = "generator";

    public static class_7723 createWorldFromPreset(class_5321<class_7145> preset, class_5455 registryAccess, long seed, boolean generateStructures, boolean generateBonusChest) {
        class_7723 settings = ((class_7145)registryAccess.method_30530(class_7924.field_41250).method_40290(preset).comp_349()).method_45546();
        for (class_5363 stem : settings.comp_1014()) {
            class_1966 class_19662;
            Object bcl;
            class_1966 class_19663 = stem.comp_1013().method_12098();
            if (class_19663 instanceof BiomeSourceWithSeed) {
                bcl = (BiomeSourceWithSeed)class_19663;
                bcl.setSeed(seed);
            }
            if (!((class_19662 = stem.comp_1013().method_12098()) instanceof BiomeSourceWithNoiseRelatedSettings)) continue;
            bcl = (BiomeSourceWithNoiseRelatedSettings)class_19662;
            class_19662 = stem.comp_1013();
            if (!(class_19662 instanceof class_3754)) continue;
            class_3754 noiseGenerator = (class_3754)class_19662;
            bcl.onLoadGeneratorSettings((class_5284)noiseGenerator.method_41541().comp_349());
        }
        return settings;
    }

    public static class_7723 createDefaultWorldFromPreset(class_5455 registryAccess, long seed, boolean generateStructures, boolean generateBonusChest) {
        return WorldGenUtil.createWorldFromPreset(WorldPresets.getDEFAULT(), registryAccess, seed, generateStructures, generateBonusChest);
    }

    public static class_7723 createDefaultWorldFromPreset(class_5455 registryAccess, long seed) {
        return WorldGenUtil.createDefaultWorldFromPreset(registryAccess, seed, true, false);
    }

    public static class_7723 createDefaultWorldFromPreset(class_5455 registryAccess) {
        return WorldGenUtil.createDefaultWorldFromPreset(registryAccess, class_5819.method_43047().method_43055());
    }

    public static class_2487 getPresetsNbt() {
        return WorldConfig.getCompoundTag("worlds_together", TAG_PRESET);
    }

    public static class_2487 getGeneratorNbt() {
        class_2487 root = WorldConfig.getRootTag("worlds_together");
        if (root.method_10545(TAG_GENERATOR)) {
            return WorldConfig.getCompoundTag("worlds_together", TAG_GENERATOR);
        }
        return null;
    }

    @ApiStatus.Internal
    public static class_2378<class_5363> repairBiomeSourceInAllDimensions(class_5455 registryAccess, class_2378<class_5363> dimensionRegistry) {
        return new BiomeRepairHelper().repairBiomeSourceInAllDimensions(registryAccess, dimensionRegistry);
    }

    public static class_2960 getBiomeID(class_1959 biome) {
        class_2960 id = null;
        class_5455 access = WorldBootstrap.getLastRegistryAccessOrElseBuiltin();
        id = access.method_30530(class_7924.field_41236).method_10221((Object)biome);
        if (id == null) {
            WorldsTogether.LOGGER.error("Unable to get ID for " + biome + ".");
        }
        return id;
    }

    public static class StemContext {
        public final class_6880<class_2874> dimension;
        public final class_7871<class_7059> structureSets;
        public final class_6880<class_5284> generatorSettings;

        public StemContext(class_6880<class_2874> dimension, class_7871<class_7059> structureSets, class_6880<class_5284> generatorSettings) {
            this.dimension = dimension;
            this.structureSets = structureSets;
            this.generatorSettings = generatorSettings;
        }
    }

    public static class Context
    extends StemContext {
        public Context(class_6880<class_2874> dimension, class_7871<class_7059> structureSets, class_6880<class_5284> generatorSettings) {
            super(dimension, structureSets, generatorSettings);
        }
    }
}

