/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_5819;
import org.betterx.bclib.util.Pair;

public class WeightedList<T> {
    private final List<Float> weights = new ArrayList<Float>();
    private final List<T> values = new ArrayList<T>();
    private float maxWeight;

    public static <T> Codec<Pair<Float, T>> pairCodec(Codec<T> elementCodec, String fieldName) {
        return Pair.pairCodec(Codec.FLOAT, elementCodec, "weight", fieldName);
    }

    public static <T> Codec<WeightedList<T>> listCodec(Codec<T> elementCodec, String fieldName, String elementName) {
        return RecordCodecBuilder.create(instance -> instance.group((App)WeightedList.pairCodec(elementCodec, elementName).listOf().fieldOf(fieldName).forGetter(WeightedList::pairs)).apply((Applicative)instance, WeightedList::new));
    }

    private List<Pair<Float, T>> pairs() {
        ArrayList<Pair<Float, T>> pairs = new ArrayList<Pair<Float, T>>(this.weights.size());
        for (int i = 0; i < this.weights.size(); ++i) {
            pairs.add(new Pair<Float, T>(this.weights.get(i), this.values.get(i)));
        }
        return pairs;
    }

    private WeightedList(List<Pair<Float, T>> pairs) {
        this.maxWeight = 0.0f;
        for (Pair<Float, T> pair : pairs) {
            this.maxWeight += ((Float)pair.first).floatValue();
            this.weights.add((Float)pair.first);
            this.values.add(pair.second);
        }
    }

    public WeightedList() {
    }

    public <R> WeightedList<R> map(Function<T, R> map) {
        ArrayList<Pair<Float, T>> pairs = new ArrayList<Pair<Float, T>>(this.weights.size());
        for (int i = 0; i < this.weights.size(); ++i) {
            pairs.add(new Pair<Float, R>(this.weights.get(i), map.apply(this.values.get(i))));
        }
        return new WeightedList<T>(pairs);
    }

    public void addAll(WeightedList<T> other) {
        this.weights.addAll(other.weights);
        this.values.addAll(other.values);
        this.maxWeight += other.maxWeight;
    }

    public void add(T value, float weight) {
        this.maxWeight += weight;
        this.weights.add(Float.valueOf(this.maxWeight));
        this.values.add(value);
    }

    public T get(class_5819 random) {
        if (this.maxWeight <= 0.0f) {
            return null;
        }
        float weight = random.method_43057() * this.maxWeight;
        for (int i = 0; i < this.weights.size(); ++i) {
            if (weight <= this.weights.get(i).floatValue()) {
                return this.values.get(i);
            }
            weight -= this.weights.get(i).floatValue();
        }
        return null;
    }

    public T get(int index) {
        return this.values.get(index);
    }

    public float getWeight(int index) {
        return this.weights.get(index).floatValue();
    }

    public boolean isEmpty() {
        return this.maxWeight == 0.0f;
    }

    public int size() {
        return this.values.size();
    }

    protected WeightedList<T> subList(int start, int end) {
        WeightedList<T> list = new WeightedList<T>();
        for (int i = start; i < end; ++i) {
            list.weights.add(this.weights.get(i));
            list.values.add(this.values.get(i));
        }
        return list;
    }

    public boolean contains(T value) {
        return this.values.contains(value);
    }

    public void forEach(Consumer<T> function) {
        this.values.forEach(function);
    }

    public float getMaxWeight() {
        return this.maxWeight;
    }
}

