/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.network;

import io.netty.buffer.Unpooled;
import java.util.function.BiConsumer;
import mod.azure.azurelibarmor.network.api.IClientPacket;
import mod.azure.azurelibarmor.network.api.IPacket;
import mod.azure.azurelibarmor.network.api.IPacketEncoder;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class Networking {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Network");

    public static void sendClientPacket(ServerPlayer target, IClientPacket<?> packet) {
        Networking.dispatch(packet, (packetId, buffer) -> ServerPlayNetworking.send((ServerPlayer)target, (ResourceLocation)packetId, (FriendlyByteBuf)buffer));
    }

    private static <T> void dispatch(IPacket<T> packet, BiConsumer<ResourceLocation, FriendlyByteBuf> dispatcher) {
        ResourceLocation packetId = packet.getPacketId();
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        IPacketEncoder<T> encoder = packet.getEncoder();
        T data = packet.getPacketData();
        encoder.encode(data, buffer);
        dispatcher.accept(packetId, buffer);
    }
}

