/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.event;

import com.mojang.blaze3d.vertex.PoseStack;
import mod.azure.azurelibarmor.cache.object.BakedGeoModel;
import mod.azure.azurelibarmor.renderer.GeoArmorRenderer;
import mod.azure.azurelibarmor.renderer.GeoItemRenderer;
import mod.azure.azurelibarmor.renderer.GeoRenderer;
import mod.azure.azurelibarmor.renderer.layer.GeoRenderLayer;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface GeoRenderEvent {
    public GeoRenderer<?> getRenderer();

    public static abstract class Item
    implements GeoRenderEvent {
        private final GeoItemRenderer<?> renderer;

        public Item(GeoItemRenderer<?> renderer) {
            this.renderer = renderer;
        }

        public GeoItemRenderer<?> getRenderer() {
            return this.renderer;
        }

        public ItemStack getItemStack() {
            return ((GeoItemRenderer)this.getRenderer()).getCurrentItemStack();
        }

        public static class CompileRenderLayers
        extends Item {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, post -> {}, listeners -> event -> {
                for (Listener listener : listeners) {
                    listener.handle(event);
                }
            });

            public CompileRenderLayers(GeoItemRenderer<?> renderer) {
                super(renderer);
            }

            public void addLayer(GeoRenderLayer renderLayer) {
                ((GeoItemRenderer)this.getRenderer()).addRenderLayer(renderLayer);
            }

            @FunctionalInterface
            public static interface Listener {
                public void handle(CompileRenderLayers var1);
            }
        }

        public static class Post
        extends Item {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, post -> {}, listeners -> event -> {
                for (Listener listener : listeners) {
                    listener.handle(event);
                }
            });
            private final PoseStack poseStack;
            private final BakedGeoModel model;
            private final MultiBufferSource bufferSource;
            private final float partialTick;
            private final int packedLight;

            public Post(GeoItemRenderer<?> renderer, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
                super(renderer);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
                this.partialTick = partialTick;
                this.packedLight = packedLight;
            }

            public PoseStack getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public MultiBufferSource getBufferSource() {
                return this.bufferSource;
            }

            public float getPartialTick() {
                return this.partialTick;
            }

            public int getPackedLight() {
                return this.packedLight;
            }

            @FunctionalInterface
            public static interface Listener {
                public void handle(Post var1);
            }
        }

        public static class Pre
        extends Item {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, event -> true, listeners -> event -> {
                for (Listener listener : listeners) {
                    if (listener.handle(event)) continue;
                    return false;
                }
                return true;
            });
            private final PoseStack poseStack;
            private final BakedGeoModel model;
            private final MultiBufferSource bufferSource;
            private final float partialTick;
            private final int packedLight;

            public Pre(GeoItemRenderer<?> renderer, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
                super(renderer);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
                this.partialTick = partialTick;
                this.packedLight = packedLight;
            }

            public PoseStack getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public MultiBufferSource getBufferSource() {
                return this.bufferSource;
            }

            public float getPartialTick() {
                return this.partialTick;
            }

            public int getPackedLight() {
                return this.packedLight;
            }

            @FunctionalInterface
            public static interface Listener {
                public boolean handle(Pre var1);
            }
        }
    }

    public static abstract class Armor
    implements GeoRenderEvent {
        private final GeoArmorRenderer<?> renderer;

        public Armor(GeoArmorRenderer<?> renderer) {
            this.renderer = renderer;
        }

        public GeoArmorRenderer<?> getRenderer() {
            return this.renderer;
        }

        @Nullable
        public Entity getEntity() {
            return ((GeoArmorRenderer)this.getRenderer()).getCurrentEntity();
        }

        @Nullable
        public ItemStack getItemStack() {
            return ((GeoArmorRenderer)this.getRenderer()).getCurrentStack();
        }

        @Nullable
        public EquipmentSlot getEquipmentSlot() {
            return ((GeoArmorRenderer)this.getRenderer()).getCurrentSlot();
        }

        public static class CompileRenderLayers
        extends Armor {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, post -> {}, listeners -> event -> {
                for (Listener listener : listeners) {
                    listener.handle(event);
                }
            });

            public CompileRenderLayers(GeoArmorRenderer<?> renderer) {
                super(renderer);
            }

            public void addLayer(GeoRenderLayer renderLayer) {
                ((GeoArmorRenderer)this.getRenderer()).addRenderLayer(renderLayer);
            }

            @FunctionalInterface
            public static interface Listener {
                public void handle(CompileRenderLayers var1);
            }
        }

        public static class Post
        extends Armor {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, post -> {}, listeners -> event -> {
                for (Listener listener : listeners) {
                    listener.handle(event);
                }
            });
            private final PoseStack poseStack;
            private final BakedGeoModel model;
            private final MultiBufferSource bufferSource;
            private final float partialTick;
            private final int packedLight;

            public Post(GeoArmorRenderer<?> renderer, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
                super(renderer);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
                this.partialTick = partialTick;
                this.packedLight = packedLight;
            }

            public PoseStack getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public MultiBufferSource getBufferSource() {
                return this.bufferSource;
            }

            public float getPartialTick() {
                return this.partialTick;
            }

            public int getPackedLight() {
                return this.packedLight;
            }

            @FunctionalInterface
            public static interface Listener {
                public void handle(Post var1);
            }
        }

        public static class Pre
        extends Armor {
            public static final Event<Listener> EVENT = EventFactory.createArrayBacked(Listener.class, event -> true, listeners -> event -> {
                for (Listener listener : listeners) {
                    if (listener.handle(event)) continue;
                    return false;
                }
                return true;
            });
            private final PoseStack poseStack;
            private final BakedGeoModel model;
            private final MultiBufferSource bufferSource;
            private final float partialTick;
            private final int packedLight;

            public Pre(GeoArmorRenderer<?> renderer, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
                super(renderer);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
                this.partialTick = partialTick;
                this.packedLight = packedLight;
            }

            public PoseStack getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public MultiBufferSource getBufferSource() {
                return this.bufferSource;
            }

            public float getPartialTick() {
                return this.partialTick;
            }

            public int getPackedLight() {
                return this.packedLight;
            }

            @FunctionalInterface
            public static interface Listener {
                public boolean handle(Pre var1);
            }
        }
    }
}

