/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;
import twilightforest.TFConfig;
import twilightforest.init.TFParticleType;
import twilightforest.network.ParticlePacket;
import twilightforest.network.TFPacketHandler;

public class CloudBlock
extends Block {
    @Nullable
    protected final Biome.Precipitation precipitation;

    public CloudBlock(BlockBehaviour.Properties properties, @Nullable Biome.Precipitation precipitation) {
        super(properties);
        this.precipitation = precipitation;
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        entity.m_142535_(fallDistance, 0.1f, level.m_269111_().m_268989_());
    }

    public int m_7753_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1;
    }

    @Nullable
    public Biome.Precipitation getPrecipitation() {
        return this.precipitation;
    }

    public Pair<Biome.Precipitation, Float> getCurrentPrecipitation(BlockPos pos, Level level, float rainLevel) {
        if (this.getPrecipitation() == null) {
            if (rainLevel > 0.0f) {
                return Pair.of((Object)((Biome)level.m_204166_(pos).get()).m_264600_(pos), (Object)Float.valueOf(rainLevel));
            }
            return Pair.of((Object)Biome.Precipitation.NONE, (Object)Float.valueOf(0.0f));
        }
        return Pair.of((Object)this.getPrecipitation(), (Object)Float.valueOf(1.0f));
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        Biome.Precipitation precipitation;
        if (!level.isAreaLoaded(pos, 1) || (Integer)TFConfig.COMMON_CONFIG.cloudBlockPrecipitationDistanceCommon.get() == 0) {
            return;
        }
        Pair<Biome.Precipitation, Float> pair = this.getCurrentPrecipitation(pos, (Level)level, level.m_46722_(1.0f));
        if (((Float)pair.getRight()).floatValue() > 0.0f && ((precipitation = (Biome.Precipitation)pair.getLeft()) == Biome.Precipitation.RAIN || precipitation == Biome.Precipitation.SNOW)) {
            int highestRainyBlock = pos.m_123342_() - 1;
            for (int y = pos.m_123342_() - 1; y > pos.m_123342_() - (Integer)TFConfig.COMMON_CONFIG.cloudBlockPrecipitationDistanceCommon.get() && !Heightmap.Types.MOTION_BLOCKING.m_64299_().test(level.m_8055_(pos.m_175288_(y))); --y) {
                highestRainyBlock = y - 1;
            }
            if (highestRainyBlock > level.m_141937_()) {
                if (precipitation == Biome.Precipitation.SNOW) {
                    int snowHeight = level.m_46469_().m_46215_(GameRules.f_254637_);
                    BlockPos snowOnPos = pos.m_175288_(highestRainyBlock + 1);
                    if (snowHeight > 0 && CloudBlock.shouldSnow((LevelReader)level, snowOnPos)) {
                        BlockState snowOnState = level.m_8055_(snowOnPos);
                        if (snowOnState.m_60713_(Blocks.f_50125_)) {
                            int k = (Integer)snowOnState.m_61143_((Property)SnowLayerBlock.f_56581_);
                            if (k < Math.min(snowHeight, 8)) {
                                BlockState snowLayerState = (BlockState)snowOnState.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(k + 1));
                                Block.m_49897_((BlockState)snowOnState, (BlockState)snowLayerState, (LevelAccessor)level, (BlockPos)snowOnPos);
                                level.m_46597_(snowOnPos, snowLayerState);
                            }
                        } else {
                            level.m_46597_(snowOnPos, Blocks.f_50125_.m_49966_());
                        }
                    }
                }
                BlockPos rainOnPos = pos.m_175288_(highestRainyBlock);
                BlockState rainOnState = level.m_8055_(rainOnPos);
                rainOnState.m_60734_().m_141997_(rainOnState, (Level)level, rainOnPos, precipitation);
            }
        }
    }

    public static boolean shouldSnow(LevelReader level, BlockPos pos) {
        if (pos.m_123342_() >= level.m_141937_() && pos.m_123342_() < level.m_151558_() && level.m_45517_(LightLayer.BLOCK, pos) < 10) {
            BlockState blockstate = level.m_8055_(pos);
            return (blockstate.m_60795_() || blockstate.m_60713_(Blocks.f_50125_)) && Blocks.f_50125_.m_49966_().m_60710_(level, pos);
        }
        return false;
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity living, int numberOfParticles) {
        ParticlePacket particlePacket = new ParticlePacket();
        int maxI = Mth.m_14045_((int)((int)living.f_19789_ * 2), (int)8, (int)40);
        double bbWidth = living.m_20205_();
        double y = living.m_20186_() + 0.1;
        double ySpeed = 5.0E-4 * (double)maxI;
        for (int i = 0; i < maxI; ++i) {
            double xSpd = (living.m_217043_().m_188500_() - 0.5) * bbWidth * 2.5;
            double zSpd = (living.m_217043_().m_188500_() - 0.5) * bbWidth * 2.5;
            double x = living.m_20185_() + xSpd;
            double z = living.m_20189_() + zSpd;
            double xSpeed = xSpd * 0.0035 * (double)maxI;
            double zSpeed = zSpd * 0.0035 * (double)maxI;
            particlePacket.queueParticle((ParticleOptions)TFParticleType.CLOUD_PUFF.get(), false, x, y, z, xSpeed, ySpeed, zSpeed);
        }
        TFPacketHandler.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)), (Object)particlePacket);
        return true;
    }

    public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (level.m_5776_() && state.m_60799_() != RenderShape.INVISIBLE) {
            CloudBlock.addEntityMovementParticles(level, pos, entity, false);
        }
        return true;
    }

    public static void addEntityMovementParticles(Level level, BlockPos pos, Entity entity, boolean jumping) {
        if (level.f_46441_.m_188499_()) {
            return;
        }
        Vec3 deltaMovement = entity.m_20184_();
        BlockPos blockpos1 = entity.m_20183_();
        double jumpMultiplier = jumping ? 2.0 : 1.0;
        double x = entity.m_20185_() + (level.f_46441_.m_188500_() - 0.5) * (double)entity.f_19815_.f_20377_ * jumpMultiplier;
        double y = entity.m_20186_() + 0.1;
        double z = entity.m_20189_() + (level.f_46441_.m_188500_() - 0.5) * (double)entity.f_19815_.f_20377_ * jumpMultiplier;
        if (blockpos1.m_123341_() != pos.m_123341_()) {
            x = Mth.m_14008_((double)x, (double)pos.m_123341_(), (double)((double)pos.m_123341_() + 1.0));
        }
        if (blockpos1.m_123343_() != pos.m_123343_()) {
            z = Mth.m_14008_((double)z, (double)pos.m_123343_(), (double)((double)pos.m_123343_() + 1.0));
        }
        level.m_7106_((ParticleOptions)TFParticleType.CLOUD_PUFF.get(), x, y, z, deltaMovement.f_82479_ * -0.5, 0.015 * jumpMultiplier, deltaMovement.f_82481_ * -0.5);
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new IClientBlockExtensions(){

            public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine manager) {
                BlockHitResult hitResult;
                BlockPos pos;
                BlockState blockstate;
                if (level.f_46441_.m_188499_() && target instanceof BlockHitResult && (blockstate = level.m_8055_(pos = (hitResult = (BlockHitResult)target).m_82425_())).m_60799_() != RenderShape.INVISIBLE) {
                    Particle particle;
                    Direction side = hitResult.m_82434_();
                    int posX = pos.m_123341_();
                    int posY = pos.m_123342_();
                    int posZ = pos.m_123343_();
                    AABB aabb = blockstate.m_60808_((BlockGetter)level, pos).m_83215_();
                    double x = (double)posX + level.f_46441_.m_188500_() * (aabb.f_82291_ - aabb.f_82288_ - (double)0.2f) + (double)0.1f + aabb.f_82288_;
                    double y = (double)posY + level.f_46441_.m_188500_() * (aabb.f_82292_ - aabb.f_82289_ - (double)0.2f) + (double)0.1f + aabb.f_82289_;
                    double z = (double)posZ + level.f_46441_.m_188500_() * (aabb.f_82293_ - aabb.f_82290_ - (double)0.2f) + (double)0.1f + aabb.f_82290_;
                    if (side == Direction.DOWN) {
                        y = (double)posY + aabb.f_82289_ - (double)0.1f;
                    }
                    if (side == Direction.UP) {
                        y = (double)posY + aabb.f_82292_ + (double)0.1f;
                    }
                    if (side == Direction.NORTH) {
                        z = (double)posZ + aabb.f_82290_ - (double)0.1f;
                    }
                    if (side == Direction.SOUTH) {
                        z = (double)posZ + aabb.f_82293_ + (double)0.1f;
                    }
                    if (side == Direction.WEST) {
                        x = (double)posX + aabb.f_82288_ - (double)0.1f;
                    }
                    if (side == Direction.EAST) {
                        x = (double)posX + aabb.f_82291_ + (double)0.1f;
                    }
                    if ((particle = Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)TFParticleType.CLOUD_PUFF.get(), x, y, z, (double)side.m_122429_() * 0.01, (double)side.m_122430_() * 0.01, (double)side.m_122431_() * 0.01)) == null) {
                        return true;
                    }
                    manager.m_107344_(particle);
                }
                return true;
            }

            public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine manager) {
                state.m_60808_((BlockGetter)level, pos).m_83286_((boxX, boxY, boxZ, boxX1, boxY1, boxZ1) -> {
                    double xSize = Math.min(1.0, boxX1 - boxX);
                    double ySize = Math.min(1.0, boxY1 - boxY);
                    double zSize = Math.min(1.0, boxZ1 - boxZ);
                    int xMax = Math.max(2, Mth.m_14165_((double)(xSize / 0.25)));
                    int yMax = Math.max(2, Mth.m_14165_((double)(ySize / 0.25)));
                    int zMax = Math.max(2, Mth.m_14165_((double)(zSize / 0.25)));
                    for (int xSlice = 0; xSlice < xMax; ++xSlice) {
                        if (level.f_46441_.m_188503_(3) == 1) continue;
                        for (int ySlice = 0; ySlice < yMax; ++ySlice) {
                            if (level.f_46441_.m_188503_(3) == 1) continue;
                            for (int zSlice = 0; zSlice < zMax; ++zSlice) {
                                if (level.f_46441_.m_188503_(3) == 1) continue;
                                double speedX = ((double)xSlice + 0.5) / (double)xMax;
                                double speedY = ((double)ySlice + 0.5) / (double)yMax;
                                double speedZ = ((double)zSlice + 0.5) / (double)zMax;
                                double x = speedX * xSize + boxX;
                                double y = speedY * ySize + boxY;
                                double z = speedZ * zSize + boxZ;
                                speedX = (speedX - 0.5) * 0.05;
                                speedY = (speedY - 0.5) * 0.05;
                                speedZ = (speedZ - 0.5) * 0.05;
                                Particle particle = Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)TFParticleType.CLOUD_PUFF.get(), (double)pos.m_123341_() + x, (double)pos.m_123342_() + y, (double)pos.m_123343_() + z, speedX, speedY, speedZ);
                                if (particle == null) {
                                    return;
                                }
                                manager.m_107344_(particle);
                            }
                        }
                    }
                });
                return true;
            }
        });
    }
}

