/*
 * Decompiled with CFR 0.152.
 */
package net.archers.item;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import net.archers.ArchersMod;
import net.archers.config.TweaksConfig;
import net.archers.item.Group;
import net.archers.item.weapon.CustomWeaponItem;
import net.fabric_extras.ranged_weapon.api.CustomBow;
import net.fabric_extras.ranged_weapon.api.CustomCrossbow;
import net.fabric_extras.ranged_weapon.api.CustomRangedWeapon;
import net.fabric_extras.ranged_weapon.api.RangedConfig;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.item.ItemConfig;
import net.spell_engine.api.item.weapon.Weapon;

public class Weapons {
    public static final ArrayList<RangedEntry> rangedEntries = new ArrayList();
    public static final ArrayList<Weapon.Entry> meleeEntries = new ArrayList();
    private static final String BETTER_END = "betterend";
    private static final String BETTER_NETHER = "betternether";
    public static final Weapon.Entry flint_spear = Weapons.spear("flint_spear", Weapon.CustomMaterial.matching((Tiers)Tiers.STONE, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42484_})), 4.0f);
    public static final Weapon.Entry iron_spear = Weapons.spear("iron_spear", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_})), 5.0f);
    public static final Weapon.Entry golden_spear = Weapons.spear("golden_spear", Weapon.CustomMaterial.matching((Tiers)Tiers.GOLD, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42417_})), 3.0f);
    public static final Weapon.Entry diamond_spear = Weapons.spear("diamond_spear", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})), 6.0f);
    public static final Weapon.Entry netherite_spear = Weapons.spear("netherite_spear", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_})), 7.0f);
    private static final int durabilityTier0 = 384;
    private static final int durabilityTier1 = 465;
    private static final int durabilityTier2 = Tiers.DIAMOND.m_6609_();
    private static final int durabilityTier3 = Tiers.NETHERITE.m_6609_();
    private static final int pullTime_shortBow = 16;
    private static final int pullTime_longBow = 30;
    private static final int pullTime_rapidCrossbow = 20;
    private static final int pullTime_heavyCrossbow = 35;
    public static RangedEntry composite_longbow = Weapons.bow("composite_longbow", 465, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42500_}), new RangedConfig(30, 8.0f, 0.0f));
    public static RangedEntry mechanic_shortbow = Weapons.bow("mechanic_shortbow", durabilityTier2, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42451_}), new RangedConfig(16, 8.0f, 0.0f));
    public static RangedEntry royal_longbow = Weapons.bow("royal_longbow", durabilityTier2, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42417_}), new RangedConfig(30, 10.0f, 0.0f));
    public static RangedEntry netherite_shortbow = Weapons.bow("netherite_shortbow", durabilityTier3, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_}), new RangedConfig(16, 9.0f, 0.0f));
    public static RangedEntry netherite_longbow = Weapons.bow("netherite_longbow", durabilityTier3, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_}), new RangedConfig(30, 12.0f, 0.0f));
    public static RangedEntry rapid_crossbow = Weapons.crossbow("rapid_crossbow", durabilityTier2, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42451_}), new RangedConfig(20, 8.5f, 0.0f));
    public static RangedEntry heavy_crossbow = Weapons.crossbow("heavy_crossbow", durabilityTier2, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_}), new RangedConfig(35, 13.0f, 0.0f));
    public static RangedEntry netherite_rapid_crossbow = Weapons.crossbow("netherite_rapid_crossbow", durabilityTier3, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_}), new RangedConfig(20, 9.5f, 0.0f));
    public static RangedEntry netherite_heavy_crossbow = Weapons.crossbow("netherite_heavy_crossbow", durabilityTier3, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_}), new RangedConfig(35, 15.0f, 0.0f));

    private static Supplier<Ingredient> ingredient(String idString, boolean requirement, Item fallback) {
        ResourceLocation id = new ResourceLocation(idString);
        if (requirement) {
            return () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{fallback});
        }
        return () -> {
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(id);
            Item ingredient = item != null ? item : fallback;
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient});
        };
    }

    private static Weapon.Entry addMelee(String requiredMod, String name, Weapon.CustomMaterial material, Item item, ItemConfig.Weapon defaults) {
        Weapon.Entry entry = new Weapon.Entry("archers", name, material, item, defaults, null);
        if (entry.isRequiredModInstalled()) {
            meleeEntries.add(entry);
        }
        return entry;
    }

    private static Weapon.Entry spear(String name, Weapon.CustomMaterial material, float damage) {
        return Weapons.spear(null, name, material, damage);
    }

    private static Weapon.Entry spear(String requiredMod, String name, Weapon.CustomMaterial material, float damage) {
        Item.Properties settings = new Item.Properties();
        CustomWeaponItem item = new CustomWeaponItem((Tier)material, settings);
        return Weapons.addMelee(requiredMod, name, material, (Item)item, new ItemConfig.Weapon(damage, -2.6f));
    }

    private static RangedEntry addRanged(ResourceLocation id, Item item, RangedConfig defaults) {
        RangedEntry entry = new RangedEntry(id, item, defaults);
        rangedEntries.add(entry);
        return entry;
    }

    private static RangedEntry bow(String name, int durability, Supplier<Ingredient> repairIngredientSupplier, RangedConfig defaults) {
        FabricItemSettings settings = new FabricItemSettings().maxDamage(durability);
        CustomBow item = new CustomBow((Item.Properties)settings, repairIngredientSupplier);
        ((CustomRangedWeapon)item).configure(defaults);
        return Weapons.addRanged(new ResourceLocation("archers", name), (Item)item, defaults);
    }

    private static RangedEntry crossbow(String name, int durability, Supplier<Ingredient> repairIngredientSupplier, RangedConfig defaults) {
        FabricItemSettings settings = new FabricItemSettings().maxDamage(durability);
        CustomCrossbow item = new CustomCrossbow((Item.Properties)settings, repairIngredientSupplier);
        ((CustomRangedWeapon)item).configure(defaults);
        return Weapons.addRanged(new ResourceLocation("archers", name), (Item)item, defaults);
    }

    public static void register(Map<String, RangedConfig> rangedConfig, Map<String, ItemConfig.Weapon> meleeConfig) {
        if (((TweaksConfig)ArchersMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(BETTER_END)) {
            Supplier<Ingredient> aeterniumRepair = Weapons.ingredient("betterend:aeternium_ingot", FabricLoader.getInstance().isModLoaded(BETTER_END), Items.f_42418_);
            Supplier<Ingredient> crystalRepair = Weapons.ingredient("betterend:crystal_shards", FabricLoader.getInstance().isModLoaded(BETTER_END), Items.f_42418_);
            Weapons.spear("aeternium_spear", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, aeterniumRepair), 8.0f);
            Weapons.bow("crystal_shortbow", durabilityTier3, crystalRepair, new RangedConfig(16, 10.0f, 0.0f));
            Weapons.bow("crystal_longbow", durabilityTier3, crystalRepair, new RangedConfig(30, 13.5f, 0.0f));
        }
        if (((TweaksConfig)ArchersMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(BETTER_NETHER)) {
            Supplier<Ingredient> rubyRepair = Weapons.ingredient("betternether:nether_ruby", FabricLoader.getInstance().isModLoaded(BETTER_NETHER), Items.f_42418_);
            Weapons.spear("ruby_spear", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, rubyRepair), 8.0f);
            Weapons.crossbow("ruby_rapid_crossbow", durabilityTier3, rubyRepair, new RangedConfig(20, 10.5f, 0.0f));
            Weapons.crossbow("ruby_heavy_crossbow", durabilityTier3, rubyRepair, new RangedConfig(35, 17.0f, 0.0f));
        }
        Weapon.register(meleeConfig, meleeEntries, Group.KEY);
        for (RangedEntry entry : rangedEntries) {
            RangedConfig config = rangedConfig.get(entry.id.toString());
            if (config == null) {
                config = entry.defaults;
                rangedConfig.put(entry.id.toString(), config);
            }
            ((CustomRangedWeapon)entry.item).configure(config);
            Registry.m_122965_((Registry)BuiltInRegistries.f_257033_, (ResourceLocation)entry.id, (Object)entry.item);
        }
        ItemGroupEvents.modifyEntriesEvent(Group.KEY).register(content -> {
            for (RangedEntry entry : rangedEntries) {
                content.m_246326_((ItemLike)entry.item);
            }
        });
    }

    public record RangedEntry(ResourceLocation id, Item item, RangedConfig defaults) {
    }
}

