/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.worldgen.feature.tree;

import biomesoplenty.common.worldgen.feature.configurations.BasicTreeConfiguration;
import biomesoplenty.common.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;

public class BasicTreeFeature
extends BOPTreeFeature<BasicTreeConfiguration> {
    public BasicTreeFeature(Codec<BasicTreeConfiguration> codec) {
        super(codec);
    }

    protected boolean m_225257_(WorldGenLevel world, RandomSource random, BlockPos pos, BiConsumer<BlockPos, BlockState> roots, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, TreeConfiguration configBase) {
        BasicTreeConfiguration config = (BasicTreeConfiguration)configBase;
        int height = random.m_188503_(config.maxHeight - config.minHeight) + config.minHeight;
        boolean hasSpace = true;
        if (pos.m_123342_() >= world.m_141937_() + 1 && pos.m_123342_() + height + 1 <= world.m_151558_()) {
            int x;
            int leavesRadius;
            int currentLayer;
            int y;
            for (int y2 = pos.m_123342_(); y2 <= pos.m_123342_() + 1 + height; ++y2) {
                int radius = 1;
                if (y2 == pos.m_123342_()) {
                    radius = 0;
                }
                if (y2 >= pos.m_123342_() + 1 + height - 2) {
                    radius = 2;
                }
                for (int x2 = pos.m_123341_() - radius; x2 <= pos.m_123341_() + radius && hasSpace; ++x2) {
                    for (int z = pos.m_123343_() - radius; z <= pos.m_123343_() + radius && hasSpace; ++z) {
                        if (y2 >= world.m_141937_() && y2 < world.m_151558_()) {
                            if (this.canReplace((LevelAccessor)world, new BlockPos(x2, y2, z))) continue;
                            hasSpace = false;
                            continue;
                        }
                        hasSpace = false;
                    }
                }
            }
            if (!hasSpace) {
                return false;
            }
            BlockPos soilPos = pos.m_7495_();
            Block soil = world.m_8055_(soilPos).m_60734_();
            world.m_7731_(soilPos, Blocks.f_50493_.m_49966_(), 3);
            int leavesLayers = config.leafLayers - 1;
            for (y = pos.m_123342_() + height - leavesLayers; y <= pos.m_123342_() + height; ++y) {
                currentLayer = y - (pos.m_123342_() + height);
                leavesRadius = config.maxLeavesRadius - currentLayer / config.leavesLayerHeight;
                for (x = pos.m_123341_() - leavesRadius; x <= pos.m_123341_() + leavesRadius; ++x) {
                    int xDiff = x - pos.m_123341_();
                    for (int z = pos.m_123343_() - leavesRadius; z <= pos.m_123343_() + leavesRadius; ++z) {
                        BlockPos leavesPos;
                        int zDiff = z - pos.m_123343_();
                        if (Math.abs(xDiff) == leavesRadius && Math.abs(zDiff) == leavesRadius && (random.m_188503_(2) == 0 || currentLayer == 0) || !this.canReplace((LevelAccessor)world, leavesPos = new BlockPos(x, y, z))) continue;
                        if (config.altFoliageProvider.m_213972_(random, pos) != Blocks.f_50016_.m_49966_()) {
                            if (random.m_188503_(4) == 0) {
                                this.placeAltLeaves((LevelAccessor)world, leavesPos, leaves, config);
                                continue;
                            }
                            this.placeLeaves((LevelAccessor)world, leavesPos, leaves, config);
                            continue;
                        }
                        this.placeLeaves((LevelAccessor)world, leavesPos, leaves, config);
                    }
                }
            }
            this.generateTrunk((LevelAccessor)world, pos, height, logs, config);
            if (config.vineProvider.m_213972_(random, pos) != Blocks.f_50016_.m_49966_()) {
                for (y = pos.m_123342_() - leavesLayers + height; y <= pos.m_123342_() + height; ++y) {
                    currentLayer = y - (pos.m_123342_() + height);
                    leavesRadius = config.maxLeavesRadius + config.leavesOffset - currentLayer / config.leavesLayerHeight;
                    for (x = pos.m_123341_() - leavesRadius; x <= pos.m_123341_() + leavesRadius; ++x) {
                        for (int z = pos.m_123343_() - leavesRadius; z <= pos.m_123343_() + leavesRadius; ++z) {
                            BlockPos blockpos3 = new BlockPos(x, y, z);
                            if (!world.m_8055_(blockpos3).m_204336_(BlockTags.f_13035_)) continue;
                            BlockPos westPos = blockpos3.m_122024_();
                            BlockPos eastPos = blockpos3.m_122029_();
                            BlockPos northPos = blockpos3.m_122012_();
                            BlockPos southPos = blockpos3.m_122019_();
                            if (random.m_188503_(4) == 0 && this.canPlaceVinesOn((LevelAccessor)world, westPos)) {
                                this.extendVines((LevelAccessor)world, random, westPos, Direction.EAST, config);
                            }
                            if (random.m_188503_(4) == 0 && this.canPlaceVinesOn((LevelAccessor)world, eastPos)) {
                                this.extendVines((LevelAccessor)world, random, eastPos, Direction.WEST, config);
                            }
                            if (random.m_188503_(4) == 0 && this.canPlaceVinesOn((LevelAccessor)world, northPos)) {
                                this.extendVines((LevelAccessor)world, random, northPos, Direction.SOUTH, config);
                            }
                            if (random.m_188503_(4) != 0 || !this.canPlaceVinesOn((LevelAccessor)world, southPos)) continue;
                            this.extendVines((LevelAccessor)world, random, southPos, Direction.NORTH, config);
                        }
                    }
                }
            }
            if (config.hangingProvider.m_213972_(random, pos) != Blocks.f_50016_.m_49966_()) {
                this.generateHanging((LevelAccessor)world, pos, random, height, config);
            }
            if (config.trunkFruitProvider.m_213972_(random, pos) != Blocks.f_50016_.m_49966_() && random.m_188503_(5) == 0 && height > 5) {
                for (int l3 = 0; l3 < 2; ++l3) {
                    for (Direction Direction2 : Direction.Plane.HORIZONTAL) {
                        if (random.m_188503_(4 - l3) != 0) continue;
                        Direction Direction1 = Direction2.m_122424_();
                        this.generateTrunkFruit((LevelAccessor)world, random, random.m_188503_(3), pos.m_7918_(Direction1.m_122429_(), height - 5 + l3, Direction1.m_122431_()), Direction2, config);
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected void generateTrunk(LevelAccessor world, BlockPos start, int height, BiConsumer<BlockPos, BlockState> logs, BasicTreeConfiguration config) {
        for (int layer = 0; layer < height; ++layer) {
            BlockPos blockpos2 = start.m_6630_(layer);
            if (!this.canReplace(world, blockpos2)) continue;
            this.placeLog(world, start.m_6630_(layer), logs, config);
        }
    }

    protected void generateHanging(LevelAccessor world, BlockPos start, RandomSource rand, int height, BasicTreeConfiguration config) {
        int y = start.m_123342_() + (height - config.leafLayers);
        for (int x = start.m_123341_() - (config.maxLeavesRadius + 1); x <= start.m_123341_() + (config.maxLeavesRadius + 1); ++x) {
            for (int z = start.m_123343_() - (config.maxLeavesRadius + 1); z <= start.m_123343_() + (config.maxLeavesRadius + 1); ++z) {
                BlockPos hangingPos = new BlockPos(x, y, z);
                if (world.m_46859_(hangingPos.m_7494_()) || !world.m_46859_(hangingPos) || !(rand.m_188501_() <= config.hangingChance)) continue;
                this.setHanging(world, hangingPos, config);
            }
        }
    }

    private void generateTrunkFruit(LevelAccessor world, RandomSource random, int age, BlockPos pos, Direction direction, BasicTreeConfiguration config) {
        if (config.trunkFruitProvider.m_213972_(random, pos) == Blocks.f_50262_.m_49966_()) {
            this.m_5974_((LevelWriter)world, pos, (BlockState)((BlockState)config.trunkFruitProvider.m_213972_(random, pos).m_61124_((Property)CocoaBlock.f_51736_, (Comparable)Integer.valueOf(age))).m_61124_((Property)CocoaBlock.f_54117_, (Comparable)direction));
        } else {
            this.m_5974_((LevelWriter)world, pos, (BlockState)config.trunkFruitProvider.m_213972_(random, pos).m_61124_((Property)CocoaBlock.f_54117_, (Comparable)direction));
        }
    }

    private BlockState getVineStateForSide(RandomSource random, BlockPos pos, Direction side, BasicTreeConfiguration config) {
        return config.vineProvider.m_213972_(random, pos).m_60734_() instanceof VineBlock ? (BlockState)config.vineProvider.m_213972_(random, pos).m_61124_((Property)VineBlock.m_57883_((Direction)side), (Comparable)Boolean.valueOf(true)) : config.vineProvider.m_213972_(random, pos);
    }

    private void extendVines(LevelAccessor world, RandomSource random, BlockPos pos, Direction side, BasicTreeConfiguration config) {
        BlockState vineState = this.getVineStateForSide(random, pos, side, config);
        this.m_5974_((LevelWriter)world, pos, vineState);
        pos = pos.m_7495_();
        for (int length = 4; this.canPlaceVinesOn(world, pos) && length > 0; --length) {
            this.m_5974_((LevelWriter)world, pos, vineState);
            pos = pos.m_7495_();
        }
    }

    protected boolean canPlaceVinesOn(LevelAccessor world, BlockPos pos) {
        return world.m_8055_(pos).m_60795_();
    }
}

