/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.attributesmod.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.puffish.attributesmod.AttributesMod;
import net.puffish.attributesmod.util.Sign;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private float modifyVariableAtDamage(float damage, DamageSource source) {
        if (damage < 0.0f) {
            return damage;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            damage = source.m_269533_(DamageTypeTags.f_268524_) ? (float)AttributesMod.applyAttributeModifiers(damage, Sign.POSITIVE.wrap(player.m_21051_(AttributesMod.RANGED_DAMAGE))) : (float)AttributesMod.applyAttributeModifiers(damage, Sign.POSITIVE.wrap(player.m_21051_(AttributesMod.MELEE_DAMAGE)));
        }
        return damage;
    }

    @ModifyVariable(method={"heal"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private float modifyVariableAtHeal(float amount) {
        if (amount < 0.0f) {
            return amount;
        }
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            amount = (float)AttributesMod.applyAttributeModifiers(amount, Sign.POSITIVE.wrap(player.m_21051_(AttributesMod.HEALING)));
        }
        return amount;
    }

    @ModifyReturnValue(method={"getJumpVelocity"}, at={@At(value="RETURN")})
    private float injectAtGetJumpVelocity(float jump) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return (float)AttributesMod.applyAttributeModifiers(jump, Sign.POSITIVE.wrap(player.m_21051_(AttributesMod.JUMP)));
        }
        return jump;
    }

    @ModifyVariable(method={"computeFallDamage"}, at=@At(value="STORE"), ordinal=2)
    private float modifyVariableAtComputeFallDamage(float reduction) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            reduction += ((float)AttributesMod.applyAttributeModifiers(1.0, Sign.POSITIVE.wrap(player.m_21051_(AttributesMod.JUMP))) - 1.0f) * 10.0f;
        }
        return reduction;
    }

    @ModifyReturnValue(method={"modifyAppliedDamage"}, at={@At(value="TAIL")})
    private float injectAtModifyAppliedDamage(float damage) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (damage < 1.1342745E38f) {
                return Math.max(0.0f, (float)AttributesMod.applyAttributeModifiers(damage, Sign.NEGATIVE.wrap(player.m_21051_(AttributesMod.RESISTANCE))));
            }
        }
        return damage;
    }
}

