/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.attributesmod;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.puffish.attributesmod.attribute.DynamicEntityAttribute;
import net.puffish.attributesmod.mixin.EntityAttributeInstanceInvoker;
import net.puffish.attributesmod.util.Registrar;
import net.puffish.attributesmod.util.Signed;

public class AttributesMod {
    public static final String MOD_ID = "puffish_attributes";
    public static final ResourceLocation STAMINA_ID = AttributesMod.createAttributeIdentifier("player", "stamina");
    public static final Attribute STAMINA = AttributesMod.createClampedAttribute(STAMINA_ID, 4.0, 0.0, 1024.0).m_22084_(true);
    public static final ResourceLocation MELEE_DAMAGE_ID = AttributesMod.createAttributeIdentifier("player", "melee_damage");
    public static final Attribute MELEE_DAMAGE = AttributesMod.createDynamicAttribute(MELEE_DAMAGE_ID).m_22084_(true);
    public static final ResourceLocation RANGED_DAMAGE_ID = AttributesMod.createAttributeIdentifier("player", "ranged_damage");
    public static final Attribute RANGED_DAMAGE = AttributesMod.createDynamicAttribute(RANGED_DAMAGE_ID).m_22084_(true);
    public static final ResourceLocation FORTUNE_ID = AttributesMod.createAttributeIdentifier("player", "fortune");
    public static final Attribute FORTUNE = AttributesMod.createDynamicAttribute(FORTUNE_ID).m_22084_(true);
    public static final ResourceLocation HEALING_ID = AttributesMod.createAttributeIdentifier("player", "healing");
    public static final Attribute HEALING = AttributesMod.createDynamicAttribute(HEALING_ID).m_22084_(true);
    public static final ResourceLocation JUMP_ID = AttributesMod.createAttributeIdentifier("player", "jump");
    public static final Attribute JUMP = AttributesMod.createDynamicAttribute(JUMP_ID).m_22084_(true);
    public static final ResourceLocation RESISTANCE_ID = AttributesMod.createAttributeIdentifier("player", "resistance");
    public static final Attribute RESISTANCE = AttributesMod.createDynamicAttribute(RESISTANCE_ID).m_22084_(true);
    public static final ResourceLocation MINING_SPEED_ID = AttributesMod.createAttributeIdentifier("player", "mining_speed");
    public static final Attribute MINING_SPEED = AttributesMod.createDynamicAttribute(MINING_SPEED_ID).m_22084_(true);
    public static final ResourceLocation PICKAXE_SPEED_ID = AttributesMod.createAttributeIdentifier("player", "pickaxe_speed");
    public static final Attribute PICKAXE_SPEED = AttributesMod.createDynamicAttribute(PICKAXE_SPEED_ID).m_22084_(true);
    public static final ResourceLocation AXE_SPEED_ID = AttributesMod.createAttributeIdentifier("player", "axe_speed");
    public static final Attribute AXE_SPEED = AttributesMod.createDynamicAttribute(AXE_SPEED_ID).m_22084_(true);
    public static final ResourceLocation SHOVEL_SPEED_ID = AttributesMod.createAttributeIdentifier("player", "shovel_speed");
    public static final Attribute SHOVEL_SPEED = AttributesMod.createDynamicAttribute(SHOVEL_SPEED_ID).m_22084_(true);
    public static final ResourceLocation SPRINTING_SPEED_ID = AttributesMod.createAttributeIdentifier("player", "sprinting_speed");
    public static final Attribute SPRINTING_SPEED = AttributesMod.createDynamicAttribute(SPRINTING_SPEED_ID).m_22084_(true);
    public static final ResourceLocation KNOCKBACK_ID = AttributesMod.createAttributeIdentifier("player", "knockback");
    public static final Attribute KNOCKBACK = AttributesMod.createDynamicAttribute(KNOCKBACK_ID).m_22084_(true);
    public static final ResourceLocation REPAIR_COST_ID = AttributesMod.createAttributeIdentifier("player", "repair_cost");
    public static final Attribute REPAIR_COST = AttributesMod.createDynamicAttribute(REPAIR_COST_ID).m_22084_(true);

    public static void setup(Registrar registrar) {
        registrar.register(BuiltInRegistries.f_256951_, STAMINA_ID, STAMINA);
        registrar.register(BuiltInRegistries.f_256951_, MELEE_DAMAGE_ID, MELEE_DAMAGE);
        registrar.register(BuiltInRegistries.f_256951_, RANGED_DAMAGE_ID, RANGED_DAMAGE);
        registrar.register(BuiltInRegistries.f_256951_, FORTUNE_ID, FORTUNE);
        registrar.register(BuiltInRegistries.f_256951_, HEALING_ID, HEALING);
        registrar.register(BuiltInRegistries.f_256951_, JUMP_ID, JUMP);
        registrar.register(BuiltInRegistries.f_256951_, RESISTANCE_ID, RESISTANCE);
        registrar.register(BuiltInRegistries.f_256951_, MINING_SPEED_ID, MINING_SPEED);
        registrar.register(BuiltInRegistries.f_256951_, PICKAXE_SPEED_ID, PICKAXE_SPEED);
        registrar.register(BuiltInRegistries.f_256951_, AXE_SPEED_ID, AXE_SPEED);
        registrar.register(BuiltInRegistries.f_256951_, SHOVEL_SPEED_ID, SHOVEL_SPEED);
        registrar.register(BuiltInRegistries.f_256951_, SPRINTING_SPEED_ID, SPRINTING_SPEED);
        registrar.register(BuiltInRegistries.f_256951_, KNOCKBACK_ID, KNOCKBACK);
        registrar.register(BuiltInRegistries.f_256951_, REPAIR_COST_ID, REPAIR_COST);
    }

    public static ResourceLocation createIdentifier(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static ResourceLocation createAttributeIdentifier(String type, String name) {
        return AttributesMod.createIdentifier(type + "." + name);
    }

    public static Attribute createClampedAttribute(ResourceLocation id, double fallback, double min, double max) {
        return new RangedAttribute(id.m_214296_("attribute"), fallback, min, max);
    }

    public static Attribute createDynamicAttribute(ResourceLocation id) {
        return new DynamicEntityAttribute(id.m_214296_("attribute"));
    }

    @SafeVarargs
    public static double applyAttributeModifiers(double initial, Signed<AttributeInstance> ... attributes) {
        for (Signed<AttributeInstance> signedAttribute : attributes) {
            block13: for (AttributeModifier modifier : ((EntityAttributeInstanceInvoker)signedAttribute.value()).invokeGetModifiersByOperation(AttributeModifier.Operation.ADDITION)) {
                switch (signedAttribute.sign()) {
                    case POSITIVE: {
                        initial += modifier.m_22218_();
                        continue block13;
                    }
                    case NEGATIVE: {
                        initial -= modifier.m_22218_();
                        continue block13;
                    }
                }
                throw new IllegalStateException();
            }
        }
        double result = initial;
        for (Signed<AttributeInstance> signedAttribute : attributes) {
            block15: for (AttributeModifier modifier : ((EntityAttributeInstanceInvoker)signedAttribute.value()).invokeGetModifiersByOperation(AttributeModifier.Operation.MULTIPLY_BASE)) {
                switch (signedAttribute.sign()) {
                    case POSITIVE: {
                        result += initial * modifier.m_22218_();
                        continue block15;
                    }
                    case NEGATIVE: {
                        result -= initial * modifier.m_22218_();
                        continue block15;
                    }
                }
                throw new IllegalStateException();
            }
        }
        for (Signed<AttributeInstance> signedAttribute : attributes) {
            block17: for (AttributeModifier modifier : ((EntityAttributeInstanceInvoker)signedAttribute.value()).invokeGetModifiersByOperation(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
                switch (signedAttribute.sign()) {
                    case POSITIVE: {
                        result *= 1.0 + modifier.m_22218_();
                        continue block17;
                    }
                    case NEGATIVE: {
                        result *= 1.0 - modifier.m_22218_();
                        continue block17;
                    }
                }
                throw new IllegalStateException();
            }
        }
        for (Signed<AttributeInstance> signedAttribute : attributes) {
            result = signedAttribute.value().m_22099_().m_6740_(result);
        }
        return result;
    }
}

