/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.mixin;

import com.google.common.collect.ImmutableList;
import dev.emi.trinkets.Point;
import dev.emi.trinkets.SurvivalTrinketSlot;
import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.TrinketsClient;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.mixin.accessor.ScreenHandlerAccessor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={InventoryMenu.class})
public abstract class PlayerScreenHandlerMixin
extends AbstractContainerMenu
implements TrinketPlayerScreenHandler {
    @Shadow
    @Final
    private Player f_39703_;
    @Unique
    private final Map<SlotGroup, Integer> groupNums = new HashMap<SlotGroup, Integer>();
    @Unique
    private final Map<SlotGroup, Point> groupPos = new HashMap<SlotGroup, Point>();
    @Unique
    private final Map<SlotGroup, List<Point>> slotHeights = new HashMap<SlotGroup, List<Point>>();
    @Unique
    private final Map<SlotGroup, List<SlotType>> slotTypes = new HashMap<SlotGroup, List<SlotType>>();
    @Unique
    private final Map<SlotGroup, Integer> slotWidths = new HashMap<SlotGroup, Integer>();
    @Unique
    private int trinketSlotStart = 0;
    @Unique
    private int trinketSlotEnd = 0;
    @Unique
    private int groupCount = 0;
    @Unique
    private Inventory inventory;

    private PlayerScreenHandlerMixin() {
        super(null, 0);
    }

    @Inject(at={@At(value="RETURN")}, method={"<init>"})
    private void init(Inventory playerInv, boolean onServer, Player owner, CallbackInfo info) {
        this.inventory = playerInv;
        this.trinkets$updateTrinketSlots(true);
    }

    @Override
    public void trinkets$updateTrinketSlots(boolean slotsChanged) {
        TrinketsApi.getTrinketComponent((LivingEntity)this.f_39703_).ifPresent(trinkets -> {
            if (slotsChanged) {
                trinkets.update();
            }
            Map<String, SlotGroup> groups = trinkets.getGroups();
            this.groupPos.clear();
            while (this.trinketSlotStart < this.trinketSlotEnd) {
                this.f_38839_.remove(this.trinketSlotStart);
                ((ScreenHandlerAccessor)((Object)this)).getTrackedStacks().remove(this.trinketSlotStart);
                ((ScreenHandlerAccessor)((Object)this)).getPreviousTrackedStacks().remove(this.trinketSlotStart);
                --this.trinketSlotEnd;
            }
            int groupNum = 1;
            for (SlotGroup slotGroup : groups.values().stream().sorted(Comparator.comparing(SlotGroup::getOrder)).toList()) {
                int y;
                if (!this.hasSlots((TrinketComponent)trinkets, slotGroup)) continue;
                int id = slotGroup.getSlotId();
                if (id != -1) {
                    Slot slot;
                    if (this.f_38839_.size() <= id || (slot = (Slot)this.f_38839_.get(id)) instanceof SurvivalTrinketSlot) continue;
                    this.groupPos.put(slotGroup, new Point(slot.f_40220_, slot.f_40221_));
                    this.groupNums.put(slotGroup, -id);
                    continue;
                }
                int x = 77;
                if (groupNum >= 4) {
                    x = 4 - groupNum / 4 * 18;
                    y = 8 + groupNum % 4 * 18;
                } else {
                    y = 62 - groupNum * 18;
                }
                this.groupPos.put(slotGroup, new Point(x, y));
                this.groupNums.put(slotGroup, groupNum);
                ++groupNum;
            }
            this.groupCount = Math.max(0, groupNum - 4);
            this.trinketSlotStart = this.f_38839_.size();
            this.slotWidths.clear();
            this.slotHeights.clear();
            this.slotTypes.clear();
            for (Map.Entry entry : trinkets.getInventory().entrySet()) {
                String groupId = (String)entry.getKey();
                SlotGroup group = groups.get(groupId);
                int groupOffset = 1;
                if (group.getSlotId() != -1) {
                    ++groupOffset;
                }
                int width = 0;
                Point pos = this.trinkets$getGroupPos(group);
                if (pos == null) continue;
                for (Map.Entry slot : ((Map)entry.getValue()).entrySet().stream().sorted((a, b) -> Integer.compare(((TrinketInventory)a.getValue()).getSlotType().getOrder(), ((TrinketInventory)b.getValue()).getSlotType().getOrder())).toList()) {
                    TrinketInventory stacks = (TrinketInventory)slot.getValue();
                    if (stacks.m_6643_() == 0) continue;
                    int slotOffset = 1;
                    int x = (int)((double)(groupOffset / 2 * 18) * Math.pow(-1.0, groupOffset));
                    this.slotHeights.computeIfAbsent(group, k -> new ArrayList()).add(new Point(x, stacks.m_6643_()));
                    this.slotTypes.computeIfAbsent(group, k -> new ArrayList()).add(stacks.getSlotType());
                    for (int i = 0; i < stacks.m_6643_(); ++i) {
                        int y = (int)((double)pos.y() + (double)(slotOffset / 2 * 18) * Math.pow(-1.0, slotOffset));
                        this.m_38897_(new SurvivalTrinketSlot(stacks, i, x + pos.x(), y, group, stacks.getSlotType(), i, groupOffset == 1 && i == 0));
                        ++slotOffset;
                    }
                    ++groupOffset;
                    ++width;
                }
                this.slotWidths.put(group, width);
            }
            this.trinketSlotEnd = this.f_38839_.size();
        });
    }

    @Unique
    private boolean hasSlots(TrinketComponent comp, SlotGroup group) {
        for (TrinketInventory inv : comp.getInventory().get(group.getName()).values()) {
            if (inv.m_6643_() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int trinkets$getGroupNum(SlotGroup group) {
        return this.groupNums.getOrDefault(group, 0);
    }

    @Override
    @Nullable
    public Point trinkets$getGroupPos(SlotGroup group) {
        return this.groupPos.get(group);
    }

    @Override
    @Nonnull
    public List<Point> trinkets$getSlotHeights(SlotGroup group) {
        return this.slotHeights.getOrDefault(group, (List<Point>)ImmutableList.of());
    }

    @Override
    @Nullable
    public Point trinkets$getSlotHeight(SlotGroup group, int i) {
        List<Point> points = this.trinkets$getSlotHeights(group);
        return i < points.size() ? points.get(i) : null;
    }

    @Override
    @Nonnull
    public List<SlotType> trinkets$getSlotTypes(SlotGroup group) {
        return this.slotTypes.getOrDefault(group, (List<SlotType>)ImmutableList.of());
    }

    @Override
    public int trinkets$getSlotWidth(SlotGroup group) {
        return this.slotWidths.getOrDefault(group, 0);
    }

    @Override
    public int trinkets$getGroupCount() {
        return this.groupCount;
    }

    @Override
    public int trinkets$getTrinketSlotStart() {
        return this.trinketSlotStart;
    }

    @Override
    public int trinkets$getTrinketSlotEnd() {
        return this.trinketSlotEnd;
    }

    @Inject(at={@At(value="HEAD")}, method={"onClosed"})
    private void onClosed(Player player, CallbackInfo info) {
        if (player.m_9236_().f_46443_) {
            TrinketsClient.activeGroup = null;
            TrinketsClient.activeType = null;
            TrinketsClient.quickMoveGroup = null;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"quickMove"}, cancellable=true)
    private void quickMove(Player player, int index, CallbackInfoReturnable<ItemStack> info) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            if (index >= this.trinketSlotStart && index < this.trinketSlotEnd) {
                if (!this.m_38903_(stack, 9, 45, false)) {
                    info.setReturnValue((Object)ItemStack.f_41583_);
                } else {
                    info.setReturnValue((Object)stack);
                }
            } else if (index >= 9 && index < 45) {
                TrinketsApi.getTrinketComponent((LivingEntity)player).ifPresent(trinkets -> {
                    for (int i = this.trinketSlotStart; i < this.trinketSlotEnd; ++i) {
                        Slot s = (Slot)this.f_38839_.get(i);
                        if (!(s instanceof SurvivalTrinketSlot) || !s.m_5857_(stack)) continue;
                        SurvivalTrinketSlot ts = (SurvivalTrinketSlot)s;
                        SlotType type = ts.getType();
                        SlotReference ref = new SlotReference((TrinketInventory)ts.f_40218_, ts.m_150661_());
                        boolean res = TrinketsApi.evaluatePredicateSet(type.getQuickMovePredicates(), stack, ref, (LivingEntity)player);
                        if (!res || !this.m_38903_(stack, i, i + 1, false) || !player.m_9236_().f_46443_) continue;
                        TrinketsClient.quickMoveTimer = 20;
                        TrinketsClient.quickMoveGroup = TrinketsApi.getPlayerSlots(this.f_39703_).get(type.getGroup());
                        TrinketsClient.quickMoveType = ref.index() > 0 ? type : null;
                    }
                });
            }
        }
    }
}

