/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.mixin;

import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.TrinketsNetwork;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.data.EntitySlotLoader;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerList.class})
public abstract class PlayerManagerMixin {
    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;onSpawn()V")}, method={"onPlayerConnect"})
    private void onPlayerConnect(Connection connection, ServerPlayer player, CallbackInfo cb) {
        EntitySlotLoader.SERVER.sync(player);
        ((TrinketPlayerScreenHandler)player.f_36095_).trinkets$updateTrinketSlots(false);
        TrinketsApi.getTrinketComponent((LivingEntity)player).ifPresent(trinkets -> {
            FriendlyByteBuf buf = PacketByteBufs.create();
            buf.writeInt(player.m_19879_());
            CompoundTag tag = new CompoundTag();
            Set<TrinketInventory> inventoriesToSend = trinkets.getTrackingUpdates();
            for (TrinketInventory trinketInventory : inventoriesToSend) {
                tag.m_128365_(trinketInventory.getSlotType().getGroup() + "/" + trinketInventory.getSlotType().getName(), (Tag)trinketInventory.getSyncTag());
            }
            buf.m_130079_(tag);
            buf.m_130079_(new CompoundTag());
            ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)TrinketsNetwork.SYNC_INVENTORY, (FriendlyByteBuf)buf);
            inventoriesToSend.clear();
        });
    }
}

