/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.mixin;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.TrinketsNetwork;
import dev.emi.trinkets.api.SlotAttributes;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketEnums;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.event.TrinketDropCallback;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Unique
    private final Map<String, ItemStack> lastEquippedTrinkets = new HashMap<String, ItemStack>();

    @Shadow
    protected abstract AttributeMap m_21204_();

    private LivingEntityMixin() {
        super(null, null);
    }

    @Inject(at={@At(value="HEAD")}, method={"canFreeze"}, cancellable=true)
    private void canFreeze(CallbackInfoReturnable<Boolean> cir) {
        Optional<TrinketComponent> component = TrinketsApi.getTrinketComponent((LivingEntity)this);
        if (component.isPresent()) {
            for (Tuple<SlotReference, ItemStack> equipped : component.get().getAllEquipped()) {
                if (!((ItemStack)equipped.m_14419_()).m_204117_(ItemTags.f_144320_)) continue;
                cir.setReturnValue((Object)false);
                break;
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"dropInventory"})
    private void dropInventory(CallbackInfo info) {
        LivingEntity entity = (LivingEntity)this;
        boolean keepInv = entity.m_9236_().m_46469_().m_46207_(GameRules.f_46133_);
        TrinketsApi.getTrinketComponent(entity).ifPresent(trinkets -> trinkets.forEach((ref, stack) -> {
            if (stack.m_41619_()) {
                return;
            }
            TrinketEnums.DropRule dropRule = TrinketsApi.getTrinket(stack.m_41720_()).getDropRule((ItemStack)stack, (SlotReference)ref, entity);
            dropRule = ((TrinketDropCallback)TrinketDropCallback.EVENT.invoker()).drop(dropRule, (ItemStack)stack, (SlotReference)ref, entity);
            TrinketInventory inventory = ref.inventory();
            if (dropRule == TrinketEnums.DropRule.DEFAULT) {
                dropRule = inventory.getSlotType().getDropRule();
            }
            if (dropRule == TrinketEnums.DropRule.DEFAULT) {
                dropRule = keepInv && entity.m_6095_() == EntityType.f_20532_ ? TrinketEnums.DropRule.KEEP : (EnchantmentHelper.m_44924_((ItemStack)stack) ? TrinketEnums.DropRule.DESTROY : TrinketEnums.DropRule.DROP);
            }
            switch (dropRule) {
                case DROP: {
                    this.dropFromEntity((ItemStack)stack);
                }
                case DESTROY: {
                    inventory.m_6836_(ref.index(), ItemStack.f_41583_);
                    break;
                }
            }
        }));
    }

    private void dropFromEntity(ItemStack stack) {
        ItemEntity entity = this.m_19983_(stack);
        if (entity != null && this instanceof Player) {
            entity.m_20343_(entity.m_20185_(), this.m_20188_() - 0.3, entity.m_20189_());
            entity.m_32010_(40);
            float magnitude = this.f_19796_.m_188501_() * 0.5f;
            float angle = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
            entity.m_20334_((double)(-Mth.m_14031_((float)angle) * magnitude), (double)0.2f, (double)(Mth.m_14089_((float)angle) * magnitude));
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void tick(CallbackInfo info) {
        LivingEntity entity = (LivingEntity)this;
        TrinketsApi.getTrinketComponent(entity).ifPresent(trinkets -> {
            HashMap newlyEquippedTrinkets = new HashMap();
            HashMap contentUpdates = new HashMap();
            trinkets.forEach((ref, stack) -> {
                TrinketInventory inventory = ref.inventory();
                SlotType slotType = inventory.getSlotType();
                int index = ref.index();
                ItemStack oldStack = this.getOldStack(slotType, index);
                ItemStack newStack = inventory.m_8020_(index);
                ItemStack copy = newStack.m_41777_();
                String newRef = slotType.getGroup() + "/" + slotType.getName() + "/" + index;
                newlyEquippedTrinkets.put(newRef, copy);
                if (!ItemStack.m_41728_((ItemStack)newStack, (ItemStack)oldStack)) {
                    if (!this.m_9236_().f_46443_) {
                        SlotAttributes.SlotEntityAttribute slotAttr;
                        HashSet toRemove;
                        HashMultimap slotMap;
                        Multimap<Attribute, AttributeModifier> map;
                        Trinket trinket;
                        contentUpdates.put(newRef, copy);
                        UUID uuid = SlotAttributes.getUuid(ref);
                        if (!oldStack.m_41619_()) {
                            trinket = TrinketsApi.getTrinket(oldStack.m_41720_());
                            map = trinket.getModifiers(oldStack, (SlotReference)ref, entity, uuid);
                            slotMap = HashMultimap.create();
                            toRemove = Sets.newHashSet();
                            for (Attribute attr : map.keySet()) {
                                if (!(attr instanceof SlotAttributes.SlotEntityAttribute)) continue;
                                slotAttr = (SlotAttributes.SlotEntityAttribute)attr;
                                slotMap.putAll((Object)slotAttr.slot, (Iterable)map.get((Object)attr));
                                toRemove.add(slotAttr);
                            }
                            for (Attribute attr : toRemove) {
                                map.removeAll((Object)attr);
                            }
                            this.m_21204_().m_22161_(map);
                            trinkets.removeModifiers((Multimap<String, AttributeModifier>)slotMap);
                        }
                        if (!newStack.m_41619_()) {
                            trinket = TrinketsApi.getTrinket(newStack.m_41720_());
                            map = trinket.getModifiers(newStack, (SlotReference)ref, entity, uuid);
                            slotMap = HashMultimap.create();
                            toRemove = Sets.newHashSet();
                            for (Attribute attr : map.keySet()) {
                                if (!(attr instanceof SlotAttributes.SlotEntityAttribute)) continue;
                                slotAttr = (SlotAttributes.SlotEntityAttribute)attr;
                                slotMap.putAll((Object)slotAttr.slot, (Iterable)map.get((Object)attr));
                                toRemove.add(slotAttr);
                            }
                            for (Attribute attr : toRemove) {
                                map.removeAll((Object)attr);
                            }
                            this.m_21204_().m_22178_(map);
                            trinkets.addTemporaryModifiers((Multimap<String, AttributeModifier>)slotMap);
                        }
                    }
                    if (!ItemStack.m_41656_((ItemStack)oldStack, (ItemStack)newStack)) {
                        TrinketsApi.getTrinket(oldStack.m_41720_()).onUnequip(oldStack, (SlotReference)ref, entity);
                        TrinketsApi.getTrinket(newStack.m_41720_()).onEquip(newStack, (SlotReference)ref, entity);
                    }
                }
            });
            if (!this.m_9236_().f_46443_) {
                Set<TrinketInventory> inventoriesToSend = trinkets.getTrackingUpdates();
                if (!contentUpdates.isEmpty() || !inventoriesToSend.isEmpty()) {
                    FriendlyByteBuf buf = PacketByteBufs.create();
                    buf.writeInt(entity.m_19879_());
                    CompoundTag tag = new CompoundTag();
                    for (TrinketInventory trinketInventory : inventoriesToSend) {
                        tag.m_128365_(trinketInventory.getSlotType().getGroup() + "/" + trinketInventory.getSlotType().getName(), (Tag)trinketInventory.getSyncTag());
                    }
                    buf.m_130079_(tag);
                    tag = new CompoundTag();
                    for (Map.Entry entry : contentUpdates.entrySet()) {
                        tag.m_128365_((String)entry.getKey(), (Tag)((ItemStack)entry.getValue()).m_41739_(new CompoundTag()));
                    }
                    buf.m_130079_(tag);
                    for (ServerPlayer serverPlayer : PlayerLookup.tracking((Entity)entity)) {
                        ServerPlayNetworking.send((ServerPlayer)serverPlayer, (ResourceLocation)TrinketsNetwork.SYNC_INVENTORY, (FriendlyByteBuf)buf);
                    }
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        ServerPlayNetworking.send((ServerPlayer)serverPlayer, (ResourceLocation)TrinketsNetwork.SYNC_INVENTORY, (FriendlyByteBuf)buf);
                        if (!inventoriesToSend.isEmpty()) {
                            ((TrinketPlayerScreenHandler)serverPlayer.f_36095_).trinkets$updateTrinketSlots(false);
                        }
                    }
                    inventoriesToSend.clear();
                }
            }
            this.lastEquippedTrinkets.clear();
            this.lastEquippedTrinkets.putAll(newlyEquippedTrinkets);
        });
    }

    @Unique
    private ItemStack getOldStack(SlotType type, int index) {
        return this.lastEquippedTrinkets.getOrDefault(type.getGroup() + "/" + type.getName() + "/" + index, ItemStack.f_41583_);
    }
}

