/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.mixin;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import dev.emi.trinkets.TrinketSlot;
import dev.emi.trinkets.api.SlotAttributes;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isSectionVisible(ILnet/minecraft/item/ItemStack$TooltipSection;)Z", ordinal=4, shift=At.Shift.BEFORE)}, method={"getTooltip"}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void getTooltip(Player player, TooltipFlag context, CallbackInfoReturnable<List<Component>> info, List<Component> list) {
        TrinketsApi.getTrinketComponent((LivingEntity)player).ifPresent(comp -> {
            ItemStack self = (ItemStack)this;
            boolean canEquipAnywhere = true;
            HashSet slots = Sets.newHashSet();
            HashMap modifiers = Maps.newHashMap();
            Multimap<Attribute, AttributeModifier> defaultModifier = null;
            boolean allModifiersSame = true;
            int slotCount = 0;
            for (Map.Entry<String, Map<String, TrinketInventory>> group : comp.getInventory().entrySet()) {
                block1: for (Map.Entry<String, TrinketInventory> inventory : group.getValue().entrySet()) {
                    TrinketInventory trinketInventory = inventory.getValue();
                    SlotType slotType = trinketInventory.getSlotType();
                    ++slotCount;
                    boolean anywhereButHidden = false;
                    for (int i = 0; i < trinketInventory.m_6643_(); ++i) {
                        SlotReference ref = new SlotReference(trinketInventory, i);
                        boolean res = TrinketsApi.evaluatePredicateSet(slotType.getTooltipPredicates(), self, ref, (LivingEntity)player);
                        boolean canInsert = TrinketSlot.canInsert(self, ref, (LivingEntity)player);
                        if (res && canInsert) {
                            boolean sameTranslationExists = false;
                            for (SlotType t : slots) {
                                if (!t.getTranslation().getString().equals(slotType.getTranslation().getString())) continue;
                                sameTranslationExists = true;
                                break;
                            }
                            if (!sameTranslationExists) {
                                slots.add(slotType);
                            }
                            Trinket trinket = TrinketsApi.getTrinket(self.m_41720_());
                            Multimap<Attribute, AttributeModifier> map = trinket.getModifiers(self, ref, (LivingEntity)player, SlotAttributes.getUuid(ref));
                            if (defaultModifier == null) {
                                defaultModifier = map;
                            } else if (allModifiersSame) {
                                allModifiersSame = this.areMapsEqual(defaultModifier, map);
                            }
                            boolean duplicate = false;
                            for (Map.Entry entry : modifiers.entrySet()) {
                                if (!((SlotType)entry.getKey()).getTranslation().getString().equals(slotType.getTranslation().getString()) || !this.areMapsEqual((Multimap<Attribute, AttributeModifier>)((Multimap)entry.getValue()), map)) continue;
                                duplicate = true;
                                break;
                            }
                            if (duplicate) continue block1;
                            modifiers.put(slotType, map);
                            continue block1;
                        }
                        if (!canInsert) continue;
                        anywhereButHidden = true;
                    }
                    if (anywhereButHidden) continue;
                    canEquipAnywhere = false;
                }
            }
            if (canEquipAnywhere && slotCount > 1) {
                list.add((Component)Component.m_237115_((String)"trinkets.tooltip.slots.any").m_130940_(ChatFormatting.GRAY));
            } else if (slots.size() > 1) {
                list.add((Component)Component.m_237115_((String)"trinkets.tooltip.slots.list").m_130940_(ChatFormatting.GRAY));
                for (SlotType type : slots) {
                    list.add((Component)type.getTranslation().m_130940_(ChatFormatting.BLUE));
                }
            } else if (slots.size() == 1) {
                for (SlotType type : slots) {
                    list.add((Component)Component.m_237110_((String)"trinkets.tooltip.slots.single", (Object[])new Object[]{type.getTranslation().m_130940_(ChatFormatting.BLUE)}).m_130940_(ChatFormatting.GRAY));
                }
            }
            if (modifiers.size() > 0) {
                if (allModifiersSame) {
                    if (defaultModifier != null && !defaultModifier.isEmpty()) {
                        list.add((Component)Component.m_237115_((String)"trinkets.tooltip.attributes.all").m_130940_(ChatFormatting.GRAY));
                        this.addAttributes(list, defaultModifier);
                    }
                } else {
                    for (SlotType type : modifiers.keySet()) {
                        list.add((Component)Component.m_237110_((String)"trinkets.tooltip.attributes.single", (Object[])new Object[]{type.getTranslation().m_130940_(ChatFormatting.BLUE)}).m_130940_(ChatFormatting.GRAY));
                        this.addAttributes(list, (Multimap<Attribute, AttributeModifier>)((Multimap)modifiers.get(type)));
                    }
                }
            }
        });
    }

    @Unique
    private void addAttributes(List<Component> list, Multimap<Attribute, AttributeModifier> map) {
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entries()) {
                Attribute attribute = (Attribute)entry.getKey();
                AttributeModifier modifier = (AttributeModifier)entry.getValue();
                double g = modifier.m_22218_();
                if (modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL) {
                    if (((Attribute)entry.getKey()).equals(Attributes.f_22278_)) {
                        g *= 10.0;
                    }
                } else {
                    g *= 100.0;
                }
                MutableComponent text = Component.m_237115_((String)attribute.m_22087_());
                if (attribute instanceof SlotAttributes.SlotEntityAttribute) {
                    text = Component.m_237110_((String)"trinkets.tooltip.attributes.slots", (Object[])new Object[]{text});
                }
                if (g > 0.0) {
                    list.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + modifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(g), text}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(g < 0.0)) continue;
                list.add((Component)Component.m_237110_((String)("attribute.modifier.take." + modifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(g *= -1.0), text}).m_130940_(ChatFormatting.RED));
            }
        }
    }

    @Unique
    private boolean areMapsEqual(Multimap<Attribute, AttributeModifier> map1, Multimap<Attribute, AttributeModifier> map2) {
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Attribute attribute : map1.keySet()) {
            if (!map2.containsKey((Object)attribute)) {
                return false;
            }
            Collection col1 = map1.get((Object)attribute);
            Collection col2 = map2.get((Object)attribute);
            if (col1.size() != col2.size()) {
                return false;
            }
            Iterator iter = col2.iterator();
            for (AttributeModifier modifier : col1) {
                AttributeModifier eam = (AttributeModifier)iter.next();
                if (modifier.m_22219_().equals((Object)eam.m_22219_())) continue;
                return false;
            }
        }
        return true;
    }
}

