/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.mixin;

import com.google.common.collect.Maps;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ExperienceOrb.class})
public class ExperienceOrbEntityMixin {
    @Unique
    private Player mendingPlayer;

    @Inject(at={@At(value="HEAD")}, method={"repairPlayerGears"})
    private void repairPlayerGears(Player player, int amount, CallbackInfoReturnable<Integer> info) {
        this.mendingPlayer = player;
    }

    @ModifyVariable(at=@At(value="INVOKE_ASSIGN", target="net/minecraft/enchantment/EnchantmentHelper.chooseEquipmentWith(Lnet/minecraft/enchantment/Enchantment;Lnet/minecraft/entity/LivingEntity;Ljava/util/function/Predicate;)Ljava/util/Map$Entry;"), method={"repairPlayerGears"}, ordinal=0)
    private Map.Entry<EquipmentSlot, ItemStack> modifyEntry(Map.Entry<EquipmentSlot, ItemStack> entry) {
        Optional<TrinketComponent> optional = TrinketsApi.getTrinketComponent((LivingEntity)this.mendingPlayer);
        if (optional.isPresent()) {
            TrinketComponent comp = optional.get();
            Predicate<ItemStack> predicate = stack -> !stack.m_41619_() && stack.m_41768_() && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44962_, (ItemStack)stack) > 0;
            List<Tuple<SlotReference, ItemStack>> list = comp.getEquipped(predicate);
            int totalSize = list.size();
            if (entry != null) {
                Map map = Enchantments.f_44962_.m_44684_((LivingEntity)this.mendingPlayer);
                ArrayList originalList = new ArrayList();
                for (Map.Entry ent : map.entrySet()) {
                    if (!predicate.test((ItemStack)ent.getValue())) continue;
                    originalList.add(ent);
                }
                totalSize += originalList.size();
            }
            if (totalSize == 0) {
                return entry;
            }
            int selected = this.mendingPlayer.m_217043_().m_188503_(totalSize);
            if (selected < list.size()) {
                Tuple<SlotReference, ItemStack> pair = list.get(selected);
                HashMap dummyMap = Maps.newHashMap();
                dummyMap.put(EquipmentSlot.MAINHAND, (ItemStack)pair.m_14419_());
                entry = dummyMap.entrySet().iterator().next();
            }
        }
        this.mendingPlayer = null;
        return entry;
    }
}

