/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.emi.trinkets.TrinketsMain;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketEnums;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public class SlotLoader
extends SimplePreparableReloadListener<Map<String, GroupData>>
implements IdentifiableResourceReloadListener {
    public static final SlotLoader INSTANCE = new SlotLoader();
    static final ResourceLocation ID = new ResourceLocation("trinkets", "slots");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final int FILE_SUFFIX_LENGTH = ".json".length();
    private Map<String, GroupData> slots = new HashMap<String, GroupData>();

    protected Map<String, GroupData> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap<String, GroupData> map = new HashMap<String, GroupData>();
        String dataType = "slots";
        for (Map.Entry entry : resourceManager.m_214160_(dataType, id -> id.m_135815_().endsWith(".json")).entrySet()) {
            ResourceLocation identifier = (ResourceLocation)entry.getKey();
            if (!identifier.m_135827_().equals("trinkets")) continue;
            try {
                for (Resource resource : (List)entry.getValue()) {
                    InputStreamReader reader = new InputStreamReader(resource.m_215507_());
                    JsonObject jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (jsonObject == null) continue;
                    String path = identifier.m_135815_();
                    String[] parsed = path.substring(dataType.length() + 1, path.length() - FILE_SUFFIX_LENGTH).split("/");
                    String groupName = parsed[0];
                    String fileName = parsed[parsed.length - 1];
                    GroupData group = map.computeIfAbsent(groupName, k -> new GroupData());
                    try {
                        if (fileName.equals("group")) {
                            group.read(jsonObject);
                            continue;
                        }
                        SlotData slot = group.slots.computeIfAbsent(fileName, k -> new SlotData());
                        slot.read(jsonObject);
                    }
                    catch (JsonSyntaxException e) {
                        TrinketsMain.LOGGER.error("[trinkets] Syntax error while reading data for " + path);
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                TrinketsMain.LOGGER.error("[trinkets] Unknown IO error while reading slot data!");
                e.printStackTrace();
            }
        }
        return map;
    }

    protected void apply(Map<String, GroupData> loader, ResourceManager manager, ProfilerFiller profiler) {
        this.slots = loader;
    }

    public Map<String, GroupData> getSlots() {
        return ImmutableMap.copyOf(this.slots);
    }

    public ResourceLocation getFabricId() {
        return ID;
    }

    static class GroupData {
        private int slotId = -1;
        private int order = 0;
        private final Map<String, SlotData> slots = new HashMap<String, SlotData>();

        GroupData() {
        }

        void read(JsonObject jsonObject) {
            this.slotId = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"slot_id", (int)this.slotId);
            this.order = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"order", (int)this.order);
        }

        int getSlotId() {
            return this.slotId;
        }

        int getOrder() {
            return this.order;
        }

        SlotData getSlot(String name) {
            return this.slots.get(name);
        }
    }

    static class SlotData {
        private static final Set<ResourceLocation> DEFAULT_QUICK_MOVE_PREDICATES = ImmutableSet.of((Object)new ResourceLocation("trinkets", "all"));
        private static final Set<ResourceLocation> DEFAULT_VALIDATOR_PREDICATES = ImmutableSet.of((Object)new ResourceLocation("trinkets", "tag"));
        private static final Set<ResourceLocation> DEFAULT_TOOLTIP_PREDICATES = ImmutableSet.of((Object)new ResourceLocation("trinkets", "all"));
        private int order = 0;
        private int amount = -1;
        private String icon = "";
        private final Set<String> quickMovePredicates = new HashSet<String>();
        private final Set<String> validatorPredicates = new HashSet<String>();
        private final Set<String> tooltipPredicates = new HashSet<String>();
        private String dropRule = TrinketEnums.DropRule.DEFAULT.toString();

        SlotData() {
        }

        SlotType create(String group, String name) {
            ResourceLocation finalIcon = new ResourceLocation(this.icon);
            finalIcon = new ResourceLocation(finalIcon.m_135827_(), "textures/" + finalIcon.m_135815_() + ".png");
            Set<ResourceLocation> finalValidatorPredicates = this.validatorPredicates.stream().map(ResourceLocation::new).collect(Collectors.toSet());
            Set<ResourceLocation> finalQuickMovePredicates = this.quickMovePredicates.stream().map(ResourceLocation::new).collect(Collectors.toSet());
            Set<ResourceLocation> finalTooltipPredicates = this.tooltipPredicates.stream().map(ResourceLocation::new).collect(Collectors.toSet());
            if (finalValidatorPredicates.isEmpty()) {
                finalValidatorPredicates = DEFAULT_VALIDATOR_PREDICATES;
            }
            if (finalQuickMovePredicates.isEmpty()) {
                finalQuickMovePredicates = DEFAULT_QUICK_MOVE_PREDICATES;
            }
            if (finalTooltipPredicates.isEmpty()) {
                finalTooltipPredicates = DEFAULT_TOOLTIP_PREDICATES;
            }
            if (this.amount == -1) {
                this.amount = 1;
            }
            return new SlotType(group, name, this.order, this.amount, finalIcon, finalQuickMovePredicates, finalValidatorPredicates, finalTooltipPredicates, TrinketEnums.DropRule.valueOf(this.dropRule));
        }

        void read(JsonObject jsonObject) {
            JsonArray jsonTooltipPredicates;
            JsonArray jsonValidatorPredicates;
            String jsonDropRule;
            boolean replace = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"replace", (boolean)false);
            this.order = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"order", (int)this.order);
            int jsonAmount = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"amount", (int)this.amount);
            this.amount = replace ? jsonAmount : Math.max(jsonAmount, this.amount);
            this.icon = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"icon", (String)this.icon);
            JsonArray jsonQuickMovePredicates = GsonHelper.m_13832_((JsonObject)jsonObject, (String)"quick_move_predicates", (JsonArray)new JsonArray());
            if (jsonQuickMovePredicates != null) {
                if (replace && jsonQuickMovePredicates.size() > 0) {
                    this.quickMovePredicates.clear();
                }
                for (JsonElement jsonQuickMovePredicate : jsonQuickMovePredicates) {
                    this.quickMovePredicates.add(jsonQuickMovePredicate.getAsString());
                }
            }
            if (TrinketEnums.DropRule.has(jsonDropRule = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"drop_rule", (String)this.dropRule).toUpperCase())) {
                this.dropRule = jsonDropRule;
            }
            if ((jsonValidatorPredicates = GsonHelper.m_13832_((JsonObject)jsonObject, (String)"validator_predicates", (JsonArray)new JsonArray())) != null) {
                if (replace && jsonValidatorPredicates.size() > 0) {
                    this.validatorPredicates.clear();
                }
                for (JsonElement jsonValidatorPredicate : jsonValidatorPredicates) {
                    this.validatorPredicates.add(jsonValidatorPredicate.getAsString());
                }
            }
            if ((jsonTooltipPredicates = GsonHelper.m_13832_((JsonObject)jsonObject, (String)"tooltip_predicates", (JsonArray)new JsonArray())) != null) {
                if (replace && jsonTooltipPredicates.size() > 0) {
                    this.tooltipPredicates.clear();
                }
                for (JsonElement jsonTooltipPredicate : jsonTooltipPredicates) {
                    this.tooltipPredicates.add(jsonTooltipPredicate.getAsString());
                }
            }
        }
    }
}

