/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketEnums;
import dev.emi.trinkets.mixin.accessor.LivingEntityAccessor;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public interface Trinket {
    default public void tick(ItemStack stack, SlotReference slot, LivingEntity entity) {
    }

    default public void onEquip(ItemStack stack, SlotReference slot, LivingEntity entity) {
    }

    default public void onUnequip(ItemStack stack, SlotReference slot, LivingEntity entity) {
    }

    default public boolean canEquip(ItemStack stack, SlotReference slot, LivingEntity entity) {
        return true;
    }

    default public boolean canUnequip(ItemStack stack, SlotReference slot, LivingEntity entity) {
        return !EnchantmentHelper.m_44920_((ItemStack)stack);
    }

    default public Multimap<Attribute, AttributeModifier> getModifiers(ItemStack stack, SlotReference slot, LivingEntity entity, UUID uuid) {
        Multimap map = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), ArrayList::new);
        if (stack.m_41782_() && stack.m_41783_().m_128425_("TrinketAttributeModifiers", 9)) {
            ListTag list = stack.m_41783_().m_128437_("TrinketAttributeModifiers", 10);
            for (int i = 0; i < list.size(); ++i) {
                AttributeModifier entityAttributeModifier;
                Optional optional;
                CompoundTag tag = list.m_128728_(i);
                if (tag.m_128425_("Slot", 8) && !tag.m_128461_("Slot").equals(slot.inventory().getSlotType().getGroup() + "/" + slot.inventory().getSlotType().getName()) || !(optional = BuiltInRegistries.f_256951_.m_6612_(ResourceLocation.m_135820_((String)tag.m_128461_("AttributeName")))).isPresent() || (entityAttributeModifier = AttributeModifier.m_22212_((CompoundTag)tag)) == null || entityAttributeModifier.m_22209_().getLeastSignificantBits() == 0L || entityAttributeModifier.m_22209_().getMostSignificantBits() == 0L) continue;
                map.put((Object)((Attribute)optional.get()), (Object)entityAttributeModifier);
            }
        }
        return map;
    }

    default public void onBreak(ItemStack stack, SlotReference slot, LivingEntity entity) {
        ((LivingEntityAccessor)entity).invokePlayEquipmentBreakEffects(stack);
    }

    default public TrinketEnums.DropRule getDropRule(ItemStack stack, SlotReference slot, LivingEntity entity) {
        return TrinketEnums.DropRule.DEFAULT;
    }
}

