/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.api.SlotAttributes;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class LivingEntityTrinketComponent
implements TrinketComponent,
AutoSyncedComponent {
    public Map<String, Map<String, TrinketInventory>> inventory = new HashMap<String, Map<String, TrinketInventory>>();
    public Set<TrinketInventory> trackingUpdates = new HashSet<TrinketInventory>();
    public Map<String, SlotGroup> groups = new HashMap<String, SlotGroup>();
    public int size;
    public LivingEntity entity;
    private boolean syncing;

    public LivingEntityTrinketComponent(LivingEntity entity) {
        this.entity = entity;
        this.update();
    }

    @Override
    public LivingEntity getEntity() {
        return this.entity;
    }

    @Override
    public Map<String, SlotGroup> getGroups() {
        return this.groups;
    }

    @Override
    public Map<String, Map<String, TrinketInventory>> getInventory() {
        return this.inventory;
    }

    @Override
    public void update() {
        Map<String, SlotGroup> entitySlots = TrinketsApi.getEntitySlots((Entity)this.entity);
        int count = 0;
        this.groups.clear();
        HashMap<String, Map<String, TrinketInventory>> inventory = new HashMap<String, Map<String, TrinketInventory>>();
        for (Map.Entry<String, SlotGroup> group : entitySlots.entrySet()) {
            String groupKey = group.getKey();
            SlotGroup groupValue = group.getValue();
            Map<String, TrinketInventory> oldGroup = this.inventory.get(groupKey);
            this.groups.put(groupKey, groupValue);
            for (Map.Entry<String, SlotType> slot : groupValue.getSlots().entrySet()) {
                TrinketInventory oldInv;
                TrinketInventory inv = new TrinketInventory(slot.getValue(), this, e -> this.trackingUpdates.add((TrinketInventory)e));
                if (oldGroup != null && (oldInv = oldGroup.get(slot.getKey())) != null) {
                    inv.copyFrom(oldInv);
                    for (int i = 0; i < oldInv.m_6643_(); ++i) {
                        ItemStack stack = oldInv.m_8020_(i).m_41777_();
                        if (i < inv.m_6643_()) {
                            inv.m_6836_(i, stack);
                            continue;
                        }
                        LivingEntity livingEntity = this.entity;
                        if (livingEntity instanceof Player) {
                            Player player = (Player)livingEntity;
                            player.m_150109_().m_150079_(stack);
                            continue;
                        }
                        this.entity.m_19983_(stack);
                    }
                }
                inventory.computeIfAbsent(group.getKey(), k -> new HashMap()).put(slot.getKey(), inv);
                count += inv.m_6643_();
            }
        }
        this.size = count;
        this.inventory = inventory;
    }

    @Override
    public void clearCachedModifiers() {
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
                slotType.getValue().clearCachedModifiers();
            }
        }
    }

    @Override
    public Set<TrinketInventory> getTrackingUpdates() {
        return this.trackingUpdates;
    }

    @Override
    public void addTemporaryModifiers(Multimap<String, AttributeModifier> modifiers) {
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            String[] keys = ((String)entry.getKey()).split("/");
            String group = keys[0];
            String slot = keys[1];
            for (AttributeModifier modifier : (Collection)entry.getValue()) {
                TrinketInventory inv;
                Map<String, TrinketInventory> groupInv = this.inventory.get(group);
                if (groupInv == null || (inv = groupInv.get(slot)) == null) continue;
                inv.addModifier(modifier);
            }
        }
    }

    @Override
    public void addPersistentModifiers(Multimap<String, AttributeModifier> modifiers) {
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            String[] keys = ((String)entry.getKey()).split("/");
            String group = keys[0];
            String slot = keys[1];
            for (AttributeModifier modifier : (Collection)entry.getValue()) {
                TrinketInventory inv;
                Map<String, TrinketInventory> groupInv = this.inventory.get(group);
                if (groupInv == null || (inv = groupInv.get(slot)) == null) continue;
                inv.addPersistentModifier(modifier);
            }
        }
    }

    @Override
    public void removeModifiers(Multimap<String, AttributeModifier> modifiers) {
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            String[] keys = ((String)entry.getKey()).split("/");
            String group = keys[0];
            String slot = keys[1];
            for (AttributeModifier modifier : (Collection)entry.getValue()) {
                TrinketInventory inv;
                Map<String, TrinketInventory> groupInv = this.inventory.get(group);
                if (groupInv == null || (inv = groupInv.get(slot)) == null) continue;
                inv.removeModifier(modifier.m_22209_());
            }
        }
    }

    @Override
    public Multimap<String, AttributeModifier> getModifiers() {
        HashMultimap result = HashMultimap.create();
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
                result.putAll((Object)(group.getKey() + "/" + slotType.getKey()), slotType.getValue().getModifiers().values());
            }
        }
        return result;
    }

    @Override
    public void clearModifiers() {
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
                slotType.getValue().clearModifiers();
            }
        }
    }

    public void readFromNbt(CompoundTag tag) {
        NonNullList dropped = NonNullList.m_122779_();
        for (String groupKey : tag.m_128431_()) {
            ListTag list;
            CompoundTag slotTag;
            CompoundTag groupTag = tag.m_128469_(groupKey);
            if (groupTag == null) continue;
            Map<String, TrinketInventory> groupSlots = this.inventory.get(groupKey);
            if (groupSlots != null) {
                for (String slotKey : groupTag.m_128431_()) {
                    slotTag = groupTag.m_128469_(slotKey);
                    list = slotTag.m_128437_("Items", 10);
                    TrinketInventory inv = groupSlots.get(slotKey);
                    if (inv != null) {
                        inv.fromTag(slotTag.m_128469_("Metadata"));
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        CompoundTag c = list.m_128728_(i);
                        ItemStack stack = ItemStack.m_41712_((CompoundTag)c);
                        if (inv != null && i < inv.m_6643_()) {
                            inv.m_6836_(i, stack);
                            continue;
                        }
                        dropped.add((Object)stack);
                    }
                }
                continue;
            }
            for (String slotKey : groupTag.m_128431_()) {
                slotTag = groupTag.m_128469_(slotKey);
                list = slotTag.m_128437_("Items", 10);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag c = list.m_128728_(i);
                    dropped.add((Object)ItemStack.m_41712_((CompoundTag)c));
                }
            }
        }
        for (ItemStack itemStack : dropped) {
            this.entity.m_19983_(itemStack);
        }
        HashMultimap slotMap = HashMultimap.create();
        this.forEach((arg_0, arg_1) -> this.lambda$readFromNbt$2((Multimap)slotMap, arg_0, arg_1));
        for (Map.Entry<String, Map<String, TrinketInventory>> groupEntry : this.getInventory().entrySet()) {
            for (Map.Entry<String, TrinketInventory> slotEntry : groupEntry.getValue().entrySet()) {
                String group = groupEntry.getKey();
                String slot = slotEntry.getKey();
                String key = group + "/" + slot;
                Collection modifiers = slotMap.get((Object)key);
                TrinketInventory inventory = slotEntry.getValue();
                for (AttributeModifier modifier : modifiers) {
                    inventory.removeCachedModifier(modifier);
                }
                inventory.clearCachedModifiers();
            }
        }
    }

    public void applySyncPacket(FriendlyByteBuf buf) {
        CompoundTag tag = buf.m_130260_();
        if (tag != null) {
            for (String groupKey : tag.m_128431_()) {
                Map<String, TrinketInventory> groupSlots;
                CompoundTag groupTag = tag.m_128469_(groupKey);
                if (groupTag == null || (groupSlots = this.inventory.get(groupKey)) == null) continue;
                for (String slotKey : groupTag.m_128431_()) {
                    CompoundTag slotTag = groupTag.m_128469_(slotKey);
                    ListTag list = slotTag.m_128437_("Items", 10);
                    TrinketInventory inv = groupSlots.get(slotKey);
                    if (inv != null) {
                        inv.applySyncTag(slotTag.m_128469_("Metadata"));
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        CompoundTag c = list.m_128728_(i);
                        ItemStack stack = ItemStack.m_41712_((CompoundTag)c);
                        if (inv == null || i >= inv.m_6643_()) continue;
                        inv.m_6836_(i, stack);
                    }
                }
            }
            LivingEntity livingEntity = this.entity;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                ((TrinketPlayerScreenHandler)player.f_36095_).trinkets$updateTrinketSlots(false);
            }
        }
    }

    public void writeToNbt(CompoundTag tag) {
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            CompoundTag groupTag = new CompoundTag();
            for (Map.Entry<String, TrinketInventory> slot : group.getValue().entrySet()) {
                CompoundTag slotTag = new CompoundTag();
                ListTag list = new ListTag();
                TrinketInventory inv = slot.getValue();
                for (int i = 0; i < inv.m_6643_(); ++i) {
                    CompoundTag c = inv.m_8020_(i).m_41739_(new CompoundTag());
                    list.add((Object)c);
                }
                slotTag.m_128365_("Metadata", (Tag)(this.syncing ? inv.getSyncTag() : inv.toTag()));
                slotTag.m_128365_("Items", (Tag)list);
                groupTag.m_128365_(slot.getKey(), (Tag)slotTag);
            }
            tag.m_128365_(group.getKey(), (Tag)groupTag);
        }
    }

    public void writeSyncPacket(FriendlyByteBuf buf, ServerPlayer recipient) {
        this.syncing = true;
        CompoundTag tag = new CompoundTag();
        this.writeToNbt(tag);
        this.syncing = false;
        buf.m_130079_(tag);
    }

    @Override
    public boolean isEquipped(Predicate<ItemStack> predicate) {
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
                TrinketInventory inv = slotType.getValue();
                for (int i = 0; i < inv.m_6643_(); ++i) {
                    if (!predicate.test(inv.m_8020_(i))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public List<Tuple<SlotReference, ItemStack>> getEquipped(Predicate<ItemStack> predicate) {
        ArrayList<Tuple<SlotReference, ItemStack>> list = new ArrayList<Tuple<SlotReference, ItemStack>>();
        this.forEach((slotReference, itemStack) -> {
            if (predicate.test((ItemStack)itemStack)) {
                list.add(new Tuple(slotReference, itemStack));
            }
        });
        return list;
    }

    @Override
    public void forEach(BiConsumer<SlotReference, ItemStack> consumer) {
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            for (Map.Entry<String, TrinketInventory> slotType : group.getValue().entrySet()) {
                TrinketInventory inv = slotType.getValue();
                for (int i = 0; i < inv.m_6643_(); ++i) {
                    consumer.accept(new SlotReference(inv, i), inv.m_8020_(i));
                }
            }
        }
    }

    private /* synthetic */ void lambda$readFromNbt$2(Multimap slotMap, SlotReference ref, ItemStack stack) {
        if (!stack.m_41619_()) {
            UUID uuid = SlotAttributes.getUuid(ref);
            Trinket trinket = TrinketsApi.getTrinket(stack.m_41720_());
            Multimap<Attribute, AttributeModifier> map = trinket.getModifiers(stack, ref, this.entity, uuid);
            for (Attribute entityAttribute : map.keySet()) {
                if (!(entityAttribute instanceof SlotAttributes.SlotEntityAttribute)) continue;
                SlotAttributes.SlotEntityAttribute slotEntityAttribute = (SlotAttributes.SlotEntityAttribute)entityAttribute;
                slotMap.putAll((Object)slotEntityAttribute.slot, (Iterable)map.get((Object)entityAttribute));
            }
        }
    }
}

