/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.emi.trinkets.api.LivingEntityTrinketComponent;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.data.EntitySlotLoader;
import dev.emi.trinkets.data.SlotLoader;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentInitializer;
import dev.onyxstudios.cca.api.v3.entity.RespawnCopyStrategy;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrinketsMain
implements ModInitializer,
EntityComponentInitializer {
    public static final String MOD_ID = "trinkets";
    public static final Logger LOGGER = LogManager.getLogger();

    public void onInitialize() {
        ResourceManagerHelper resourceManagerHelper = ResourceManagerHelper.get((PackType)PackType.SERVER_DATA);
        resourceManagerHelper.registerReloadListener((IdentifiableResourceReloadListener)SlotLoader.INSTANCE);
        resourceManagerHelper.registerReloadListener((IdentifiableResourceReloadListener)EntitySlotLoader.SERVER);
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, serverResourceManager, success) -> EntitySlotLoader.SERVER.sync(server.m_6846_().m_11314_()));
        CommandRegistrationCallback.EVENT.register((dispatcher, registry, env) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)MOD_ID).requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"group", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"slot", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"offset", (ArgumentType)IntegerArgumentType.integer((int)0)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"stack", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)registry)).executes(context -> {
            try {
                return TrinketsMain.trinketsCommand((CommandContext<CommandSourceStack>)context, 1);
            }
            catch (Exception e) {
                e.printStackTrace();
                return -1;
            }
        })).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            int amount = (Integer)context.getArgument("amount", Integer.class);
            return TrinketsMain.trinketsCommand((CommandContext<CommandSourceStack>)context, amount);
        })))))))));
    }

    private static int trinketsCommand(CommandContext<CommandSourceStack> context, int amount) {
        try {
            String group = (String)context.getArgument("group", String.class);
            String slot = (String)context.getArgument("slot", String.class);
            int offset = (Integer)context.getArgument("offset", Integer.class);
            ItemInput stack = (ItemInput)context.getArgument("stack", ItemInput.class);
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            if (player != null) {
                TrinketComponent comp = TrinketsApi.getTrinketComponent((LivingEntity)player).get();
                SlotGroup slotGroup = comp.getGroups().getOrDefault(group, null);
                if (slotGroup != null) {
                    SlotType slotType = slotGroup.getSlots().getOrDefault(slot, null);
                    if (slotType != null) {
                        if (offset >= 0 && offset < slotType.getAmount()) {
                            comp.getInventory().get(group).get(slot).m_6836_(offset, stack.m_120980_(amount, true));
                            return 1;
                        }
                        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(offset + " offset does not exist for slot")));
                    } else {
                        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(slot + " does not exist")));
                    }
                } else {
                    ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(group + " does not exist")));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -1;
    }

    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        registry.registerFor(LivingEntity.class, TrinketsApi.TRINKET_COMPONENT, LivingEntityTrinketComponent::new);
        registry.registerForPlayers(TrinketsApi.TRINKET_COMPONENT, LivingEntityTrinketComponent::new, RespawnCopyStrategy.ALWAYS_COPY);
    }
}

