/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets;

import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.TrinketScreen;
import dev.emi.trinkets.TrinketScreenManager;
import dev.emi.trinkets.TrinketsNetwork;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.data.EntitySlotLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class TrinketsClient
implements ClientModInitializer {
    public static SlotGroup activeGroup;
    public static SlotType activeType;
    public static SlotGroup quickMoveGroup;
    public static SlotType quickMoveType;
    public static int quickMoveTimer;

    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)TrinketsNetwork.SYNC_INVENTORY, (client, handler, buf, responseSender) -> {
            int entityId = buf.readInt();
            CompoundTag inventoryData = buf.m_130260_();
            CompoundTag contentData = buf.m_130260_();
            ArrayList<Tuple> contentUpdates = new ArrayList<Tuple>();
            ArrayList<ImmutableTriple> inventoryUpdates = new ArrayList<ImmutableTriple>();
            if (inventoryData != null) {
                for (String key : inventoryData.m_128431_()) {
                    String[] split = key.split("/");
                    String group = split[0];
                    String slot = split[1];
                    CompoundTag tag = inventoryData.m_128469_(key);
                    inventoryUpdates.add(new ImmutableTriple((Object)group, (Object)slot, (Object)tag));
                }
            }
            if (contentData != null) {
                for (String key : contentData.m_128431_()) {
                    ItemStack stack = ItemStack.m_41712_((CompoundTag)contentData.m_128469_(key));
                    contentUpdates.add(new Tuple((Object)key, (Object)stack));
                }
            }
            client.execute(() -> {
                Entity entity = client.f_91073_.m_6815_(entityId);
                if (entity instanceof LivingEntity) {
                    TrinketsApi.getTrinketComponent((LivingEntity)entity).ifPresent(trinkets -> {
                        InventoryMenu patt3086$temp;
                        for (Triple entry : inventoryUpdates) {
                            TrinketInventory inv;
                            Map<String, TrinketInventory> slots = trinkets.getInventory().get(entry.getLeft());
                            if (slots == null || (inv = slots.get(entry.getMiddle())) == null) continue;
                            inv.applySyncTag((CompoundTag)entry.getRight());
                        }
                        if (entity instanceof Player && (patt3086$temp = ((Player)entity).f_36095_) instanceof TrinketPlayerScreenHandler) {
                            TrinketPlayerScreenHandler screenHandler = (TrinketPlayerScreenHandler)patt3086$temp;
                            screenHandler.trinkets$updateTrinketSlots(false);
                            if (TrinketScreenManager.currentScreen != null) {
                                TrinketScreenManager.currentScreen.trinkets$updateTrinketSlots();
                            }
                        }
                        for (Triple entry : contentUpdates) {
                            TrinketInventory inv;
                            String[] split = ((String)entry.m_14418_()).split("/");
                            String group = split[0];
                            String slot = split[1];
                            int index = Integer.parseInt(split[2]);
                            Map<String, TrinketInventory> slots = trinkets.getInventory().get(group);
                            if (slots == null || (inv = slots.get(slot)) == null || index >= inv.m_6643_()) continue;
                            inv.m_6836_(index, (ItemStack)entry.m_14419_());
                        }
                    });
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)TrinketsNetwork.SYNC_SLOTS, (client, handler, buf, responseSender) -> {
            CompoundTag data = buf.m_130260_();
            if (data != null) {
                HashMap slots = new HashMap();
                for (String id : data.m_128431_()) {
                    Optional maybeType = BuiltInRegistries.f_256780_.m_6612_(ResourceLocation.m_135820_((String)id));
                    maybeType.ifPresent(type -> {
                        CompoundTag groups = data.m_128469_(id);
                        if (groups != null) {
                            for (String groupId : groups.m_128431_()) {
                                CompoundTag group = groups.m_128469_(groupId);
                                if (group == null) continue;
                                SlotGroup slotGroup = SlotGroup.read(group);
                                slots.computeIfAbsent(type, k -> new HashMap()).put(groupId, slotGroup);
                            }
                        }
                    });
                }
                client.execute(() -> {
                    EntitySlotLoader.CLIENT.setSlots(slots);
                    LocalPlayer player = client.f_91074_;
                    if (player != null) {
                        ((TrinketPlayerScreenHandler)player.f_36095_).trinkets$updateTrinketSlots(true);
                        Screen patt4983$temp = client.f_91080_;
                        if (patt4983$temp instanceof TrinketScreen) {
                            TrinketScreen trinketScreen = (TrinketScreen)patt4983$temp;
                            trinketScreen.trinkets$updateTrinketSlots();
                        }
                        for (AbstractClientPlayer clientWorldPlayer : player.f_108545_.m_6907_()) {
                            ((TrinketPlayerScreenHandler)clientWorldPlayer.f_36095_).trinkets$updateTrinketSlots(true);
                        }
                    }
                });
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)TrinketsNetwork.BREAK, (client, handler, buf, sender) -> {
            int entityId = buf.readInt();
            String[] split = buf.m_130277_().split("/");
            String group = split[0];
            String slot = split[1];
            int index = buf.readInt();
            client.execute(() -> {
                Entity e = client.f_91073_.m_6815_(entityId);
                if (e instanceof LivingEntity) {
                    LivingEntity entity = (LivingEntity)e;
                    TrinketsApi.getTrinketComponent(entity).ifPresent(comp -> {
                        TrinketInventory inv;
                        Map<String, TrinketInventory> groupMap = comp.getInventory().get(group);
                        if (groupMap != null && index < (inv = groupMap.get(slot)).m_6643_()) {
                            ItemStack stack = inv.m_8020_(index);
                            SlotReference ref = new SlotReference(inv, index);
                            Trinket trinket = TrinketsApi.getTrinket(stack.m_41720_());
                            trinket.onBreak(stack, ref, entity);
                        }
                    });
                }
            });
        });
    }
}

