/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets;

import dev.emi.trinkets.TrinketSlot;
import dev.emi.trinkets.TrinketsClient;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SurvivalTrinketSlot
extends Slot
implements TrinketSlot {
    private final SlotGroup group;
    private final SlotType type;
    private final boolean alwaysVisible;
    private final int slotOffset;
    private final TrinketInventory trinketInventory;

    public SurvivalTrinketSlot(TrinketInventory inventory, int index, int x, int y, SlotGroup group, SlotType type, int slotOffset, boolean alwaysVisible) {
        super((Container)inventory, index, x, y);
        this.group = group;
        this.type = type;
        this.slotOffset = slotOffset;
        this.alwaysVisible = alwaysVisible;
        this.trinketInventory = inventory;
    }

    public boolean m_5857_(ItemStack stack) {
        return TrinketSlot.canInsert(stack, new SlotReference(this.trinketInventory, this.slotOffset), this.trinketInventory.getComponent().getEntity());
    }

    public boolean m_8010_(Player player) {
        ItemStack stack = this.m_7993_();
        return TrinketsApi.getTrinket(stack.m_41720_()).canUnequip(stack, new SlotReference(this.trinketInventory, this.slotOffset), (LivingEntity)player);
    }

    public boolean m_6659_() {
        if (this.alwaysVisible) {
            if (this.f_40220_ < 0 && this.trinketInventory.getComponent().getEntity().m_9236_().f_46443_) {
                InventoryScreen screen;
                Minecraft client = Minecraft.m_91087_();
                Screen s = client.f_91080_;
                if (s instanceof InventoryScreen && (screen = (InventoryScreen)s).m_5564_().m_100385_()) {
                    return false;
                }
            }
            return true;
        }
        return this.isTrinketFocused();
    }

    @Override
    public boolean isTrinketFocused() {
        if (TrinketsClient.activeGroup == this.group) {
            return this.slotOffset == 0 || TrinketsClient.activeType == this.type;
        }
        if (TrinketsClient.quickMoveGroup == this.group) {
            return this.slotOffset == 0 || TrinketsClient.quickMoveType == this.type && TrinketsClient.quickMoveTimer > 0;
        }
        return false;
    }

    @Override
    public ResourceLocation getBackgroundIdentifier() {
        return this.type.getIcon();
    }

    @Override
    public SlotType getType() {
        return this.type;
    }
}

