/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.spellbinding;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.spell_engine.api.item.trinket.SpellBookItem;
import net.spell_engine.api.item.trinket.SpellBooks;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.api.spell.SpellPool;
import net.spell_engine.internals.SpellContainerHelper;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.spellbinding.SpellBinding;
import net.spell_engine.spellbinding.SpellBindingBlock;
import net.spell_engine.spellbinding.SpellBindingCriteria;
import net.spell_engine.spellbinding.SpellBookCreationCriteria;

public class SpellBindingScreenHandler
extends AbstractContainerMenu {
    public static final MenuType<SpellBindingScreenHandler> HANDLER_TYPE = new MenuType(SpellBindingScreenHandler::new, FeatureFlags.f_244377_);
    public static final int MAXIMUM_SPELL_COUNT = 32;
    private final Container inventory = new SimpleContainer(2){

        public void m_6596_() {
            super.m_6596_();
            SpellBindingScreenHandler.this.m_6199_((Container)this);
        }
    };
    private final ContainerLevelAccess context;
    public final int[] mode = new int[]{SpellBinding.Mode.SPELL.ordinal()};
    public final int[] spellId = new int[32];
    public final int[] spellCost = new int[32];
    public final int[] spellLevelRequirement = new int[32];
    public final int[] spellPoweredByLib = new int[32];
    public static ResourceLocation soundId = new ResourceLocation("spell_engine", "bind_spell");
    public static SoundEvent soundEvent = SoundEvent.m_262824_((ResourceLocation)soundId);

    public SpellBindingScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public SpellBindingScreenHandler(int syncId, Inventory playerInventory, ContainerLevelAccess context) {
        super(HANDLER_TYPE, syncId);
        int i;
        this.context = context;
        this.m_38897_(new Slot(this.inventory, 0, 15, 47){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() == Items.f_42517_ || SpellContainerHelper.hasBindableContainer(stack);
            }

            public int m_6641_() {
                return 1;
            }
        });
        this.m_38897_(new Slot(this.inventory, 1, 35, 47){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_150930_(Items.f_42534_);
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
        for (i = 0; i < 32; ++i) {
            this.m_38895_(DataSlot.m_39406_((int[])this.spellId, (int)i));
            this.m_38895_(DataSlot.m_39406_((int[])this.spellCost, (int)i));
            this.m_38895_(DataSlot.m_39406_((int[])this.spellLevelRequirement, (int)i));
            this.m_38895_(DataSlot.m_39406_((int[])this.spellPoweredByLib, (int)i));
        }
        this.m_38895_(DataSlot.m_39406_((int[])this.mode, (int)0));
        Player player = playerInventory.f_35978_;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SpellBindingCriteria.INSTANCE.trigger(serverPlayer, SpellBinding.ADVANCEMENT_VISIT_ID, true);
        }
    }

    public int getLapisCount() {
        ItemStack itemStack = this.inventory.m_8020_(1);
        if (itemStack.m_41619_()) {
            return 0;
        }
        return itemStack.m_41613_();
    }

    public void m_6199_(Container inventory) {
        if (inventory != this.inventory) {
            return;
        }
        ItemStack itemStack = inventory.m_8020_(0);
        if (itemStack.m_41619_() || !SpellContainerHelper.hasValidContainer(itemStack) && itemStack.m_41720_() != Items.f_42517_) {
            this.mode[0] = SpellBinding.Mode.SPELL.ordinal();
            for (int i = 0; i < 32; ++i) {
                this.spellId[i] = 0;
                this.spellCost[i] = 0;
                this.spellLevelRequirement[i] = 0;
                this.spellPoweredByLib[i] = 0;
            }
        } else {
            this.context.m_39292_((world, pos) -> {
                int libraryPower = 0;
                for (BlockPos blockPos : EnchantmentTableBlock.f_207902_) {
                    if (!EnchantmentTableBlock.m_207909_((Level)world, (BlockPos)pos, (BlockPos)blockPos)) continue;
                    ++libraryPower;
                }
                SpellBinding.OfferResult offerResult = SpellBinding.offersFor(itemStack, libraryPower);
                this.mode[0] = offerResult.mode().ordinal();
                List<SpellBinding.Offer> offers = offerResult.offers();
                for (int i = 0; i < 32; ++i) {
                    if (i < offers.size()) {
                        SpellBinding.Offer offer = offers.get(i);
                        this.spellId[i] = offer.id();
                        this.spellCost[i] = offer.cost();
                        this.spellLevelRequirement[i] = offer.levelRequirement();
                        this.spellPoweredByLib[i] = offer.isPowered() ? 1 : 0;
                        continue;
                    }
                    this.spellId[i] = 0;
                    this.spellCost[i] = 0;
                    this.spellLevelRequirement[i] = 0;
                    this.spellPoweredByLib[i] = 0;
                }
                this.m_38946_();
            });
        }
    }

    public boolean m_6875_(Player player) {
        return EnchantmentMenu.m_38889_((ContainerLevelAccess)this.context, (Player)player, (Block)SpellBindingBlock.INSTANCE);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.context.m_39292_((world, pos) -> this.m_150411_(player, this.inventory));
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemStack2 = slot.m_7993_();
            itemStack = itemStack2.m_41777_();
            if (index == 0) {
                if (!this.m_38903_(itemStack2, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (index == 1) {
                if (!this.m_38903_(itemStack2, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (itemStack2.m_150930_(Items.f_42534_)) {
                if (!this.m_38903_(itemStack2, 1, 2, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (!((Slot)this.f_38839_.get(0)).m_6657_() && ((Slot)this.f_38839_.get(0)).m_5857_(itemStack2)) {
                ItemStack itemStack3 = itemStack2.m_41777_();
                itemStack3.m_41764_(1);
                itemStack2.m_41774_(1);
                ((Slot)this.f_38839_.get(0)).m_269060_(itemStack3);
            } else {
                return ItemStack.f_41583_;
            }
            if (itemStack2.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemStack2.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemStack2);
        }
        return itemStack;
    }

    public boolean m_6366_(Player player, int id) {
        try {
            SpellBinding.Mode mode = SpellBinding.Mode.values()[this.mode[0]];
            int rawId = this.spellId[id];
            int cost = this.spellCost[id];
            int requiredLevel = this.spellLevelRequirement[id];
            int poweredByLib = this.spellPoweredByLib[id];
            int lapisCount = this.getLapisCount();
            ItemStack weaponStack = (ItemStack)this.m_38927_().get(0);
            ItemStack lapisStack = (ItemStack)this.m_38927_().get(1);
            if (poweredByLib == 0) {
                return false;
            }
            switch (mode) {
                case SPELL: {
                    Optional<ResourceLocation> spellIdOptional = SpellRegistry.fromRawSpellId(rawId);
                    if (spellIdOptional.isEmpty()) {
                        return false;
                    }
                    ResourceLocation spellId = spellIdOptional.get();
                    SpellBinding.State binding = SpellBinding.State.of(spellId, weaponStack, cost, requiredLevel);
                    if (binding.state == SpellBinding.State.ApplyState.INVALID) {
                        return false;
                    }
                    if (!binding.readyToApply(player, lapisCount)) {
                        return false;
                    }
                    this.context.m_39292_((world, pos) -> {
                        SpellContainerHelper.addSpell(spellId, weaponStack);
                        if (!player.m_7500_()) {
                            lapisStack.m_41774_(binding.requirements.lapisCost());
                        }
                        SpellBindingScreenHandler.applyLevelCost(player, binding.requirements.levelCost());
                        this.inventory.m_6596_();
                        this.m_6199_(this.inventory);
                        world.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            SpellContainer container = SpellContainerHelper.containerFromItemStack(weaponStack);
                            ResourceLocation poolId = SpellContainerHelper.getPoolId(container);
                            if (poolId != null) {
                                SpellPool pool = SpellContainerHelper.getPool(container);
                                boolean isComplete = container.spell_ids.size() == pool.spellIds().size();
                                SpellBindingCriteria.INSTANCE.trigger(serverPlayer, poolId, isComplete);
                                System.out.println("Triggering advancement SpellBindingCriteria.INSTANCE poolId: " + poolId + " isComplete: " + isComplete);
                            } else {
                                SpellBindingCriteria.INSTANCE.trigger(serverPlayer, null, false);
                            }
                        }
                    });
                    break;
                }
                case BOOK: {
                    SpellBookItem item = SpellBooks.sorted().get(rawId - 1);
                    ItemStack itemStack = ((Item)item).m_7968_();
                    SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
                    if (container == null || !container.isValid() || container.pool == null) {
                        return false;
                    }
                    ResourceLocation poolId = new ResourceLocation(container.pool);
                    SpellBinding.State binding = SpellBinding.State.forBook(cost, requiredLevel);
                    if (binding.state == SpellBinding.State.ApplyState.INVALID) {
                        return false;
                    }
                    if (!binding.readyToApply(player, lapisCount)) {
                        return false;
                    }
                    this.context.m_39292_((world, pos) -> {
                        ((Slot)this.f_38839_.get(0)).m_269060_(itemStack);
                        if (!player.m_7500_()) {
                            lapisStack.m_41774_(binding.requirements.lapisCost());
                        }
                        SpellBindingScreenHandler.applyLevelCost(player, binding.requirements.levelCost());
                        this.inventory.m_6596_();
                        this.m_6199_(this.inventory);
                        world.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            SpellBookCreationCriteria.INSTANCE.trigger(serverPlayer, poolId);
                        }
                    });
                }
            }
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private static void applyLevelCost(Player player, int levelCost) {
        player.f_36078_ -= levelCost;
        if (player.f_36078_ < 0) {
            player.f_36078_ = 0;
            player.f_36080_ = 0.0f;
            player.f_36079_ = 0;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_9174_(player.f_36078_);
        }
    }
}

