/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.spellbinding;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.spell_engine.api.item.trinket.SpellBookItem;
import net.spell_engine.api.item.trinket.SpellBooks;
import net.spell_engine.client.gui.CustomButton;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.client.util.SpellRender;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.spellbinding.SpellBinding;
import net.spell_engine.spellbinding.SpellBindingScreenHandler;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class SpellBindingScreen
extends AbstractContainerScreen<SpellBindingScreenHandler> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("spell_engine", "textures/gui/spell_binding.png");
    private ItemStack stack;
    private int pageOffset = 0;
    private Button upButton;
    private Button downButton;
    private static final int PAGE_SIZE = 3;
    private List<ButtonViewModel> buttonViewModels = List.of();
    private static final int BUTTONS_ORIGIN_X = 60;
    private static final int BUTTONS_ORIGIN_Y = 14;
    private static final ResourceLocation RUNES_FONT_ID = new ResourceLocation("minecraft", "alt");
    private static final Style RUNE_STYLE = Style.f_131099_.m_131150_(RUNES_FONT_ID);
    private static final int BUTTON_TEXTURE_U = 0;
    private static final int BUTTON_TEXTURE_V = 166;
    private static final int BUTTON_WIDTH = 108;
    private static final int BUTTON_HEIGHT = 19;
    private static final int SPELL_ICON_SIZE = 16;
    private static final int SPELL_ICON_INDENT = (int)Math.ceil(1.5);
    private static final int ORB_INDENT = 1;
    private static final int ORB_ICON_SIZE = 13;
    private static final int ORB_TEXTURE_U = 0;
    private static final int ORB_TEXTURE_V = 242;
    private static final int BOTTOM_TEXT_OFFSET = 10;
    private static final int COLOR_GOOD = 3604224;
    private static final int COLOR_BAD = 0xFC5C5C;
    private static final int COLOR_GOOD_BUT_DISABLED = 4753678;

    public SpellBindingScreen(SpellBindingScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.stack = ItemStack.f_41583_;
    }

    protected void m_7856_() {
        super.m_7856_();
        int originX = (this.f_96543_ - this.f_97726_) / 2;
        int originY = (this.f_96544_ - this.f_97727_) / 2;
        int x = originX + 156;
        int y = originY + 5;
        int width = 16;
        int height = 10;
        this.upButton = new CustomButton(x, y, CustomButton.Type.SMALL_UP, button -> this.pageUp());
        this.upButton.f_93624_ = false;
        this.downButton = new CustomButton(x, y + 57 + height + 1, CustomButton.Type.SMALL_DOWN, button -> this.pageDown());
        this.downButton.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.upButton);
        this.m_142416_((GuiEventListener)this.downButton);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        try {
            for (int i = 0; i < this.buttonViewModels.size(); ++i) {
                ButtonViewModel spellButton = this.buttonViewModels.get(i);
                if (!spellButton.mouseOver((int)mouseX, (int)mouseY)) continue;
                this.f_96541_.f_91072_.m_105208_(((SpellBindingScreenHandler)this.f_97732_).f_38840_, i);
                return true;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (!this.isPagingEnabled()) {
            return false;
        }
        int i = 0;
        while ((double)i < Math.abs(amount)) {
            if (amount > 0.0) {
                this.pageUp();
            } else {
                this.pageDown();
            }
            ++i;
        }
        return true;
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        delta = this.f_96541_.m_91296_();
        this.m_280273_(context);
        super.m_88315_(context, mouseX, mouseY, delta);
        this.m_280072_(context, mouseX, mouseY);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        int lapisCount = ((SpellBindingScreenHandler)this.f_97732_).getLapisCount();
        ItemStack itemStack = (ItemStack)((SpellBindingScreenHandler)this.f_97732_).m_38927_().get(0);
        block6: for (ButtonViewModel button : this.buttonViewModels) {
            if (button.spell == null || !button.mouseOver(mouseX, mouseY)) continue;
            ArrayList tooltip = Lists.newArrayList();
            boolean showSpellDetails = true;
            switch (button.binding.state) {
                case ALREADY_APPLIED: {
                    tooltip.add(Component.m_237115_((String)"gui.spell_engine.spell_binding.already_bound").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case NO_MORE_SLOT: {
                    tooltip.add(Component.m_237115_((String)"gui.spell_engine.spell_binding.no_more_slots").m_130940_(ChatFormatting.GRAY));
                    showSpellDetails = false;
                    break;
                }
                case APPLICABLE: {
                    if (button.binding.readyToApply((Player)player, lapisCount)) {
                        tooltip.add(Component.m_237115_((String)"gui.spell_engine.spell_binding.available").m_130940_(ChatFormatting.GREEN));
                        break;
                    }
                    if (!button.binding.requirements.metRequiredLevel((Player)player)) {
                        tooltip.add(Component.m_237110_((String)"gui.spell_engine.spell_binding.level_req_fail", (Object[])new Object[]{button.binding.requirements.requiredLevel()}).m_130940_(ChatFormatting.RED));
                        break;
                    }
                    int lapisCost = button.binding.requirements.lapisCost();
                    boolean hasEnoughLapis = button.binding.requirements.hasEnoughLapis(lapisCount);
                    MutableComponent lapis = lapisCost == 1 ? Component.m_237115_((String)"container.enchant.lapis.one") : Component.m_237110_((String)"container.enchant.lapis.many", (Object[])new Object[]{lapisCost});
                    tooltip.add(lapis.m_130940_(hasEnoughLapis ? ChatFormatting.GRAY : ChatFormatting.RED));
                    int levelCost = button.binding.requirements.levelCost();
                    boolean hasEnoughLevels = button.binding.requirements.hasEnoughLevelsToSpend((Player)player);
                    MutableComponent levels = levelCost == 1 ? Component.m_237115_((String)"container.enchant.level.one") : Component.m_237110_((String)"container.enchant.level.many", (Object[])new Object[]{levelCost});
                    tooltip.add(levels.m_130940_(hasEnoughLevels ? ChatFormatting.GRAY : ChatFormatting.RED));
                    break;
                }
                case INVALID: {
                    continue block6;
                }
            }
            if (showSpellDetails) {
                tooltip.add(Component.m_237113_((String)" "));
                tooltip.addAll(SpellTooltip.spellInfo(button.spell.id(), (Player)player, itemStack, true));
            }
            if (!button.isDetailsPublic) break;
            context.m_280666_(this.f_96547_, (List)tooltip, mouseX, mouseY);
            break;
        }
    }

    protected void m_7286_(GuiGraphics context, float delta, int mouseX, int mouseY) {
        Lighting.m_84930_();
        int originX = (this.f_96543_ - this.f_97726_) / 2;
        int originY = (this.f_96544_ - this.f_97727_) / 2;
        context.m_280218_(TEXTURE, originX, originY, 0, 0, this.f_97726_, this.f_97727_);
        Slot bindingSlot = (Slot)((SpellBindingScreenHandler)this.f_97732_).f_38839_.get(0);
        if (bindingSlot.m_7993_().m_41619_()) {
            context.m_280218_(TEXTURE, originX + bindingSlot.f_40220_, originY + bindingSlot.f_40221_, 240, 0, 16, 16);
        }
        Lighting.m_84931_();
        this.updatePageControls();
        this.updateButtons(originX, originY);
        this.drawButtons(context, mouseX, mouseY);
    }

    private boolean isPagingEnabled() {
        return this.buttonViewModels.size() > 3;
    }

    private int maximalPageOffset() {
        return this.buttonViewModels.size() - 3;
    }

    private boolean hasPageUp() {
        return this.pageOffset > 0;
    }

    private boolean hasPageDown() {
        return this.pageOffset < this.maximalPageOffset();
    }

    private void pageUp() {
        if (this.hasPageUp()) {
            --this.pageOffset;
        }
    }

    private void pageDown() {
        if (this.hasPageDown()) {
            ++this.pageOffset;
        }
    }

    private void restartPaging() {
        this.pageOffset = 0;
    }

    private void updatePageControls() {
        boolean isPaging;
        this.upButton.f_93624_ = isPaging = this.isPagingEnabled();
        this.upButton.f_93623_ = this.hasPageUp();
        this.downButton.f_93624_ = isPaging;
        this.downButton.f_93623_ = this.hasPageDown();
    }

    private void updateButtons(int originX, int originY) {
        ArrayList<ButtonViewModel> buttons = new ArrayList<ButtonViewModel>();
        ItemStack itemStack = (ItemStack)((SpellBindingScreenHandler)this.f_97732_).m_38927_().get(0);
        int lapisCount = ((SpellBindingScreenHandler)this.f_97732_).getLapisCount();
        SpellBinding.Mode mode = SpellBinding.Mode.values()[((SpellBindingScreenHandler)this.f_97732_).mode[0]];
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        try {
            block6: for (int i = 0; i < 32; ++i) {
                int rawId = ((SpellBindingScreenHandler)this.f_97732_).spellId[i];
                int cost = ((SpellBindingScreenHandler)this.f_97732_).spellCost[i];
                int requirement = ((SpellBindingScreenHandler)this.f_97732_).spellLevelRequirement[i];
                boolean powered = ((SpellBindingScreenHandler)this.f_97732_).spellPoweredByLib[i] == 1;
                boolean shown = i >= this.pageOffset && i < this.pageOffset + 3;
                switch (mode) {
                    case SPELL: {
                        Optional<ResourceLocation> spellId = SpellRegistry.fromRawSpellId(rawId);
                        if (spellId.isEmpty()) continue block6;
                        ResourceLocation id = spellId.get();
                        SpellBinding.State bindingState = SpellBinding.State.of(id, itemStack, cost, requirement);
                        boolean isDetailsPublic = powered || bindingState.state == SpellBinding.State.ApplyState.ALREADY_APPLIED;
                        boolean isEnabled = powered && bindingState.readyToApply((Player)player, lapisCount);
                        MutableComponent text = Component.m_237115_((String)SpellTooltip.spellTranslationKey(id));
                        if (!isDetailsPublic) {
                            text = text.m_130940_(ChatFormatting.OBFUSCATED).m_130948_(RUNE_STYLE);
                        }
                        SpellInfo spell = new SpellInfo(id, SpellRender.iconTexture(id), (Component)text);
                        ButtonViewModel button = new ButtonViewModel(shown, originX + 60, originY + 14 + (buttons.size() - this.pageOffset) * 19, 108, 19, isEnabled, isDetailsPublic, spell, null, bindingState);
                        buttons.add(button);
                        continue block6;
                    }
                    case BOOK: {
                        if (rawId < 1) continue block6;
                        SpellBookItem item = SpellBooks.sorted().get(rawId - 1);
                        SpellBinding.State bindingState = SpellBinding.State.forBook(cost, requirement);
                        boolean isEnabled = bindingState.readyToApply((Player)player, lapisCount);
                        ButtonViewModel button = new ButtonViewModel(shown, originX + 60, originY + 14 + (buttons.size() - this.pageOffset) * 19, 108, 19, isEnabled, true, null, (Item)item, bindingState);
                        buttons.add(button);
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error when updating Spell Binding Screen buttons");
            System.err.println(e.getMessage());
        }
        this.setButtons(buttons);
    }

    private void setButtons(List<ButtonViewModel> buttons) {
        if (buttons.size() != this.buttonViewModels.size()) {
            this.restartPaging();
        }
        this.buttonViewModels = buttons;
    }

    private void drawButtons(GuiGraphics context, int mouseX, int mouseY) {
        for (ButtonViewModel button : this.buttonViewModels) {
            ButtonState state = button.mouseOver(mouseX, mouseY) ? ButtonState.HOVER : ButtonState.NORMAL;
            this.drawSpellButton(context, button, state);
        }
    }

    private void drawSpellButton(GuiGraphics context, ButtonViewModel viewModel, ButtonState state) {
        if (!viewModel.shown) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        int u = 0;
        int v = 166;
        if (viewModel.isEnabled) {
            switch (state) {
                case NORMAL: {
                    v += 0;
                    break;
                }
                case HOVER: {
                    v += viewModel.height * 2;
                }
            }
        } else {
            v += viewModel.height;
        }
        context.m_280218_(TEXTURE, viewModel.x, viewModel.y, u, v, viewModel.width, viewModel.height);
        if (viewModel.binding.state == SpellBinding.State.ApplyState.NO_MORE_SLOT) {
            return;
        }
        if (viewModel.spell != null || viewModel.item != null) {
            int goodColor;
            boolean alreadyApplied = viewModel.binding.state == SpellBinding.State.ApplyState.ALREADY_APPLIED;
            boolean isUnlocked = alreadyApplied || viewModel.isEnabled;
            Component text = Component.m_130674_((String)"");
            if (viewModel.spell != null) {
                text = viewModel.spell.name();
            }
            if (viewModel.item != null) {
                text = viewModel.item.m_41466_();
            }
            context.m_280430_(this.f_96547_, text, viewModel.x + viewModel.height, viewModel.y + SPELL_ICON_INDENT, isUnlocked ? 0xFFFFFF : 0x808080);
            int n = goodColor = viewModel.isEnabled ? 3604224 : 4753678;
            if (!alreadyApplied) {
                String levelRequirement = "" + viewModel.binding.requirements.requiredLevel();
                context.m_280488_(this.f_96547_, levelRequirement, viewModel.x + viewModel.width - 2 - this.f_96547_.m_92895_(levelRequirement), viewModel.y + viewModel.height - 10, viewModel.binding.requirements.metRequiredLevel((Player)player) ? goodColor : 0xFC5C5C);
            }
            context.m_280246_(1.0f, 1.0f, 1.0f, isUnlocked ? 1.0f : 0.5f);
            RenderSystem.enableBlend();
            if (viewModel.spell != null && viewModel.spell.icon != null) {
                context.m_280163_(viewModel.spell.icon, viewModel.x + SPELL_ICON_INDENT, viewModel.y + SPELL_ICON_INDENT, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            if (viewModel.item != null) {
                context.m_280480_(viewModel.item.m_7968_(), viewModel.x + SPELL_ICON_INDENT, viewModel.y + SPELL_ICON_INDENT);
            }
            if (!alreadyApplied) {
                context.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
                context.m_280218_(TEXTURE, viewModel.x + 1, viewModel.y + viewModel.height - 13 - 1, 0, 242, 13, 13);
                String levelCost = "" + viewModel.binding.requirements.levelCost();
                context.m_280488_(this.f_96547_, levelCost, (int)((long)(viewModel.x + 1) + Math.round(7.8)), viewModel.y + viewModel.height - 10, viewModel.binding.requirements.hasEnoughLevelsToSpend((Player)player) ? goodColor : 0xFC5C5C);
                context.m_280168_().m_252880_(0.0f, 0.0f, -300.0f);
            }
        }
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    record ButtonViewModel(boolean shown, int x, int y, int width, int height, boolean isEnabled, boolean isDetailsPublic, @Nullable SpellInfo spell, @Nullable Item item, SpellBinding.State binding) {
        public boolean mouseOver(int mouseX, int mouseY) {
            if (!this.shown) {
                return false;
            }
            return mouseX > this.x && mouseX < this.x + this.width && mouseY > this.y && mouseY < this.y + this.height;
        }
    }

    record SpellInfo(ResourceLocation id, ResourceLocation icon, Component name) {
    }

    static enum ButtonState {
        NORMAL,
        HOVER;

    }
}

