/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.spellbinding;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.spell_engine.spellbinding.SpellBinding;

public class SpellBindingCriteria
extends SimpleCriterionTrigger<Condition> {
    public static final ResourceLocation ID = SpellBinding.ID;
    public static final SpellBindingCriteria INSTANCE = new SpellBindingCriteria();

    protected Condition conditionsFromJson(JsonObject obj, ContextAwarePredicate playerPredicate, DeserializationContext predicateDeserializer) {
        Condition condition = new Condition();
        JsonElement element = obj.get("complete");
        if (element != null) {
            condition.complete = element.getAsBoolean();
        }
        if ((element = obj.get("spell_pool")) != null) {
            condition.spellPool = new ResourceLocation(element.getAsString());
        }
        return condition;
    }

    public ResourceLocation m_7295_() {
        return SpellBinding.ID;
    }

    public void trigger(ServerPlayer player, ResourceLocation spellPoolId, boolean isComplete) {
        this.m_66234_(player, condition -> condition.test(spellPoolId, isComplete));
    }

    public static class Condition
    extends AbstractCriterionTriggerInstance {
        boolean complete = false;
        ResourceLocation spellPool = null;

        public Condition() {
            super(SpellBinding.ID, ContextAwarePredicate.f_285567_);
        }

        public boolean test(ResourceLocation usedSpellPool, boolean isComplete) {
            boolean poolMatches = true;
            if (this.spellPool != null) {
                poolMatches = this.spellPool.equals((Object)usedSpellPool);
            }
            boolean completeMatches = this.complete == isComplete;
            return poolMatches && completeMatches;
        }

        public JsonObject m_7683_(SerializationContext predicateSerializer) {
            JsonObject jsonObject = super.m_7683_(predicateSerializer);
            jsonObject.add("complete", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.complete)));
            if (this.spellPool != null) {
                jsonObject.add("spell_pool", (JsonElement)new JsonPrimitive(this.spellPool.toString()));
            }
            return jsonObject;
        }
    }
}

