/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.spellbinding;

import java.util.List;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.spell_engine.spellbinding.SpellBindingBlockEntity;
import net.spell_engine.spellbinding.SpellBindingScreenHandler;
import org.jetbrains.annotations.Nullable;

public class SpellBindingBlock
extends BaseEntityBlock {
    public static SpellBindingBlock INSTANCE = new SpellBindingBlock((BlockBehaviour.Properties)FabricBlockSettings.create().hardness(4.0f).nonOpaque());
    public static final BlockItem ITEM = new BlockItem((Block)INSTANCE, (Item.Properties)new FabricItemSettings());
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    public static final List<BlockPos> BOOKSHELF_OFFSETS = BlockPos.m_121886_((int)-2, (int)0, (int)-2, (int)2, (int)1, (int)2).filter(pos -> Math.abs(pos.m_123341_()) == 2 || Math.abs(pos.m_123343_()) == 2).map(BlockPos::m_7949_).toList();

    public SpellBindingBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public static boolean canAccessBookshelf(Level world, BlockPos tablePos, BlockPos bookshelfOffset) {
        return world.m_8055_(tablePos.m_121955_((Vec3i)bookshelfOffset)).m_60713_(Blocks.f_50078_) && world.m_46859_(tablePos.m_7918_(bookshelfOffset.m_123341_() / 2, bookshelfOffset.m_123342_(), bookshelfOffset.m_123343_() / 2));
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.m_214162_(state, world, pos, random);
        for (BlockPos blockPos : BOOKSHELF_OFFSETS) {
            if (random.m_188503_(16) != 0 || !SpellBindingBlock.canAccessBookshelf(world, pos, blockPos)) continue;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123809_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 2.0, (double)pos.m_123343_() + 0.5, (double)((float)blockPos.m_123341_() + random.m_188501_()) - 0.5, (double)((float)blockPos.m_123342_() - random.m_188501_() - 1.0f), (double)((float)blockPos.m_123343_() + random.m_188501_()) - 0.5);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SpellBindingBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return world.f_46443_ ? SpellBindingBlock.m_152132_(type, SpellBindingBlockEntity.ENTITY_TYPE, SpellBindingBlockEntity::tick) : null;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        player.m_5893_(state.m_60750_(world, pos));
        return InteractionResult.CONSUME;
    }

    @Nullable
    public MenuProvider m_7246_(BlockState state, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof SpellBindingBlockEntity) {
            MutableComponent text = Component.m_237115_((String)"gui.spell_engine.spell_binding.title");
            return new SimpleMenuProvider((syncId, inventory, player) -> new SpellBindingScreenHandler(syncId, inventory, ContainerLevelAccess.m_39289_((Level)world, (BlockPos)pos)), (Component)text);
        }
        return null;
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag options) {
        super.m_5871_(stack, world, tooltip, options);
        tooltip.add((Component)Component.m_237115_((String)"block.spell_engine.spell_binding.description").m_130940_(ChatFormatting.GRAY));
    }
}

