/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.entity;

import com.google.gson.Gson;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.player.Player;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.client.animation.AnimatablePlayer;
import net.spell_engine.internals.SpellCastSyncHelper;
import net.spell_engine.internals.SpellCooldownManager;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public class PlayerEntityMixin
implements SpellCasterEntity {
    private final SpellCooldownManager spellCooldownManager = new SpellCooldownManager(this.player());
    private static final EntityDataAccessor<String> SPELL_ENGINE_SPELL_PROGRESS = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final Gson syncGson = new Gson();
    private SpellCast.Process synchronizedSpellCastProcess = null;
    private String lastHandledSyncData = "";

    private Player player() {
        return (Player)this;
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    private void initDataTracker_TAIL_SpellEngine_SyncEffects(CallbackInfo ci) {
        this.player().m_20088_().m_135372_(SPELL_ENGINE_SPELL_PROGRESS, (Object)"");
    }

    @Override
    public void setSpellCastProcess(@Nullable SpellCast.Process process) {
        this.synchronizedSpellCastProcess = process;
        String json = process != null ? process.fastSyncJSON() : "";
        this.player().m_20088_().m_135381_(SPELL_ENGINE_SPELL_PROGRESS, (Object)json);
    }

    @Override
    @Nullable
    public SpellCast.Process getSpellCastProcess() {
        return this.synchronizedSpellCastProcess;
    }

    @Override
    public Spell getCurrentSpell() {
        SpellCast.Process process = this.getSpellCastProcess();
        if (process != null) {
            return process.spell();
        }
        return null;
    }

    @Override
    public float getCurrentCastingSpeed() {
        SpellCast.Process process = this.getSpellCastProcess();
        if (process != null) {
            return process.speed();
        }
        return 1.0f;
    }

    @Override
    public SpellCooldownManager getCooldownManager() {
        return this.spellCooldownManager;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick_TAIL_SpellEngine(CallbackInfo ci) {
        int castTicks;
        Player player = this.player();
        if (player.m_9236_().f_46443_) {
            ((AnimatablePlayer)this.player()).updateSpellCastAnimationsOnTick();
            String progressString = (String)player.m_20088_().m_135370_(SPELL_ENGINE_SPELL_PROGRESS);
            if (!progressString.equals(this.lastHandledSyncData)) {
                if (progressString.isEmpty()) {
                    this.synchronizedSpellCastProcess = null;
                } else {
                    SpellCast.Process.SyncFormat syncFormat = (SpellCast.Process.SyncFormat)syncGson.fromJson(progressString, SpellCast.Process.SyncFormat.class);
                    this.synchronizedSpellCastProcess = SpellCast.Process.fromSync(syncFormat, player.m_21205_().m_41720_(), player.m_9236_().m_46467_());
                }
                this.lastHandledSyncData = progressString;
            }
        } else if (this.synchronizedSpellCastProcess != null && (double)(castTicks = this.synchronizedSpellCastProcess.spellCastTicksSoFar(player.m_9236_().m_46467_())) >= (double)this.synchronizedSpellCastProcess.length() * 1.5) {
            SpellCastSyncHelper.clearCasting(player);
        }
        this.spellCooldownManager.update();
    }

    @Override
    public boolean isBeaming() {
        return this.getBeam() != null;
    }

    @Override
    @Nullable
    public Spell.Release.Target.Beam getBeam() {
        Spell spell = this.getCurrentSpell();
        if (spell != null && spell.release != null && spell.release.target.type == Spell.Release.Target.Type.BEAM) {
            return spell.release.target.beam;
        }
        return null;
    }
}

