/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.effect;

import java.util.Map;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.spell_engine.api.effect.HealthImpacting;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityStatusHealthImpacting {
    @Shadow
    @Final
    private Map<MobEffect, MobEffectInstance> f_20945_;
    private float healingTakenModifier_SpellEngine = 1.0f;
    private float damageTakenModifier_SpellEngine = 1.0f;

    @Inject(method={"updatePotionVisibility"}, at={@At(value="HEAD")})
    private void updatePotionVisibility_HEAD_SpellEngine_UpdateHealingTaken(CallbackInfo ci) {
        float healingNewValue = 1.0f;
        float damageNewValue = 1.0f;
        for (Map.Entry<MobEffect, MobEffectInstance> entry : this.f_20945_.entrySet()) {
            MobEffect effect = entry.getKey();
            MobEffectInstance instance = entry.getValue();
            int stacks = instance.m_19564_() + 1;
            healingNewValue += ((HealthImpacting)effect).getHealingTakenModifierPerStack() * (float)stacks;
            damageNewValue += ((HealthImpacting)effect).getDamageTakenModifierPerStack() * (float)stacks;
        }
        this.healingTakenModifier_SpellEngine = healingNewValue;
        this.damageTakenModifier_SpellEngine = damageNewValue;
    }

    @ModifyVariable(method={"heal"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private float modifyHealingTaken_SpellEngine(float amount) {
        return amount * this.healingTakenModifier_SpellEngine;
    }

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    public float modifyDamageTaken_SpellEngine(float amount) {
        return amount * this.damageTakenModifier_SpellEngine;
    }
}

