/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.api.effect.CustomModelStatusEffect;
import net.spell_engine.api.effect.Synchronized;
import net.spell_engine.api.render.CustomLayers;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.client.beam.BeamEmitterEntity;
import net.spell_engine.client.render.BeamRenderer;
import net.spell_engine.internals.Beam;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.utils.TargetHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class})
public class LivingEntityRendererMixin {
    private static final RenderType spellObjectsLayer = CustomLayers.projectile(TextureAtlas.f_118259_, false);

    @Inject(method={"render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="TAIL")})
    private void render_TAIL_SpellEngine(LivingEntity livingEntity, float f, float delta, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, CallbackInfo ci) {
        boolean isRenderingClientPlayerInFirstPerson;
        float launchHeight = SpellHelper.launchHeight(livingEntity);
        Vec3 offset = new Vec3(0.0, (double)launchHeight, (double)SpellHelper.launchPointOffsetDefault);
        if (livingEntity instanceof SpellCasterEntity) {
            SpellCasterEntity caster = (SpellCasterEntity)livingEntity;
            Spell.Release.Target.Beam beamAppearance = caster.getBeam();
            if (beamAppearance != null) {
                Vec3 from = livingEntity.m_20182_().m_82520_(0.0, (double)launchHeight, 0.0);
                Vec3 lookVector = Vec3.f_82478_;
                if (livingEntity == Minecraft.m_91087_().f_91074_) {
                    lookVector = Vec3.m_82498_((float)livingEntity.m_146909_(), (float)livingEntity.m_146908_());
                } else {
                    lookVector = Vec3.m_82498_((float)livingEntity.f_19860_, (float)livingEntity.f_19859_);
                    lookVector = lookVector.m_165921_(Vec3.m_82498_((float)livingEntity.m_146909_(), (float)livingEntity.m_146908_()), (double)delta);
                }
                lookVector = lookVector.m_82541_();
                Beam.Position beamPosition = TargetHelper.castBeam(livingEntity, lookVector, 32.0f);
                lookVector = lookVector.m_82490_((double)beamPosition.length());
                Vec3 to = from.m_82549_(lookVector);
                LivingEntityRendererMixin.renderBeam(matrixStack, vertexConsumerProvider, beamAppearance, from, to, offset, livingEntity.m_9236_().m_46467_(), delta);
                ((BeamEmitterEntity)livingEntity).setLastRenderedBeam(new Beam.Rendered(beamPosition, beamAppearance));
            } else {
                ((BeamEmitterEntity)livingEntity).setLastRenderedBeam(null);
            }
        }
        Minecraft client = Minecraft.m_91087_();
        boolean bl = isRenderingClientPlayerInFirstPerson = livingEntity == client.f_91074_ && !client.f_91063_.m_109153_().m_90594_();
        if (!isRenderingClientPlayerInFirstPerson) {
            for (Synchronized.Effect entry : Synchronized.effectsOf(livingEntity)) {
                MobEffect effect = entry.effect();
                int amplifier = entry.amplifier();
                CustomModelStatusEffect.Renderer renderer = CustomModelStatusEffect.rendererOf(effect);
                if (renderer == null) continue;
                renderer.renderEffect(amplifier, livingEntity, delta, matrixStack, vertexConsumerProvider, light);
            }
        }
    }

    private static void renderBeam(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, Spell.Release.Target.Beam beam, Vec3 from, Vec3 to, Vec3 offset, long time, float tickDelta) {
        float absoluteTime = (float)Math.floorMod(time, 40) + tickDelta;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, offset.f_82480_, 0.0);
        Vec3 beamVector = to.m_82546_(from);
        float length = (float)beamVector.m_82553_();
        beamVector = beamVector.m_82541_();
        float n = (float)Math.acos(beamVector.f_82480_);
        float o = (float)Math.atan2(beamVector.f_82481_, beamVector.f_82479_);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - o) * 57.295776f));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(n * 57.295776f));
        matrixStack.m_85837_(0.0, offset.f_82481_, 0.0);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(absoluteTime * 2.25f - 45.0f));
        ResourceLocation texture = new ResourceLocation(beam.texture_id);
        long color = beam.color_rgba;
        long red = color >> 24 & 0xFFL;
        long green = color >> 16 & 0xFFL;
        long blue = color >> 8 & 0xFFL;
        long alpha = color & 0xFFL;
        BeamRenderer.renderBeam(matrixStack, vertexConsumerProvider, texture, time, tickDelta, beam.flow, true, (int)red, (int)green, (int)blue, (int)alpha, 0.0f, length, beam.width);
        matrixStack.m_85849_();
    }
}

