/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.client.control;

import com.llamalad7.mixinextras.injector.WrapWithCondition;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.input.AutoSwapHelper;
import net.spell_engine.client.input.Keybindings;
import net.spell_engine.client.input.SpellHotbar;
import net.spell_engine.client.input.WrappedKeybinding;
import net.spell_engine.internals.casting.SpellCasterClient;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class}, priority=999)
public abstract class SpellHotbarMinecraftClient {
    @Shadow
    @Nullable
    public LocalPlayer f_91074_;
    @Shadow
    @Final
    public Options f_91066_;
    @Shadow
    private int f_91011_;
    @Shadow
    public int f_91078_;
    @Shadow
    @Nullable
    public Screen f_91080_;
    @Nullable
    private WrappedKeybinding.Category spellHotbarHandle = null;
    private Map<KeyMapping, Boolean> conflictingPressState = new HashMap<KeyMapping, Boolean>();

    @Shadow
    @Nullable
    public abstract ClientPacketListener m_91403_();

    @Inject(method={"handleInputEvents"}, at={@At(value="HEAD")})
    private void handleInputEvents_HEAD_SpellHotbar(CallbackInfo ci) {
        this.spellHotbarHandle = null;
        if (this.f_91074_ == null || this.f_91066_ == null) {
            return;
        }
        boolean hotbarUpdated = SpellHotbar.INSTANCE.update(this.f_91074_, this.f_91066_);
        if (hotbarUpdated) {
            this.f_91011_ = 5;
        }
        SpellHotbar.INSTANCE.prepare(this.f_91011_);
        SpellHotbar.Handle handled = SpellEngineClient.config.useKeyHighPriority || ((SpellCasterClient)this.f_91074_).isCastingSpell() || this.f_91074_.m_6117_() && SpellHotbar.INSTANCE.lastHandledWasItemBypass() ? SpellHotbar.INSTANCE.handle(this.f_91074_, this.f_91066_) : SpellHotbar.INSTANCE.handle(this.f_91074_, SpellHotbar.INSTANCE.structuredSlots.other(), this.f_91066_);
        if (handled != null) {
            this.spellHotbarHandle = handled.category();
        }
        if (((SpellCasterClient)this.f_91074_).isCastingSpell()) {
            this.f_91078_ = 2;
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick_HEAD_SpellHotbar(CallbackInfo ci) {
        if (this.f_91074_ == null || this.f_91066_ == null) {
            return;
        }
        if (this.f_91080_ != null) {
            ((SpellCasterClient)this.f_91074_).cancelSpellCast();
        }
    }

    @Inject(method={"handleInputEvents"}, at={@At(value="TAIL")})
    private void handleInputEvents_TAIL_SpellHotbar(CallbackInfo ci) {
        if (this.f_91074_ == null || this.f_91066_ == null) {
            return;
        }
        this.popConflictingPressState();
        SpellHotbar.INSTANCE.syncItemUseSkill(this.f_91074_);
    }

    private void pushConflictingPressState(WrappedKeybinding.Category spellHotbarHandle, boolean value) {
        if (spellHotbarHandle != null) {
            switch (spellHotbarHandle) {
                case USE_KEY: {
                    this.conflictingPressState.put(this.f_91066_.f_92095_, this.f_91066_.f_92095_.m_90857_());
                    this.f_91066_.f_92095_.m_7249_(value);
                    break;
                }
            }
        }
    }

    private void popConflictingPressState() {
        for (Map.Entry<KeyMapping, Boolean> entry : this.conflictingPressState.entrySet()) {
            entry.getKey().m_7249_(entry.getValue().booleanValue());
        }
        this.conflictingPressState.clear();
    }

    @WrapWithCondition(method={"handleInputEvents"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/player/PlayerInventory;selectedSlot:I", ordinal=0, opcode=181)})
    private boolean handleInputEvents_OverrideNumberKeys(Inventory instance, int index) {
        boolean shouldControlSpellHotbar = false;
        if (!Keybindings.bypass_spell_hotbar.m_90857_()) {
            for (SpellHotbar.Slot slot : SpellHotbar.INSTANCE.slots) {
                KeyMapping keyBinding = slot.getKeyBinding(this.f_91066_);
                if (this.f_91066_.f_92056_[index] != keyBinding) continue;
                shouldControlSpellHotbar = true;
                break;
            }
        }
        return !shouldControlSpellHotbar;
    }

    @Inject(method={"doItemUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void doItemUse_HEAD_autoSwap(CallbackInfo ci) {
        if (SpellEngineClient.config.autoSwapHands && AutoSwapHelper.autoSwapForSpells()) {
            this.f_91011_ = SpellEngineMod.config.auto_swap_cooldown;
            this.f_91078_ = SpellEngineMod.config.auto_swap_cooldown;
            ci.cancel();
        }
    }

    @Inject(method={"doAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void doAttack_HEAD_autoSwap(CallbackInfoReturnable<Boolean> cir) {
        if (SpellEngineClient.config.autoSwapHands && AutoSwapHelper.autoSwapForAttack()) {
            this.f_91011_ = SpellEngineMod.config.auto_swap_cooldown;
            this.f_91078_ = SpellEngineMod.config.auto_swap_cooldown;
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }
}

