/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.client;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.spell_engine.api.effect.CustomParticleStatusEffect;
import net.spell_engine.api.effect.Synchronized;
import net.spell_engine.api.spell.ParticleBatch;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.client.beam.BeamEmitterEntity;
import net.spell_engine.internals.Beam;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.particle.ParticleHelper;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public class LivingEntityVisualMixin
implements BeamEmitterEntity {
    @Nullable
    public Beam.Rendered lastRenderedBeam;

    private LivingEntity livingEntity() {
        return (LivingEntity)this;
    }

    @Override
    public void setLastRenderedBeam(Beam.Rendered beam) {
        this.lastRenderedBeam = beam;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick_TAIL_spawnBeamParticles(CallbackInfo ci) {
        LivingEntity livingEntity = this.livingEntity();
        Spell.Release.Target.Beam beam = null;
        if (livingEntity instanceof SpellCasterEntity) {
            SpellCasterEntity caster = (SpellCasterEntity)livingEntity;
            beam = caster.getBeam();
        }
        Beam.Rendered renderedBeam = this.lastRenderedBeam;
        if (livingEntity.m_9236_().f_46443_ && beam != null && renderedBeam != null) {
            Beam.Position position = renderedBeam.position();
            Spell.Release.Target.Beam appearance = renderedBeam.appearance();
            float yaw = livingEntity.m_146908_();
            if (position.hitBlock()) {
                for (ParticleBatch batch : appearance.block_hit_particles) {
                    ParticleHelper.play(livingEntity.m_9236_(), livingEntity.f_19797_, position.end(), appearance.width * 2.0f, yaw, livingEntity.m_146909_(), batch);
                }
            }
        }
    }

    @Inject(method={"tickStatusEffects"}, at={@At(value="TAIL")})
    private void tickStatusEffects_TAIL_SpellEngine_CustomParticles(CallbackInfo ci) {
        LivingEntity livingEntity = this.livingEntity();
        if (!livingEntity.m_6084_() || !livingEntity.m_9236_().m_5776_()) {
            return;
        }
        for (Synchronized.Effect entry : Synchronized.effectsOf(livingEntity)) {
            MobEffect effect = entry.effect();
            int amplifier = entry.amplifier();
            CustomParticleStatusEffect.Spawner spawner = CustomParticleStatusEffect.spawnerOf(effect);
            if (spawner == null) continue;
            spawner.spawnParticles(livingEntity, amplifier);
        }
    }
}

