/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.client;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.effect.EntityActionsAllowed;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellInfo;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.input.SpellHotbar;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterClient;
import net.spell_engine.network.Packets;
import net.spell_engine.utils.TargetHelper;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LocalPlayer.class})
public abstract class ClientPlayerEntityMixin
implements SpellCasterClient {
    @Shadow
    @Final
    public ClientPacketListener f_108617_;
    private List<Entity> targets = List.of();
    @Nullable
    private SpellCast.Process spellCastProcess;

    private LocalPlayer player() {
        return (LocalPlayer)this;
    }

    private Entity firstTarget() {
        return this.targets.stream().findFirst().orElse(null);
    }

    @Override
    @Nullable
    public SpellCast.Process getSpellCastProcess() {
        return this.spellCastProcess;
    }

    @Override
    public Spell getCurrentSpell() {
        if (this.spellCastProcess != null) {
            return this.spellCastProcess.spell();
        }
        return null;
    }

    @Override
    public float getCurrentCastingSpeed() {
        if (this.spellCastProcess != null) {
            return this.spellCastProcess.speed();
        }
        return 1.0f;
    }

    @Override
    public boolean isCastingSpell() {
        return this.spellCastProcess != null;
    }

    private void setSpellCastProcess(SpellCast.Process newValue, boolean sync) {
        SpellCast.Process oldValue = this.spellCastProcess;
        this.spellCastProcess = newValue;
        if (sync && !Objects.equals(oldValue, newValue)) {
            ResourceLocation id = null;
            float speed = 0.0f;
            int length = 0;
            if (newValue != null) {
                id = newValue.id();
                speed = newValue.speed();
                length = newValue.length();
            }
            ClientPlayNetworking.send((ResourceLocation)Packets.SpellCastSync.ID, (FriendlyByteBuf)new Packets.SpellCastSync(id, speed, length).write());
        }
    }

    @Override
    public SpellCast.Attempt startSpellCast(ItemStack itemStack, ResourceLocation spellId) {
        LocalPlayer caster = this.player();
        if (caster.m_5833_()) {
            return SpellCast.Attempt.none();
        }
        if (spellId == null) {
            this.cancelSpellCast();
            return SpellCast.Attempt.none();
        }
        Spell spell = SpellRegistry.getSpell(spellId);
        if (this.spellCastProcess != null && this.spellCastProcess.id().equals((Object)spellId) || spell == null || spell.mode == Spell.Mode.ITEM_USE) {
            return SpellCast.Attempt.none();
        }
        if (EntityActionsAllowed.isImpaired((LivingEntity)caster, EntityActionsAllowed.Player.CAST_SPELL, true)) {
            return SpellCast.Attempt.none();
        }
        SpellCast.Attempt attempt = SpellHelper.attemptCasting((Player)caster, itemStack, spellId);
        if (attempt.isSuccess()) {
            boolean instant;
            if (this.spellCastProcess != null) {
                this.cancelSpellCast(false);
            }
            boolean bl = instant = spell.cast.duration <= 0.0f;
            if (instant) {
                SpellCast.Process process = new SpellCast.Process(spellId, spell, itemStack.m_41720_(), 1.0f, 0, caster.m_9236_().m_46467_());
                this.setSpellCastProcess(process, false);
                this.updateSpellCast();
                this.applyInstantGlobalCooldown();
            } else {
                SpellCast.Duration details = SpellHelper.getCastTimeDetails((LivingEntity)caster, spell);
                this.setSpellCastProcess(new SpellCast.Process(spellId, spell, itemStack.m_41720_(), details.speed(), details.length(), caster.m_9236_().m_46467_()), true);
            }
        }
        return attempt;
    }

    private void applyInstantGlobalCooldown() {
        int duration = SpellEngineMod.config.spell_instant_cast_gcd;
        if (duration > 0) {
            for (SpellHotbar.Slot slot : SpellHotbar.INSTANCE.slots) {
                SpellInfo info = slot.spell();
                if (info.spell().cast == null || !(info.spell().cast.duration <= 0.0f)) continue;
                this.getCooldownManager().set(info.id(), duration, false);
            }
        }
    }

    @Override
    @Nullable
    public SpellCast.Progress getSpellCastProgress() {
        if (this.spellCastProcess != null) {
            LocalPlayer player = this.player();
            return this.spellCastProcess.progress(player.m_9236_().m_46467_());
        }
        return null;
    }

    @Override
    public void cancelSpellCast() {
        this.cancelSpellCast(true);
    }

    public void cancelSpellCast(boolean syncProcess) {
        SpellCast.Process process = this.spellCastProcess;
        if (process != null && SpellHelper.isChanneled(process.spell())) {
            LocalPlayer player = this.player();
            SpellCast.Progress progress = process.progress(player.m_9236_().m_46467_());
            ClientPlayNetworking.send((ResourceLocation)Packets.SpellRequest.ID, (FriendlyByteBuf)new Packets.SpellRequest(SpellCast.Action.RELEASE, process.id(), progress.ratio(), new int[0]).write());
        }
        this.setSpellCastProcess(null, syncProcess);
        this.targets = List.of();
    }

    private void updateSpellCast() {
        SpellCast.Process process = this.spellCastProcess;
        if (process != null) {
            LocalPlayer player = this.player();
            if (!this.player().m_6084_() || player.m_21205_().m_41720_() != process.item() || this.getCooldownManager().isCoolingDown(process.id()) || EntityActionsAllowed.isImpaired((LivingEntity)player, EntityActionsAllowed.Player.CAST_SPELL, true)) {
                this.cancelSpellCast();
                return;
            }
            this.targets = this.findTargets(process.spell());
            Spell spell = process.spell();
            int spellCastTicks = process.spellCastTicksSoFar(player.m_9236_().m_46467_());
            if (SpellHelper.isChanneled(spell)) {
                boolean isDue;
                int offset = Math.round((float)spell.cast.channel_ticks * 0.5f);
                int currentTick = spellCastTicks + offset;
                boolean bl = isDue = currentTick >= spell.cast.channel_ticks && currentTick % spell.cast.channel_ticks == 0;
                if (isDue) {
                    this.releaseSpellCast(process, SpellCast.Action.CHANNEL);
                }
            } else {
                boolean isFinished;
                boolean bl = isFinished = spellCastTicks >= process.length();
                if (isFinished) {
                    this.releaseSpellCast(process, SpellCast.Action.RELEASE);
                }
            }
        } else {
            this.targets = List.of();
        }
    }

    private void releaseSpellCast(SpellCast.Process process, SpellCast.Action action) {
        ResourceLocation spellId = process.id();
        Spell spell = process.spell();
        LocalPlayer player = this.player();
        SpellCast.Progress progress = process.progress(player.m_9236_().m_46467_());
        Spell.Release.Target release = spell.release.target;
        int[] targetIDs = new int[]{};
        switch (release.type) {
            case PROJECTILE: 
            case CURSOR: 
            case METEOR: {
                Entity firstTarget = this.firstTarget();
                if (firstTarget == null) break;
                targetIDs = new int[]{firstTarget.m_19879_()};
                break;
            }
            case AREA: 
            case BEAM: {
                targetIDs = new int[this.targets.size()];
                int i = 0;
                for (Entity target : this.targets) {
                    targetIDs[i] = target.m_19879_();
                    ++i;
                }
                break;
            }
        }
        ClientPlayNetworking.send((ResourceLocation)Packets.SpellRequest.ID, (FriendlyByteBuf)new Packets.SpellRequest(action, spellId, progress.ratio(), targetIDs).write());
        switch (action) {
            case CHANNEL: {
                if (!(progress.ratio() >= 1.0f)) break;
                this.cancelSpellCast();
                break;
            }
            case RELEASE: {
                this.cancelSpellCast();
            }
        }
    }

    @Override
    public List<Entity> getCurrentTargets() {
        if (this.targets == null) {
            return List.of();
        }
        return this.targets;
    }

    @Override
    public Entity getCurrentFirstTarget() {
        return this.firstTarget();
    }

    private int findSlot(Player player, ItemStack stack) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack itemStack = player.m_150109_().m_8020_(i);
            if (stack != itemStack) continue;
            return i;
        }
        return -1;
    }

    private List<Entity> findTargets(Spell currentSpell) {
        Spell.Release.Target.Cursor cursor;
        LocalPlayer caster = this.player();
        List<Entity> previousTargets = this.targets;
        List<Object> targets = List.of();
        if (currentSpell == null || currentSpell.impact == null) {
            return targets;
        }
        boolean fallbackToPreviousTargets = false;
        TargetHelper.TargetingMode targetingMode = SpellHelper.selectionTargetingMode(currentSpell);
        Spell.Release.Target.Type targetType = currentSpell.release.target.type;
        EnumSet<TargetHelper.Intent> intents = SpellHelper.intents(currentSpell);
        Predicate<Entity> selectionPredicate = target -> {
            boolean intentAllows = false;
            for (TargetHelper.Intent intent : intents) {
                intentAllows = intentAllows || TargetHelper.actionAllowed(targetingMode, intent, (LivingEntity)caster, target);
            }
            return !SpellEngineClient.config.filterInvalidTargets || intentAllows;
        };
        switch (targetType) {
            case AREA: {
                targets = TargetHelper.targetsFromArea((Entity)caster, currentSpell.range, currentSpell.release.target.area, selectionPredicate);
                Spell.Release.Target.Area area = currentSpell.release.target.area;
                if (area == null || !area.include_caster) break;
                targets.add((Entity)caster);
                break;
            }
            case BEAM: {
                targets = TargetHelper.targetsFromRaycast((Entity)caster, currentSpell.range, selectionPredicate);
                break;
            }
            case PROJECTILE: 
            case CURSOR: 
            case METEOR: {
                fallbackToPreviousTargets = targetType != Spell.Release.Target.Type.PROJECTILE;
                Entity target2 = TargetHelper.targetFromRaycast((Entity)caster, currentSpell.range, selectionPredicate);
                if (target2 != null) {
                    targets = List.of(target2);
                    break;
                }
                targets = List.of();
                break;
            }
        }
        if (fallbackToPreviousTargets && SpellEngineClient.config.stickyTarget && targets.isEmpty()) {
            targets = previousTargets.stream().filter(entity -> TargetHelper.isInLineOfSight((Entity)caster, entity)).toList();
        }
        if ((cursor = currentSpell.release.target.cursor) != null && cursor.use_caster_as_fallback && targets.isEmpty()) {
            targets = List.of(caster);
        }
        return targets;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick_TAIL_SpellEngine(CallbackInfo ci) {
        this.updateSpellCast();
        LocalPlayer player = this.player();
        if (this.isBeaming()) {
            this.f_108617_.m_104955_((Packet)new ServerboundMovePlayerPacket.PosRot(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_(), player.m_146909_(), player.m_20096_()));
        }
    }
}

