/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.arrow;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellInfo;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.internals.arrow.ArrowExtension;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CrossbowItem.class})
public class CrossbowItemMixin {
    private static final String NBT_KEY_SPELL = "se_spell";

    @WrapOperation(method={"onStoppedUsing"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/CrossbowItem;setCharged(Lnet/minecraft/item/ItemStack;Z)V")})
    private void onStoppedUsing_SpellEngine(ItemStack itemStack, boolean charged, Operation<Void> original, ItemStack itemStack2, Level world, LivingEntity user, int remainingUseTicks) {
        SpellCasterEntity caster;
        SpellCast.Process process;
        if (user instanceof SpellCasterEntity && (process = (caster = (SpellCasterEntity)user).getSpellCastProcess()) != null) {
            itemStack.m_41784_().m_128359_(NBT_KEY_SPELL, process.id().toString());
        }
        original.call(new Object[]{itemStack, charged});
    }

    @WrapOperation(method={"shoot"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnEntity(Lnet/minecraft/entity/Entity;)Z")})
    private static boolean shoot_SpellEngine(Level worldParam, Entity projectileEntity, Operation<Boolean> original, Level world, LivingEntity shooter, InteractionHand hand, ItemStack crossbow, ItemStack projectile, float soundPitch, boolean creative, float speed, float divergence, float simulated) {
        if (crossbow.m_41783_() != null && crossbow.m_41783_().m_128441_(NBT_KEY_SPELL) && projectileEntity instanceof ArrowExtension) {
            ArrowExtension arrow = (ArrowExtension)projectileEntity;
            ResourceLocation id = new ResourceLocation(crossbow.m_41783_().m_128461_(NBT_KEY_SPELL));
            boolean isMultiShot = simulated != 0.0f;
            Spell spell = SpellRegistry.getSpell(id);
            if (spell != null) {
                arrow.applyArrowPerks(new SpellInfo(spell, id));
                if (isMultiShot) {
                    arrow.allowByPassingIFrames_SpellEngine(false);
                }
            }
        }
        return (Boolean)original.call(new Object[]{worldParam, projectileEntity});
    }

    @Inject(method={"setCharged"}, at={@At(value="TAIL")})
    private static void setCharged_TAIL_SpellEngine(ItemStack stack, boolean charged, CallbackInfo ci) {
        if (!charged && stack.m_41783_().m_128441_(NBT_KEY_SPELL)) {
            stack.m_41783_().m_128473_(NBT_KEY_SPELL);
        }
    }
}

