/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.internals.SpellCasterItemStack;
import net.spell_engine.internals.SpellContainerHelper;
import net.spell_engine.internals.SpellRegistry;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
implements SpellCasterItemStack {
    @Shadow
    public abstract Item m_41720_();

    private ItemStack itemStack() {
        return (ItemStack)this;
    }

    @Nullable
    private SpellContainer spellContainer() {
        SpellContainer nbtContainer = this.spellContainerFromNBT();
        if (nbtContainer != null) {
            return nbtContainer;
        }
        return this.spellContainerDefault();
    }

    @Nullable
    private SpellContainer spellContainerFromNBT() {
        ItemStack itemStack = this.itemStack();
        if (!itemStack.m_41782_()) {
            return null;
        }
        return SpellContainerHelper.fromNBT(itemStack.m_41783_());
    }

    @Nullable
    private SpellContainer spellContainerDefault() {
        Item item = this.m_41720_();
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        return SpellRegistry.containerForItem(id);
    }

    @Override
    @Nullable
    public SpellContainer getSpellContainer() {
        return this.spellContainer();
    }
}

