/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals.arrow;

import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.fabric_extras.ranged_weapon.internal.ScalingUtil;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellEvents;
import net.spell_engine.api.spell.SpellInfo;
import net.spell_engine.compat.QuiverCompat;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.WorldScheduler;
import net.spell_engine.internals.arrow.ArrowExtension;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ArrowHelper {
    public static void shootArrow(Level world, LivingEntity shooter, SpellInfo spellInfo, SpellHelper.ImpactContext context) {
        ArrowHelper.shootArrow(world, shooter, spellInfo, context, 0);
    }

    public static void shootArrow(Level world, LivingEntity shooter, SpellInfo spellInfo, SpellHelper.ImpactContext context, int sequenceIndex) {
        boolean isCreative = shooter instanceof Player && ((Player)shooter).m_150110_().f_35937_;
        Spell spell = spellInfo.spell();
        Spell.Release.Target.ShootArrow shoot_arrow = spell.release.target.shoot_arrow;
        if (shoot_arrow != null) {
            Spell.LaunchProperties launchProperties = shoot_arrow.launch_properties.copy();
            Player player = (Player)shooter;
            boolean infinity = !shoot_arrow.consume_arrow || player.m_7500_() || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)player.m_21205_()) > 0;
            AbstractArrow.Pickup arrowPickUpType = AbstractArrow.Pickup.CREATIVE_ONLY;
            ItemStack ammo = new ItemStack((ItemLike)Items.f_42412_);
            if (!infinity) {
                arrowPickUpType = AbstractArrow.Pickup.ALLOWED;
                if (!ArrowHelper.tryConsumeItem(player, Items.f_42412_)) {
                    return;
                }
            }
            ScalingUtil.Scaling scaling = ScalingUtil.scaling((ItemStack)shooter.m_21205_(), (double)shooter.m_21133_(EntityAttributes_RangedWeapon.DAMAGE.attribute));
            Projectile projectile = ArrowHelper.shoot(world, shooter, InteractionHand.MAIN_HAND, shooter.m_21205_(), ammo, 1.0f, isCreative, (float)((double)launchProperties.velocity * scaling.velocity()), 1.0f, 0.0f, spellInfo);
            if (projectile instanceof AbstractArrow) {
                AbstractArrow persistentProjectile = (AbstractArrow)projectile;
                persistentProjectile.m_36781_(persistentProjectile.m_36789_() * (double)shoot_arrow.damage_multiplier * scaling.damage());
                persistentProjectile.f_36705_ = arrowPickUpType;
            }
            if (SpellEvents.ARROW_FIRED.isListened()) {
                SpellEvents.ARROW_FIRED.invoke(listener -> listener.onArrowLaunch(new SpellEvents.ArrowLaunchEvent(projectile, shooter, spellInfo, context, sequenceIndex)));
            }
            int extra_launch = launchProperties.extra_launch_count;
            if (sequenceIndex == 0 && extra_launch > 0) {
                for (int i = 0; i < extra_launch; ++i) {
                    int ticks = (i + 1) * launchProperties.extra_launch_delay;
                    int nextSequenceIndex = i + 1;
                    ((WorldScheduler)world).schedule(ticks, () -> {
                        if (shooter == null || !shooter.m_6084_()) {
                            return;
                        }
                        ArrowHelper.shootArrow(world, shooter, spellInfo, context, nextSequenceIndex);
                    });
                }
            }
        }
    }

    public static boolean tryConsumeItem(Player player, Item item) {
        if (QuiverCompat.consumeArrow(item, player)) {
            return true;
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!stack.m_150930_(item)) continue;
            stack.m_41774_(1);
            if (stack.m_41619_()) {
                player.m_150109_().m_36057_(stack);
            }
            return true;
        }
        return false;
    }

    private static Projectile shoot(Level world, LivingEntity shooter, InteractionHand hand, ItemStack crossbow, ItemStack projectile, float soundPitch, boolean creative, float speed, float divergence, float simulated, SpellInfo spellInfo) {
        AbstractArrow projectileEntity;
        boolean bl = projectile.m_150930_(Items.f_42688_);
        if (bl) {
            projectileEntity = new FireworkRocketEntity(world, projectile, (Entity)shooter, shooter.m_20185_(), shooter.m_20188_() - (double)0.15f, shooter.m_20189_(), true);
        } else {
            projectileEntity = ArrowHelper.createArrow(world, shooter, crossbow, projectile, spellInfo);
            if (creative || simulated != 0.0f) {
                projectileEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
        }
        if (shooter instanceof CrossbowAttackMob) {
            CrossbowAttackMob crossbowUser = (CrossbowAttackMob)shooter;
            crossbowUser.m_5811_(crossbowUser.m_5448_(), crossbow, (Projectile)projectileEntity, simulated);
        } else {
            Vec3 vec3d = shooter.m_20289_(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(simulated * ((float)Math.PI / 180)), vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
            Vec3 vec3d2 = shooter.m_20252_(1.0f);
            Vector3f vector3f = vec3d2.m_252839_().rotate((Quaternionfc)quaternionf);
            projectileEntity.m_6686_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), speed, divergence);
        }
        crossbow.m_41622_(bl ? 3 : 1, shooter, e -> e.m_21190_(hand));
        world.m_7967_((Entity)projectileEntity);
        world.m_6263_((Player)null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, soundPitch);
        return projectileEntity;
    }

    private static AbstractArrow createArrow(Level world, LivingEntity entity, ItemStack crossbow, ItemStack arrow, SpellInfo spellInfo) {
        Spell.Release.Target.ShootArrow shoot_arrow;
        ArrowItem arrowItem = (ArrowItem)(arrow.m_41720_() instanceof ArrowItem ? arrow.m_41720_() : Items.f_42412_);
        AbstractArrow persistentProjectileEntity = arrowItem.m_6394_(world, arrow, entity);
        persistentProjectileEntity.m_36740_(SoundEvents.f_11840_);
        persistentProjectileEntity.m_36793_(true);
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)crossbow);
        if (i > 0) {
            persistentProjectileEntity.m_36767_((byte)i);
        }
        ((ArrowExtension)persistentProjectileEntity).applyArrowPerks(spellInfo);
        Spell.Release release = spellInfo.spell().release;
        if (release != null && (shoot_arrow = release.target.shoot_arrow) != null) {
            persistentProjectileEntity.m_36762_(shoot_arrow.arrow_critical_strike);
        }
        return persistentProjectileEntity;
    }
}

