/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.api.spell.SpellPool;
import net.spell_engine.internals.Validator;
import net.spell_engine.utils.WeaponCompatibility;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;

public class SpellRegistry {
    private static final Map<ResourceLocation, SpellEntry> spells = new HashMap<ResourceLocation, SpellEntry>();
    private static final Map<ResourceLocation, SpellPool> pools = new HashMap<ResourceLocation, SpellPool>();
    public static final Map<ResourceLocation, SpellContainer> book_containers = new HashMap<ResourceLocation, SpellContainer>();
    public static final Map<ResourceLocation, SpellContainer> containers = new HashMap<ResourceLocation, SpellContainer>();
    private static final Map<SpellSchool, Integer> spellCount = new HashMap<SpellSchool, Integer>();
    public static FriendlyByteBuf encoded = PacketByteBufs.create();
    private static final Map<Integer, ReverseEntry> reverseSpells = new HashMap<Integer, ReverseEntry>();

    public static Map<ResourceLocation, SpellEntry> all() {
        return spells;
    }

    public static void initialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(minecraftServer -> {
            SpellRegistry.loadSpells(minecraftServer.m_177941_());
            SpellRegistry.loadPools(minecraftServer.m_177941_());
            SpellRegistry.loadContainers(minecraftServer.m_177941_());
            WeaponCompatibility.initialize();
            SpellRegistry.encodeContent();
        });
    }

    public static void loadSpells(ResourceManager resourceManager) {
        Gson gson = new Gson();
        HashMap<ResourceLocation, SpellEntry> parsed = new HashMap<ResourceLocation, SpellEntry>();
        int rawId = 1;
        String directory = "spells";
        for (Map.Entry entry : resourceManager.m_214159_(directory, fileName -> fileName.m_135815_().endsWith(".json")).entrySet()) {
            ResourceLocation identifier = (ResourceLocation)entry.getKey();
            Resource resource = (Resource)entry.getValue();
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(resource.m_215507_()));
                Spell container = (Spell)gson.fromJson(reader, Spell.class);
                String id = identifier.toString().replace(directory + "/", "");
                id = id.substring(0, id.lastIndexOf(46));
                Validator.validate(container);
                parsed.put(new ResourceLocation(id), new SpellEntry(container, rawId++));
            }
            catch (Exception e) {
                System.err.println("Spell Engine: Failed to parse spell: " + identifier + " | Reason: " + e.getMessage());
            }
        }
        spells.clear();
        spells.putAll(parsed);
        SpellRegistry.spellsUpdated();
    }

    public static void loadPools(ResourceManager resourceManager) {
        Gson gson = new Gson();
        HashMap<ResourceLocation, SpellPool.DataFormat> parsed = new HashMap<ResourceLocation, SpellPool.DataFormat>();
        String directory = "spell_pools";
        for (Map.Entry entry : resourceManager.m_214159_(directory, fileName -> fileName.m_135815_().endsWith(".json")).entrySet()) {
            ResourceLocation identifier = (ResourceLocation)entry.getKey();
            Resource resource = (Resource)entry.getValue();
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(resource.m_215507_()));
                SpellPool.DataFormat pool = (SpellPool.DataFormat)gson.fromJson(reader, SpellPool.DataFormat.class);
                String id = identifier.toString().replace(directory + "/", "");
                id = id.substring(0, id.lastIndexOf(46));
                parsed.put(new ResourceLocation(id), pool);
            }
            catch (Exception e2) {
                System.err.println("Spell Engine: Failed to parse spell pool: " + identifier + " | Reason: " + e2.getMessage());
            }
        }
        Map<ResourceLocation, Spell> spellFlat = spells.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SpellEntry)e.getValue()).spell));
        pools.clear();
        for (Map.Entry entry : parsed.entrySet()) {
            pools.put((ResourceLocation)entry.getKey(), SpellPool.fromData((SpellPool.DataFormat)entry.getValue(), spellFlat));
        }
    }

    public static void loadContainers(ResourceManager resourceManager) {
        Gson gson = new Gson();
        HashMap<ResourceLocation, SpellContainer> parsed = new HashMap<ResourceLocation, SpellContainer>();
        String directory = "spell_assignments";
        for (Map.Entry entry : resourceManager.m_214159_(directory, fileName -> fileName.m_135815_().endsWith(".json")).entrySet()) {
            ResourceLocation identifier = (ResourceLocation)entry.getKey();
            Resource resource = (Resource)entry.getValue();
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(resource.m_215507_()));
                SpellContainer container = (SpellContainer)gson.fromJson(reader, SpellContainer.class);
                String id = identifier.toString().replace(directory + "/", "");
                id = id.substring(0, id.lastIndexOf(46));
                parsed.put(new ResourceLocation(id), container);
            }
            catch (Exception e) {
                System.err.println("Spell Engine: Failed to parse spell_assignment: " + identifier + " | Reason: " + e.getMessage());
            }
        }
        containers.clear();
        containers.putAll(parsed);
        containers.putAll(book_containers);
    }

    private static void spellsUpdated() {
        SpellRegistry.updateReverseMaps();
        spellCount.clear();
        for (SpellSchool spellSchool : SpellSchools.all()) {
            spellCount.put(spellSchool, 0);
        }
        for (Map.Entry entry : spells.entrySet()) {
            SpellSchool school = ((SpellEntry)entry.getValue()).spell.school;
            Integer current = spellCount.get(school);
            spellCount.put(school, current + 1);
        }
    }

    public static int numberOfSpells(SpellSchool school) {
        return spellCount.get(school);
    }

    public static SpellContainer containerForItem(ResourceLocation itemId) {
        if (itemId == null) {
            return null;
        }
        return containers.get(itemId);
    }

    public static Spell getSpell(ResourceLocation spellId) {
        SpellEntry entry = spells.get(spellId);
        if (entry != null) {
            return entry.spell;
        }
        return null;
    }

    public static SpellPool spellPool(ResourceLocation id) {
        SpellPool pool = pools.get(id);
        return pool != null ? pool : SpellPool.empty;
    }

    private static void encodeContent() {
        Gson gson = new Gson();
        FriendlyByteBuf buffer = PacketByteBufs.create();
        SyncFormat sync = new SyncFormat();
        spells.forEach((key, value) -> sync.spells.put(key.toString(), (SpellEntry)value));
        pools.forEach((key, value) -> sync.pools.put(key.toString(), value.toSync()));
        containers.forEach((key, value) -> sync.containers.put(key.toString(), (SpellContainer)value));
        String json = gson.toJson((Object)sync);
        ArrayList<String> chunks = new ArrayList<String>();
        int chunkSize = 10000;
        for (int i = 0; i < json.length(); i += chunkSize) {
            chunks.add(json.substring(i, Math.min(json.length(), i + chunkSize)));
        }
        buffer.writeInt(chunks.size());
        for (String chunk : chunks) {
            buffer.m_130070_(chunk);
        }
        System.out.println("Encoded SpellRegistry size (with package overhead): " + buffer.readableBytes() + " bytes (in " + chunks.size() + " string chunks with the size of " + chunkSize + ")");
        encoded = buffer;
    }

    public static void decodeContent(FriendlyByteBuf buffer) {
        int chunkCount = buffer.readInt();
        String json = "";
        for (int i = 0; i < chunkCount; ++i) {
            json = json.concat(buffer.m_130277_());
        }
        Gson gson = new Gson();
        SyncFormat sync = (SyncFormat)gson.fromJson(json, SyncFormat.class);
        spells.clear();
        sync.spells.forEach((key, value) -> spells.put(new ResourceLocation(key), (SpellEntry)value));
        sync.pools.forEach((key, value) -> pools.put(new ResourceLocation(key), SpellPool.fromSync(value)));
        sync.containers.forEach((key, value) -> containers.put(new ResourceLocation(key), (SpellContainer)value));
        SpellRegistry.spellsUpdated();
    }

    private static void updateReverseMaps() {
        reverseSpells.clear();
        for (Map.Entry<ResourceLocation, SpellEntry> entry : spells.entrySet()) {
            ResourceLocation id = entry.getKey();
            Spell spell = entry.getValue().spell;
            int rawId = entry.getValue().rawId;
            reverseSpells.put(rawId, new ReverseEntry(id, spell));
        }
    }

    public static int rawSpellId(ResourceLocation identifier) {
        return SpellRegistry.spells.get((Object)identifier).rawId;
    }

    public static Optional<ResourceLocation> fromRawSpellId(int rawId) {
        ReverseEntry reverseEntry = reverseSpells.get(rawId);
        if (reverseEntry != null) {
            return Optional.of(reverseEntry.identifier);
        }
        return Optional.empty();
    }

    public static class SpellEntry {
        public Spell spell;
        public int rawId;

        public SpellEntry() {
        }

        public SpellEntry(Spell spell, int rawId) {
            this.spell = spell;
            this.rawId = rawId;
        }
    }

    public static class SyncFormat {
        public Map<String, SpellEntry> spells = new HashMap<String, SpellEntry>();
        public Map<String, SpellPool.SyncFormat> pools = new HashMap<String, SpellPool.SyncFormat>();
        public Map<String, SpellContainer> containers = new HashMap<String, SpellContainer>();
    }

    private record ReverseEntry(ResourceLocation identifier, Spell spell) {
    }
}

