/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals;

import java.util.HashSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.MendingEnchantment;
import net.spell_engine.SpellEngineMod;
import net.tinyconfig.models.EnchantmentConfig;

public class SpellInfinityEnchantment
extends Enchantment {
    public EnchantmentConfig config;
    public static final ResourceLocation tagId = new ResourceLocation("spell_engine", "enchant_spell_infinity");
    public static final HashSet<Item> ALLOWED_ITEMS = new HashSet();

    public SpellInfinityEnchantment(Enchantment.Rarity weight, EnchantmentConfig config, EquipmentSlot ... slotTypes) {
        super(weight, EnchantmentCategory.BREAKABLE, slotTypes);
        this.config = config;
    }

    public static boolean isEligible(ItemStack stack) {
        return ALLOWED_ITEMS.contains(stack.m_41720_()) || stack.m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagId));
    }

    public int m_6586_() {
        if (!SpellEngineMod.config.spell_cost_item_allowed) {
            return 0;
        }
        return this.config.max_level;
    }

    public int m_6183_(int level) {
        return this.config.min_cost + (level - 1) * this.config.step_cost;
    }

    public int m_6175_(int level) {
        return super.m_6183_(level) + 50;
    }

    public boolean m_5975_(Enchantment other) {
        return other instanceof MendingEnchantment ? false : super.m_5975_(other);
    }
}

