/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.fabric.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.particles.ParticleType;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.gui.HudRenderHelper;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.client.input.Keybindings;
import net.spell_engine.client.particle.GenericSpellParticle;
import net.spell_engine.client.particle.ShiftedParticle;
import net.spell_engine.client.particle.SpellExplosionParticle;
import net.spell_engine.client.particle.SpellFlameParticle;
import net.spell_engine.client.particle.SpellHitParticle;
import net.spell_engine.client.particle.SpellSnowflakeParticle;
import net.spell_engine.client.render.CustomModelRegistry;
import net.spell_engine.client.render.SpellCloudRenderer;
import net.spell_engine.client.render.SpellProjectileRenderer;
import net.spell_engine.entity.SpellCloud;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.particle.Particles;

public class FabricClientMod
implements ClientModInitializer {
    public void onInitializeClient() {
        SpellEngineClient.initialize();
        this.registerKeyBindings();
        HudRenderCallback.EVENT.register((context, tickDelta) -> HudRenderHelper.render(context, tickDelta));
        ItemTooltipCallback.EVENT.register((itemStack, context, lines) -> SpellTooltip.addSpellInfo(itemStack, lines));
        EntityRendererRegistry.register(SpellProjectile.ENTITY_TYPE, SpellProjectileRenderer::new);
        EntityRendererRegistry.register(SpellCloud.ENTITY_TYPE, SpellCloudRenderer::new);
        this.registerParticleAppearances();
    }

    private void registerParticleAppearances() {
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.arcane_hit.particleType, SpellHitParticle.ArcaneFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.arcane_spell.particleType, GenericSpellParticle.ArcaneSpellFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.healing_ascend.particleType, SpellFlameParticle.HealingFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.holy_hit.particleType, SpellHitParticle.HolyFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.holy_ascend.particleType, SpellFlameParticle.HolyFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.holy_spark_mini.particleType, SpellFlameParticle.HolyFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.holy_spark.particleType, SpellSnowflakeParticle.HolyFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.holy_spell.particleType, GenericSpellParticle.HolySpellFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.nature_spark_mini.particleType, SpellFlameParticle.NatureFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.nature_spark_mini_slowing.particleType, SpellFlameParticle.NatureSlowingFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.white_spark_mini.particleType, SpellFlameParticle.WhiteFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.fire_explosion.particleType, SpellExplosionParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.flame.particleType, SpellFlameParticle.FlameFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.flame_spark.particleType, SpellFlameParticle.AnimatedFlameFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.flame_ground.particleType, SpellFlameParticle.AnimatedFlameFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.flame_medium_a.particleType, SpellFlameParticle.MediumFlameFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.flame_medium_b.particleType, SpellFlameParticle.MediumFlameFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.snowflake.particleType, SpellSnowflakeParticle.FrostFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.frost_hit.particleType, SpellHitParticle.FrostFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.frost_shard.particleType, SpellFlameParticle.FrostShard::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.dripping_blood.particleType, SpellSnowflakeParticle.DrippingBloodFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.roots.particleType, ShiftedParticle.RootsFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.electric_arc_A.particleType, SpellFlameParticle.ElectricSparkFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.electric_arc_B.particleType, SpellFlameParticle.ElectricSparkFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.smoke_medium.particleType, SpellFlameParticle.SmokeFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.weakness_smoke.particleType, SpellFlameParticle.WeaknessSmokeFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.buff_rage.particleType, SpellFlameParticle.BuffRageFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)Particles.sign_charge.particleType, SpellFlameParticle.RageSignFactory::new);
        ModelLoadingPlugin.register(pluginCtx -> pluginCtx.addModels(CustomModelRegistry.modelIds));
    }

    private void registerKeyBindings() {
        for (KeyMapping keybinding : Keybindings.all()) {
            KeyBindingHelper.registerKeyBinding((KeyMapping)keybinding);
        }
    }
}

