/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.entity;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.entity.TwoWayCollisionChecker;
import net.spell_engine.api.spell.ParticleBatch;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellInfo;
import net.spell_engine.client.render.FlyingSpellEntity;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.particle.ParticleHelper;
import net.spell_engine.utils.RecordsWithGson;
import net.spell_engine.utils.SoundHelper;
import net.spell_engine.utils.TargetHelper;
import net.spell_engine.utils.VectorHelper;

public class SpellProjectile
extends Projectile
implements FlyingSpellEntity {
    public static EntityType<SpellProjectile> ENTITY_TYPE;
    private static Random random;
    public float range = 128.0f;
    private Spell.ProjectileData.Perks perks;
    private SpellHelper.ImpactContext context;
    private Entity followedTarget;
    private ResourceLocation spellId;
    private ResourceLocation itemModelId;
    private ItemStack itemStackModel;
    public Vec3 previousVelocity;
    private Spell.ProjectileData clientSyncedData;
    private boolean skipTravel = false;
    protected Set<Integer> impactHistory = new HashSet<Integer>();
    private static String NBT_SPELL_ID;
    private static String NBT_PERKS;
    private static String NBT_IMPACT_CONTEXT;
    private static String NBT_ITEM_MODEL_ID;
    private static final EntityDataAccessor<String> BEHAVIOUR;
    private static final EntityDataAccessor<String> CLIENT_DATA;
    private static final EntityDataAccessor<Integer> TARGET_ID;
    private static final EntityDataAccessor<String> ITEM_MODEL_ID;

    public SpellProjectile(EntityType<? extends Projectile> entityType, Level world) {
        super(entityType, world);
    }

    protected SpellProjectile(Level world, LivingEntity owner) {
        super(ENTITY_TYPE, world);
        this.m_5602_((Entity)owner);
    }

    public SpellProjectile(Level world, LivingEntity caster, double x, double y, double z, Behaviour behaviour, ResourceLocation spellId, Entity target, SpellHelper.ImpactContext context, Spell.ProjectileData.Perks mutablePerks) {
        this(world, caster);
        this.m_6034_(x, y, z);
        this.spellId = spellId;
        this.perks = mutablePerks;
        Spell.ProjectileData projectileData = this.projectileData();
        Gson gson = new Gson();
        this.context = context;
        this.m_20088_().m_135381_(CLIENT_DATA, (Object)gson.toJson((Object)projectileData));
        this.m_20088_().m_135381_(BEHAVIOUR, (Object)behaviour.toString());
        if (projectileData.client_data != null && projectileData.client_data.model != null) {
            Spell.ProjectileModel model = projectileData.client_data.model;
            if (model.use_held_item) {
                this.setItemStackModel(caster.m_21205_());
            }
        }
        this.setFollowedTarget(target);
    }

    public Spell.ProjectileData.Perks mutablePerks() {
        return this.perks;
    }

    public Spell.ProjectileData projectileData() {
        if (this.m_9236_().f_46443_) {
            return this.clientSyncedData;
        }
        Spell spell = this.getSpell();
        Spell.Release.Target release = spell.release.target;
        switch (release.type) {
            case PROJECTILE: {
                return release.projectile.projectile;
            }
            case METEOR: {
                return release.meteor.projectile;
            }
        }
        return null;
    }

    private void updateClientSideData() {
        if (this.clientSyncedData == null) {
            try {
                Spell.ProjectileData data;
                Gson gson = new Gson();
                String json = (String)this.m_20088_().m_135370_(CLIENT_DATA);
                this.clientSyncedData = data = (Spell.ProjectileData)gson.fromJson(json, Spell.ProjectileData.class);
            }
            catch (Exception e) {
                System.err.println("Spell Projectile - Failed to read clientSyncedData");
            }
        }
        if (this.itemModelId == null) {
            String idString = (String)this.m_20088_().m_135370_(ITEM_MODEL_ID);
            this.updateItemModel(idString);
        }
    }

    private void updateItemModel(String idString) {
        if (idString != null && !idString.isEmpty()) {
            this.itemModelId = new ResourceLocation((String)this.m_20088_().m_135370_(ITEM_MODEL_ID));
            this.itemStackModel = ((Item)BuiltInRegistries.f_257033_.m_7745_(this.itemModelId)).m_7968_();
        }
    }

    public void setItemStackModel(ItemStack itemStack) {
        ResourceLocation modelId;
        this.itemModelId = modelId = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_());
        this.m_20088_().m_135381_(ITEM_MODEL_ID, (Object)modelId.toString());
    }

    public void setVelocity(double x, double y, double z, float speed, float spread, float divergence) {
        double rotX = Math.toRadians(divergence * random.nextFloat(spread, 1.0f));
        double rotY = Math.toRadians(360.0f * random.nextFloat());
        Vec3 vec3d = new Vec3(x, y, z).m_82496_((float)rotX).m_82524_((float)rotY).m_82490_((double)speed);
        this.m_20256_(vec3d);
        double d = vec3d.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)vec3d.f_82479_, (double)vec3d.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec3d.f_82480_, (double)d) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public void setFollowedTarget(Entity target) {
        this.followedTarget = target;
        int id = 0;
        if (!this.m_9236_().f_46443_) {
            if (target != null) {
                id = target.m_19879_();
            }
            this.m_20088_().m_135381_(TARGET_ID, (Object)id);
        }
    }

    public Entity getFollowedTarget() {
        Entity entityReference = null;
        if (this.m_9236_().f_46443_) {
            Integer id = (Integer)this.m_20088_().m_135370_(TARGET_ID);
            if (id != null && id != 0) {
                entityReference = this.m_9236_().m_6815_(id.intValue());
            }
        } else {
            entityReference = this.followedTarget;
        }
        if (entityReference != null && entityReference.m_6097_() && entityReference.m_6084_()) {
            return entityReference;
        }
        return entityReference;
    }

    public boolean m_6783_(double distance) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        boolean result = distance < (d0 *= 128.0) * d0;
        return result;
    }

    public Behaviour behaviour() {
        String string = (String)this.m_20088_().m_135370_(BEHAVIOUR);
        if (string == null || string.isEmpty()) {
            return Behaviour.FLY;
        }
        return Behaviour.valueOf(string);
    }

    public void m_8119_() {
        this.skipTravel = false;
        Entity entity = this.m_19749_();
        Behaviour behaviour = this.behaviour();
        if (this.m_9236_().f_46443_) {
            this.updateClientSideData();
        }
        if (!this.m_9236_().f_46443_) {
            if (this.getSpell() == null) {
                System.err.println("Spell Projectile safeguard termination, failed to resolve spell: " + this.spellId);
                this.m_6074_();
                return;
            }
            switch (behaviour) {
                case FLY: {
                    if (!(this.f_19788_ >= this.range) && this.f_19797_ <= 1200) break;
                    this.m_6074_();
                    return;
                }
                case FALL: {
                    if ((double)this.f_19788_ >= (double)this.range * 0.98) {
                        this.finishFalling();
                        this.m_6074_();
                        return;
                    }
                    if (this.f_19797_ <= 1200) break;
                    this.m_6074_();
                    return;
                }
            }
            if (this.f_19788_ >= this.range || this.f_19797_ > 1200) {
                this.m_6074_();
                return;
            }
        }
        this.previousVelocity = new Vec3(this.m_20184_().f_82479_, this.m_20184_().f_82480_, this.m_20184_().f_82481_);
        if (this.m_9236_().f_46443_ || (entity == null || !entity.m_213877_()) && this.m_9236_().m_46805_(this.m_20183_())) {
            HitResult hitResult;
            super.m_8119_();
            if (!this.m_9236_().f_46443_ && (hitResult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0))).m_6662_() != HitResult.Type.MISS) {
                switch (behaviour) {
                    case FLY: {
                        boolean shouldCollideWithEntity = true;
                        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
                            Entity entity2;
                            Entity target = ((EntityHitResult)hitResult).m_82443_();
                            Spell spell = this.getSpell();
                            if (SpellEngineMod.config.projectiles_pass_thru_irrelevant_targets && spell != null && spell.impact.length > 0 && (entity2 = this.m_19749_()) instanceof LivingEntity) {
                                LivingEntity owner = (LivingEntity)entity2;
                                EnumSet<TargetHelper.Intent> intents = SpellHelper.intents(spell);
                                boolean intentAllows = false;
                                for (TargetHelper.Intent intent : intents) {
                                    intentAllows = intentAllows || TargetHelper.actionAllowed(TargetHelper.TargetingMode.DIRECT, intent, owner, target);
                                }
                                shouldCollideWithEntity = intentAllows;
                            }
                        }
                        if (shouldCollideWithEntity) {
                            this.m_6532_(hitResult);
                            break;
                        }
                        this.setFollowedTarget(null);
                        break;
                    }
                    case FALL: {
                        TwoWayCollisionChecker.CollisionResult result;
                        Entity target;
                        Function<Entity, TwoWayCollisionChecker.CollisionResult> reverse;
                        if (hitResult.m_6662_() != HitResult.Type.ENTITY || (reverse = ((TwoWayCollisionChecker)(target = ((EntityHitResult)hitResult).m_82443_())).getReverseCollisionChecker()) == null || (result = reverse.apply((Entity)this)) != TwoWayCollisionChecker.CollisionResult.COLLIDE) break;
                        this.finishFalling();
                    }
                }
            }
            this.m_20101_();
            if (!this.skipTravel) {
                Spell.ProjectileData data;
                this.followTarget();
                Vec3 velocity = this.m_20184_();
                double d = this.m_20185_() + velocity.f_82479_;
                double e = this.m_20186_() + velocity.f_82480_;
                double f = this.m_20189_() + velocity.f_82481_;
                ProjectileUtil.m_37284_((Entity)this, (float)0.2f);
                float g = this.getDrag();
                if (this.m_20069_()) {
                    for (int i = 0; i < 4; ++i) {
                        float h = 0.25f;
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, d - velocity.f_82479_ * 0.25, e - velocity.f_82480_ * 0.25, f - velocity.f_82481_ * 0.25, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
                    }
                    g = 0.8f;
                }
                if ((data = this.projectileData()) != null) {
                    if (this.m_9236_().f_46443_) {
                        for (ParticleBatch travel_particles : data.client_data.travel_particles) {
                            ParticleHelper.play(this.m_9236_(), (Entity)this, this.m_146908_(), this.m_146909_(), travel_particles);
                        }
                    } else if (data.travel_sound != null && this.f_19797_ % data.travel_sound_interval == 0) {
                        SoundHelper.playSound(this.m_9236_(), (Entity)this, data.travel_sound);
                    }
                }
                this.m_6034_(d, e, f);
                this.f_19788_ = (float)((double)this.f_19788_ + velocity.m_82553_());
            }
        } else {
            this.m_146870_();
        }
    }

    private void finishFalling() {
        Entity owner = this.m_19749_();
        if (owner == null || owner.m_213877_()) {
            return;
        }
        if (owner instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)owner;
            SpellHelper.fallImpact(livingEntity, (Entity)this, this.getSpellInfo(), this.context.position(this.m_20182_()));
        }
    }

    private void followTarget() {
        Entity target = this.getFollowedTarget();
        if (target != null && this.projectileData().homing_angle > 0.0f) {
            Vec3 distanceVector = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0).m_82546_(this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0));
            Vec3 newVelocity = VectorHelper.rotateTowards(this.m_20184_(), distanceVector, this.projectileData().homing_angle);
            if (newVelocity.m_82556_() > 0.0) {
                this.m_20256_(newVelocity);
                this.f_19812_ = true;
            }
        }
    }

    protected float getDrag() {
        return 0.95f;
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity;
        Entity target;
        if (!this.m_9236_().f_46443_ && (target = entityHitResult.m_82443_()) != null && !this.impactHistory.contains(target.m_19879_()) && this.m_19749_() != null && (entity = this.m_19749_()) instanceof LivingEntity) {
            boolean performed;
            LivingEntity caster = (LivingEntity)entity;
            this.setFollowedTarget(null);
            SpellHelper.ImpactContext context = this.context;
            if (context == null) {
                context = new SpellHelper.ImpactContext();
            }
            if (performed = SpellHelper.projectileImpact(caster, (Entity)this, target, this.getSpellInfo(), context.position(entityHitResult.m_82450_()))) {
                this.chainReactionFrom(target);
                if (this.ricochetFrom(target, caster)) {
                    return;
                }
                if (this.pierced(target)) {
                    return;
                }
                this.m_6074_();
            }
        }
    }

    protected boolean ricochetFrom(Entity target, LivingEntity caster) {
        if (this.perks == null || this.perks.ricochet <= 0) {
            return false;
        }
        this.impactHistory.add(target.m_19879_());
        AABB box = this.m_20191_().m_82377_((double)this.perks.ricochet_range, (double)this.perks.ricochet_range, (double)this.perks.ricochet_range);
        EnumSet<TargetHelper.Intent> intents = SpellHelper.intents(this.getSpell());
        Predicate<Entity> intentMatches = entity -> {
            boolean intentAllows = false;
            for (TargetHelper.Intent intent : intents) {
                intentAllows = intentAllows || TargetHelper.actionAllowed(TargetHelper.TargetingMode.AREA, intent, caster, entity);
            }
            return intentAllows;
        };
        List otherTargets = this.m_9236_().m_6249_((Entity)this, box, entity -> entity.m_6097_() && entity instanceof LivingEntity && !this.impactHistory.contains(entity.m_19879_()) && intentMatches.test((Entity)entity) && !entity.m_20182_().equals((Object)target.m_20182_()));
        if (otherTargets.isEmpty()) {
            this.setFollowedTarget(null);
            return false;
        }
        otherTargets.sort(Comparator.comparingDouble(o -> o.m_20280_(target)));
        Entity newTarget = (Entity)otherTargets.get(0);
        this.setFollowedTarget(newTarget);
        Vec3 distanceVector = newTarget.m_20182_().m_82520_(0.0, (double)(newTarget.m_20206_() / 2.0f), 0.0).m_82546_(this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0));
        Vec3 newVelocity = distanceVector.m_82541_().m_82490_(this.m_20184_().m_82553_());
        this.m_20256_(newVelocity);
        this.f_19812_ = true;
        --this.perks.ricochet;
        if (this.perks.bounce_ricochet_sync) {
            --this.perks.bounce;
        }
        return true;
    }

    private boolean pierced(Entity target) {
        if (this.perks == null || this.perks.pierce <= 0) {
            return false;
        }
        this.impactHistory.add(target.m_19879_());
        this.setFollowedTarget(null);
        --this.perks.pierce;
        return true;
    }

    private boolean bounceFrom(BlockHitResult blockHitResult) {
        if (this.perks == null || this.perks.bounce <= 0) {
            return false;
        }
        Vec3 previousPosition = this.m_20182_();
        Vec3 previousDirection = this.m_20184_();
        Vec3 impactPosition = blockHitResult.m_82450_();
        Direction impactSide = blockHitResult.m_82434_();
        double speed = this.m_20184_().m_82553_();
        Vec3 surfaceNormal = this.getSurfaceNormal(impactSide);
        Vec3 newDirection = this.calculateBounceVector(previousDirection, surfaceNormal);
        double remainingDistance = previousDirection.m_82553_() - impactPosition.m_82546_(previousPosition).m_82553_();
        Vec3 finalPosition = impactPosition.m_82549_(newDirection.m_82541_().m_82490_(remainingDistance));
        this.m_20343_(finalPosition.m_7096_(), finalPosition.m_7098_(), finalPosition.m_7094_());
        this.m_20256_(newDirection.m_82490_(speed));
        ProjectileUtil.m_37284_((Entity)this, (float)0.2f);
        --this.perks.bounce;
        if (this.perks.bounce_ricochet_sync) {
            --this.perks.ricochet;
        }
        this.f_19812_ = true;
        this.skipTravel = true;
        return true;
    }

    public Vec3 calculateBounceVector(Vec3 previousDirection, Vec3 normal) {
        return previousDirection.m_82546_(normal.m_82490_(2.0 * previousDirection.m_82526_(normal)));
    }

    public Vec3 getSurfaceNormal(Direction blockSide) {
        return switch (blockSide) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> new Vec3(0.0, -1.0, 0.0);
            case Direction.UP -> new Vec3(0.0, 1.0, 0.0);
            case Direction.NORTH -> new Vec3(0.0, 0.0, -1.0);
            case Direction.SOUTH -> new Vec3(0.0, 0.0, 1.0);
            case Direction.WEST -> new Vec3(-1.0, 0.0, 0.0);
            case Direction.EAST -> new Vec3(1.0, 0.0, 0.0);
        };
    }

    private void chainReactionFrom(Entity target) {
        if (this.perks == null || this.perks.chain_reaction_size <= 0 || this.perks.chain_reaction_triggers <= 0 || this.impactHistory.contains(target)) {
            return;
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        Spell spell = this.getSpell();
        Vec3 position = this.m_20182_();
        int spawnCount = this.perks.chain_reaction_size;
        Vec3 launchVector = new Vec3(1.0, 0.0, 0.0).m_82490_(this.m_20184_().m_82553_());
        int launchAngle = 360 / spawnCount;
        float launchAngleOffset = random.nextFloat() * (float)launchAngle;
        this.impactHistory.add(target.m_19879_());
        --this.perks.chain_reaction_triggers;
        this.perks.chain_reaction_size += this.perks.chain_reaction_increment;
        for (int i = 0; i < spawnCount; ++i) {
            SpellProjectile projectile = new SpellProjectile(this.m_9236_(), (LivingEntity)this.m_19749_(), position.m_7096_(), position.m_7098_(), position.m_7094_(), this.behaviour(), this.spellId, null, this.context, this.perks.copy());
            float angle = (float)(launchAngle * i) + launchAngleOffset;
            projectile.m_20256_(launchVector.m_82524_((float)Math.toRadians(angle)));
            projectile.range = spell.range;
            ProjectileUtil.m_37284_((Entity)projectile, (float)0.2f);
            projectile.impactHistory = new HashSet<Integer>(this.impactHistory);
            this.m_9236_().m_7967_((Entity)projectile);
        }
    }

    public Spell getSpell() {
        return SpellRegistry.getSpell(this.spellId);
    }

    public SpellInfo getSpellInfo() {
        return new SpellInfo(this.getSpell(), this.spellId);
    }

    public SpellHelper.ImpactContext getImpactContext() {
        return this.context;
    }

    public ResourceLocation getItemModelId() {
        return this.itemModelId;
    }

    public ItemStack getItemStackModel() {
        return this.itemStackModel;
    }

    @Override
    public Spell.ProjectileModel renderData() {
        Spell.ProjectileData data = this.projectileData();
        if (data != null && data.client_data != null) {
            return data.client_data.model;
        }
        return null;
    }

    public ItemStack m_7846_() {
        Spell.ProjectileData data = this.projectileData();
        if (data != null && data.client_data != null && data.client_data.model != null) {
            return ((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(data.client_data.model.model_id))).m_7968_();
        }
        return ItemStack.f_41583_;
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (this.bounceFrom(blockHitResult)) {
            return;
        }
        this.m_6074_();
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        Gson gson = new Gson();
        nbt.m_128359_(NBT_SPELL_ID, gson.toJson((Object)this.spellId));
        nbt.m_128359_(NBT_IMPACT_CONTEXT, gson.toJson((Object)this.context));
        nbt.m_128359_(NBT_PERKS, gson.toJson((Object)this.perks));
        if (this.itemModelId != null) {
            nbt.m_128359_(NBT_ITEM_MODEL_ID, this.itemModelId.toString());
        }
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_(NBT_SPELL_ID, 8)) {
            try {
                Gson gson = new Gson();
                this.spellId = new ResourceLocation(nbt.m_128461_(NBT_SPELL_ID));
                Gson recordReader = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new RecordsWithGson.RecordTypeAdapterFactory()).create();
                this.context = (SpellHelper.ImpactContext)recordReader.fromJson(nbt.m_128461_(NBT_IMPACT_CONTEXT), SpellHelper.ImpactContext.class);
                this.perks = (Spell.ProjectileData.Perks)gson.fromJson(nbt.m_128461_(NBT_PERKS), Spell.ProjectileData.Perks.class);
                if (nbt.m_128425_(NBT_ITEM_MODEL_ID, 8)) {
                    this.updateItemModel(nbt.m_128461_(NBT_ITEM_MODEL_ID));
                }
            }
            catch (Exception e) {
                System.err.println("SpellProjectile - Failed to read spell data from NBT");
            }
        }
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(CLIENT_DATA, (Object)"");
        this.m_20088_().m_135372_(TARGET_ID, (Object)0);
        this.m_20088_().m_135372_(BEHAVIOUR, (Object)Behaviour.FLY.toString());
        this.m_20088_().m_135372_(ITEM_MODEL_ID, (Object)"");
    }

    static {
        random = new Random();
        NBT_SPELL_ID = "Spell.ID";
        NBT_PERKS = "Perks";
        NBT_IMPACT_CONTEXT = "Impact.Context";
        NBT_ITEM_MODEL_ID = "Item.Model.ID";
        CLIENT_DATA = SynchedEntityData.m_135353_(SpellProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
        TARGET_ID = SynchedEntityData.m_135353_(SpellProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        BEHAVIOUR = SynchedEntityData.m_135353_(SpellProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
        ITEM_MODEL_ID = SynchedEntityData.m_135353_(SpellProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    }

    public static enum Behaviour {
        FLY,
        FALL;

    }
}

