/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.entity;

import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Level;
import net.spell_engine.api.spell.ParticleBatch;
import net.spell_engine.api.spell.Sound;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellInfo;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.particle.ParticleHelper;
import net.spell_engine.utils.SoundPlayerWorld;
import org.jetbrains.annotations.Nullable;

public class SpellCloud
extends Entity
implements TraceableEntity {
    public static EntityType<SpellCloud> ENTITY_TYPE;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUuid;
    private int timeToLive;
    private ResourceLocation spellId;
    private int dataIndex = 0;
    private SpellHelper.ImpactContext context;
    private static final EntityDataAccessor<String> SPELL_ID_TRACKER;
    private static final EntityDataAccessor<Integer> DATA_INDEX_TRACKER;
    private static final EntityDataAccessor<Float> RADIUS_TRACKER;
    private boolean presenceSoundFired = false;

    public SpellCloud(EntityType<? extends SpellCloud> entityType, Level world) {
        super(entityType, world);
    }

    public SpellCloud(Level world) {
        super(ENTITY_TYPE, world);
        this.f_19794_ = true;
    }

    public void onCreatedFromSpell(ResourceLocation spellId, Spell.Release.Target.Cloud cloudData, SpellHelper.ImpactContext context) {
        this.spellId = spellId;
        this.context = context;
        Spell spell = this.getSpell();
        if (spell != null) {
            int index = -1;
            List<Spell.Release.Target.Cloud> dataList = List.of(spell.release.target.clouds);
            if (!dataList.isEmpty()) {
                index = dataList.indexOf(cloudData);
            }
            this.dataIndex = index;
        }
        this.m_20088_().m_135381_(SPELL_ID_TRACKER, (Object)this.spellId.toString());
        this.m_20088_().m_135381_(DATA_INDEX_TRACKER, (Object)this.dataIndex);
        this.m_20088_().m_135381_(RADIUS_TRACKER, (Object)Float.valueOf(this.calculateRadius()));
        this.timeToLive = (int)(cloudData.time_to_live_seconds * 20.0f);
    }

    private float calculateRadius() {
        Spell.Release.Target.Cloud cloudData = this.getCloudData();
        if (cloudData != null) {
            float radius = cloudData.volume.radius;
            if (this.context != null) {
                radius = cloudData.volume.combinedRadius(this.context.power());
            }
            return radius;
        }
        return 0.0f;
    }

    public EntityDimensions m_6972_(Pose pose) {
        Spell.Release.Target.Cloud cloudData = this.getCloudData();
        if (cloudData != null) {
            Float radius = (Float)this.m_20088_().m_135370_(RADIUS_TRACKER);
            float heightMultiplier = cloudData.volume.area.vertical_range_multiplier;
            return EntityDimensions.m_20395_((float)(radius.floatValue() * 2.0f), (float)(radius.floatValue() * heightMultiplier));
        }
        return super.m_6972_(pose);
    }

    public void setOwner(@Nullable LivingEntity owner) {
        this.owner = owner;
        this.ownerUuid = owner == null ? null : owner.m_20148_();
    }

    @Nullable
    public Entity m_19749_() {
        Entity entity;
        if (this.owner == null && this.ownerUuid != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUuid)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(SPELL_ID_TRACKER, (Object)"");
        this.m_20088_().m_135372_(DATA_INDEX_TRACKER, (Object)this.dataIndex);
        this.m_20088_().m_135372_(RADIUS_TRACKER, (Object)Float.valueOf(0.0f));
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        super.m_7350_(data);
        String rawSpellId = (String)this.m_20088_().m_135370_(SPELL_ID_TRACKER);
        if (rawSpellId != null && !rawSpellId.isEmpty()) {
            this.spellId = new ResourceLocation(rawSpellId);
        }
        this.dataIndex = (Integer)this.m_20088_().m_135370_(DATA_INDEX_TRACKER);
        this.m_6210_();
    }

    protected void m_7378_(CompoundTag nbt) {
        this.f_19797_ = nbt.m_128451_(NBTKey.AGE.key);
        this.timeToLive = nbt.m_128451_(NBTKey.TIME_TO_LIVE.key);
        this.spellId = new ResourceLocation(nbt.m_128461_(NBTKey.SPELL_ID.key));
        this.dataIndex = nbt.m_128451_(NBTKey.DATA_INDEX.key);
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128405_(NBTKey.AGE.key, this.f_19797_);
        nbt.m_128405_(NBTKey.TIME_TO_LIVE.key, this.timeToLive);
        nbt.m_128359_(NBTKey.SPELL_ID.key, this.spellId.toString());
        nbt.m_128405_(NBTKey.DATA_INDEX.key, this.dataIndex);
    }

    public boolean m_20067_() {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        Spell.Release.Target.Cloud cloudData = this.getCloudData();
        if (cloudData == null) {
            return;
        }
        Level world = this.m_9236_();
        if (world.f_46443_) {
            Spell.Release.Target.Cloud.ClientData clientData = cloudData.client_data;
            for (ParticleBatch particleBatch : clientData.particles) {
                ParticleHelper.play(world, (Entity)this, particleBatch);
            }
            Sound presence_sound = cloudData.presence_sound;
            if (!this.presenceSoundFired && presence_sound != null) {
                SoundEvent soundEvent = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(presence_sound.id()));
                ((SoundPlayerWorld)world).playSoundFromEntity(this, soundEvent, SoundSource.PLAYERS, presence_sound.volume(), presence_sound.randomizedPitch());
                this.presenceSoundFired = true;
            }
        } else {
            if (this.f_19797_ >= this.timeToLive) {
                this.m_146870_();
                return;
            }
            if (this.f_19797_ % cloudData.impact_tick_interval == 0) {
                Spell.AreaImpact area_impact = cloudData.volume;
                LivingEntity owner = (LivingEntity)this.m_19749_();
                Spell spell = this.getSpell();
                if (area_impact != null && owner != null && spell != null) {
                    SpellHelper.ImpactContext context = this.context;
                    if (context == null) {
                        context = new SpellHelper.ImpactContext();
                    }
                    SpellHelper.lookupAndPerformAreaImpact(area_impact, new SpellInfo(spell, this.spellId), owner, null, this, context.position(this.m_20182_()), true);
                }
            }
        }
    }

    @Nullable
    public Spell.Release.Target.Cloud getCloudData() {
        Spell spell = this.getSpell();
        if (spell != null) {
            if (spell.release.target.clouds.length > 0) {
                return spell.release.target.clouds[this.dataIndex];
            }
            return spell.release.target.cloud;
        }
        return null;
    }

    public Spell getSpell() {
        return SpellRegistry.getSpell(this.spellId);
    }

    static {
        SPELL_ID_TRACKER = SynchedEntityData.m_135353_(SpellCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
        DATA_INDEX_TRACKER = SynchedEntityData.m_135353_(SpellCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        RADIUS_TRACKER = SynchedEntityData.m_135353_(SpellCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    }

    private static enum NBTKey {
        AGE("Age"),
        TIME_TO_LIVE("TTL"),
        SPELL_ID("SpellId"),
        DATA_INDEX("DataIndex");

        public final String key;

        private NBTKey(String key) {
            this.key = key;
        }
    }
}

