/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.config;

import java.util.List;
import net.minecraft.world.phys.Vec2;
import net.spell_engine.client.gui.HudElement;

public class HudConfig {
    public CastBar castbar;
    public HudElement hotbar;
    public HudElement error_message;
    public static final List<HudConfig> presets = List.of(HudConfig.overXPBar(), HudConfig.preset(HudElement.Origin.TOP_LEFT), HudConfig.preset(HudElement.Origin.TOP), HudConfig.preset(HudElement.Origin.TOP_RIGHT), HudConfig.preset(HudElement.Origin.BOTTOM_RIGHT), HudConfig.preset(HudElement.Origin.BOTTOM), HudConfig.preset(HudElement.Origin.BOTTOM_LEFT));

    public HudConfig() {
    }

    public HudConfig(CastBar castbar, HudElement hotbar, HudElement error_message) {
        this.castbar = castbar;
        this.hotbar = hotbar;
        this.error_message = error_message;
    }

    public HudConfig copy() {
        return new HudConfig(this.castbar.copy(), this.hotbar.copy(), this.error_message.copy());
    }

    public static HudElement defaultHotBar() {
        return new HudElement(HudElement.Origin.BOTTOM, new Vec2(-170.0f, -11.0f));
    }

    public static HudElement defaultErrorMessage() {
        return new HudElement(HudElement.Origin.BOTTOM, new Vec2(0.0f, -80.0f));
    }

    public static HudConfig createDefault() {
        return presets.get(0).copy();
    }

    private static HudConfig overXPBar() {
        return new HudConfig(new CastBar(new HudElement(HudElement.Origin.BOTTOM, new Vec2(0.0f, -27.0f)), new Part(false, new Vec2(0.0f, -12.0f)), new Part(true, new Vec2(-8.0f, -25.0f)), 172), HudConfig.defaultHotBar(), HudConfig.defaultErrorMessage());
    }

    private static HudConfig preset(HudElement.Origin origin) {
        int offsetW = 70;
        int offsetH = 16;
        int barWidth = 90;
        Vec2 offset = new Vec2(0.0f, 0.0f);
        Part target = new Part();
        Part icon = new Part();
        switch (origin) {
            case TOP: {
                offset = new Vec2(0.0f, (float)offsetH);
                target.offset = HudConfig.targetOffsetDown();
                icon.offset = HudConfig.iconRight(barWidth);
                break;
            }
            case TOP_LEFT: {
                offset = new Vec2((float)(offsetW - 8), (float)offsetH);
                target.offset = HudConfig.targetOffsetDown();
                icon.offset = HudConfig.iconRight(barWidth);
                break;
            }
            case TOP_RIGHT: {
                offset = new Vec2((float)(-1 * offsetW + 8), (float)offsetH);
                target.offset = HudConfig.targetOffsetDown();
                icon.offset = HudConfig.iconLeft(barWidth);
                break;
            }
            case BOTTOM: {
                offset = new Vec2(0.0f, (float)(-1 * offsetH));
                target.offset = HudConfig.targetOffsetUp();
                icon.offset = HudConfig.iconRight(barWidth);
                break;
            }
            case BOTTOM_LEFT: {
                offset = new Vec2((float)(offsetW - 8), (float)(-1 * offsetH));
                target.offset = HudConfig.targetOffsetUp();
                icon.offset = HudConfig.iconRight(barWidth);
                break;
            }
            case BOTTOM_RIGHT: {
                offset = new Vec2((float)(-1 * offsetW + 8), (float)(-1 * offsetH));
                target.offset = HudConfig.targetOffsetUp();
                icon.offset = HudConfig.iconLeft(barWidth);
            }
        }
        return new HudConfig(new CastBar(new HudElement(origin, offset), target, icon, barWidth), HudConfig.defaultHotBar(), HudConfig.defaultErrorMessage());
    }

    private static Vec2 targetOffsetUp() {
        return new Vec2(0.0f, -12.0f);
    }

    private static Vec2 targetOffsetDown() {
        return new Vec2(0.0f, 12.0f);
    }

    private static Vec2 iconLeft(int barWidth) {
        return new Vec2((float)(-(barWidth / 2) - 10 - 16), -6.0f);
    }

    private static Vec2 iconRight(int barWidth) {
        return new Vec2((float)(barWidth / 2 + 10), -6.0f);
    }

    public boolean isValid() {
        return this.castbar != null && this.hotbar != null && this.error_message != null;
    }

    public static class CastBar {
        public HudElement base;
        public Part target;
        public Part icon;
        public int width;

        public CastBar() {
        }

        public CastBar(HudElement base, Part target, Part icon, int bar_width) {
            this.base = base;
            this.target = target;
            this.icon = icon;
            this.width = bar_width;
        }

        public CastBar copy() {
            return new CastBar(this.base.copy(), this.target.copy(), this.icon.copy(), this.width);
        }
    }

    public static class Part {
        public boolean visible = true;
        public Vec2 offset = Vec2.f_82462_;

        public Part() {
        }

        public Part(boolean visible, Vec2 offset) {
            this.visible = visible;
            this.offset = offset;
        }

        public Part copy() {
            return new Part(this.visible, new Vec2(this.offset.f_82470_, this.offset.f_82471_));
        }
    }
}

