/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.spell_engine.api.render.CustomLayers;
import net.spell_engine.api.render.LightEmission;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class BeamRenderer
extends RenderType {
    public BeamRenderer(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
        super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
    }

    public static void renderBeam(PoseStack matrices, MultiBufferSource vertexConsumers, ResourceLocation texture, long time, float tickDelta, float direction, boolean center, int red, int green, int blue, int alpha, float yOffset, float height, float width) {
        matrices.m_85836_();
        float shift = (float)Math.floorMod(time, 40) + tickDelta;
        float offset = Mth.m_14187_((float)(shift * 0.2f - (float)Mth.m_14143_((float)(shift * 0.1f)))) * -direction;
        RenderType outerRenderLayer = CustomLayers.beam(texture, false, true);
        RenderType innerRenderLayer = CustomLayers.spellObject(texture, LightEmission.RADIATE, false);
        float originalWidth = width;
        if (center) {
            BeamRenderer.renderBeamLayer(matrices, vertexConsumers.m_6299_(innerRenderLayer), red, green, blue, alpha, yOffset, height, 0.0f, width, width, 0.0f, -width, 0.0f, 0.0f, -width, 0.0f, 1.0f, height, offset);
        }
        width = originalWidth * 1.5f;
        BeamRenderer.renderBeamLayer(matrices, vertexConsumers.m_6299_(outerRenderLayer), red, green, blue, (int)((double)alpha * 0.75), yOffset, height, 0.0f, width, width, 0.0f, -width, 0.0f, 0.0f, -width, 0.0f, 1.0f, height, offset * 0.9f);
        width = originalWidth * 2.0f;
        BeamRenderer.renderBeamLayer(matrices, vertexConsumers.m_6299_(outerRenderLayer), red, green, blue, alpha / 3, yOffset, height, 0.0f, width, width, 0.0f, -width, 0.0f, 0.0f, -width, 0.0f, 1.0f, height, offset * 0.8f);
        matrices.m_85849_();
    }

    private static void renderBeamLayer(PoseStack matrices, VertexConsumer vertices, int red, int green, int blue, int alpha, float yOffset, float height, float x1, float z1, float x2, float z2, float x3, float z3, float x4, float z4, float u1, float u2, float v1, float v2) {
        PoseStack.Pose entry = matrices.m_85850_();
        Matrix4f matrix4f = entry.m_252922_();
        Matrix3f matrix3f = entry.m_252943_();
        BeamRenderer.renderBeamFace(matrix4f, matrix3f, vertices, red, green, blue, alpha, yOffset, height, x1, z1, x2, z2, u1, u2, v1, v2);
        BeamRenderer.renderBeamFace(matrix4f, matrix3f, vertices, red, green, blue, alpha, yOffset, height, x4, z4, x3, z3, u1, u2, v1, v2);
        BeamRenderer.renderBeamFace(matrix4f, matrix3f, vertices, red, green, blue, alpha, yOffset, height, x2, z2, x4, z4, u1, u2, v1, v2);
        BeamRenderer.renderBeamFace(matrix4f, matrix3f, vertices, red, green, blue, alpha, yOffset, height, x3, z3, x1, z1, u1, u2, v1, v2);
    }

    private static void renderBeamFace(Matrix4f positionMatrix, Matrix3f normalMatrix, VertexConsumer vertices, int red, int green, int blue, int alpha, float yOffset, float height, float x1, float z1, float x2, float z2, float u1, float u2, float v1, float v2) {
        BeamRenderer.renderBeamVertex(positionMatrix, normalMatrix, vertices, red, green, blue, alpha, height, x1, z1, u2, v1);
        BeamRenderer.renderBeamVertex(positionMatrix, normalMatrix, vertices, red, green, blue, alpha, yOffset, x1, z1, u2, v2);
        BeamRenderer.renderBeamVertex(positionMatrix, normalMatrix, vertices, red, green, blue, alpha, yOffset, x2, z2, u1, v2);
        BeamRenderer.renderBeamVertex(positionMatrix, normalMatrix, vertices, red, green, blue, alpha, height, x2, z2, u1, v1);
    }

    private static void renderBeamVertex(Matrix4f positionMatrix, Matrix3f normalMatrix, VertexConsumer vertices, int red, int green, int blue, int alpha, float y, float x, float z, float u, float v) {
        vertices.m_252986_(positionMatrix, x, y, z).m_6122_(red, green, blue, alpha).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

